/*
 * Decompiled with CFR 0.152.
 */
package retrofit2.converter.jackson;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonRequestBodyConverter;
import retrofit2.converter.jackson.JacksonResponseBodyConverter;

public final class JacksonConverterFactory
extends Converter.Factory {
    private static final MediaType DEFAULT_MEDIA_TYPE = MediaType.get((String)"application/json; charset=UTF-8");
    private final ObjectMapper mapper;
    private final MediaType mediaType;
    private final boolean streaming;

    public static JacksonConverterFactory create() {
        return new JacksonConverterFactory(new ObjectMapper(), DEFAULT_MEDIA_TYPE, false);
    }

    public static JacksonConverterFactory create(ObjectMapper mapper) {
        return JacksonConverterFactory.create(mapper, DEFAULT_MEDIA_TYPE);
    }

    public static JacksonConverterFactory create(ObjectMapper mapper, MediaType mediaType) {
        if (mapper == null) {
            throw new NullPointerException("mapper == null");
        }
        if (mediaType == null) {
            throw new NullPointerException("mediaType == null");
        }
        return new JacksonConverterFactory(mapper, mediaType, false);
    }

    private JacksonConverterFactory(ObjectMapper mapper, MediaType mediaType, boolean streaming) {
        this.mapper = mapper;
        this.mediaType = mediaType;
        this.streaming = streaming;
    }

    public JacksonConverterFactory withStreaming() {
        return new JacksonConverterFactory(this.mapper, this.mediaType, true);
    }

    public Converter<ResponseBody, ?> responseBodyConverter(Type type, Annotation[] annotations, Retrofit retrofit) {
        JavaType javaType = this.mapper.getTypeFactory().constructType(type);
        ObjectReader reader = this.mapper.readerFor(javaType);
        return new JacksonResponseBodyConverter(reader);
    }

    public Converter<?, RequestBody> requestBodyConverter(Type type, Annotation[] parameterAnnotations, Annotation[] methodAnnotations, Retrofit retrofit) {
        JavaType javaType = this.mapper.getTypeFactory().constructType(type);
        ObjectWriter writer = this.mapper.writerFor(javaType);
        return new JacksonRequestBodyConverter(writer, this.mediaType, this.streaming);
    }
}

