/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.server.AutoTopicCreationManager;
import kafka.server.ControllerMutationQuota;
import kafka.server.ForwardingManager$;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.coordinator.group.GroupCoordinator;
import org.apache.kafka.coordinator.share.ShareCoordinator;
import org.apache.kafka.coordinator.transaction.TransactionLogConfig;
import org.apache.kafka.server.common.ControllerRequestCompletionHandler;
import org.apache.kafka.server.common.NodeToControllerChannelManager;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015f\u0001B\t\u0013\u0001]A\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\tY\u0001\u0011\t\u0011)A\u0005[!A\u0011\b\u0001B\u0001B\u0003%!\b\u0003\u0005C\u0001\t\u0005\t\u0015!\u0003D\u0011!Q\u0005A!A!\u0002\u0013Y\u0005\"B)\u0001\t\u0003\u0011\u0006bB-\u0001\u0005\u0004%IA\u0017\u0005\u0007]\u0002\u0001\u000b\u0011B.\t\u000b=\u0004A\u0011\t9\t\u000f\u0005}\u0002\u0001\"\u0011\u0002B!9\u00111\r\u0001\u0005\n\u0005\u0015\u0004bBA7\u0001\u0011%\u0011q\u000e\u0005\b\u0003g\u0002A\u0011BA;\u0011\u001d\tY\b\u0001C\u0005\u0003{Bq!!$\u0001\t\u0013\ty\tC\u0004\u0002\u001a\u0002!I!a'\u0003?\u0011+g-Y;mi\u0006+Ho\u001c+pa&\u001c7I]3bi&|g.T1oC\u001e,'O\u0003\u0002\u0014)\u000511/\u001a:wKJT\u0011!F\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001\u0001D\b\u0012\u0011\u0005eaR\"\u0001\u000e\u000b\u0003m\tQa]2bY\u0006L!!\b\u000e\u0003\r\u0005s\u0017PU3g!\ty\u0002%D\u0001\u0013\u0013\t\t#C\u0001\rBkR|Gk\u001c9jG\u000e\u0013X-\u0019;j_:l\u0015M\\1hKJ\u0004\"a\t\u0014\u000e\u0003\u0011R!!\n\u000b\u0002\u000bU$\u0018\u000e\\:\n\u0005\u001d\"#a\u0002'pO\u001eLgnZ\u0001\u0007G>tg-[4\u0011\u0005}Q\u0013BA\u0016\u0013\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u001d\rD\u0017M\u001c8fY6\u000bg.Y4feB\u0011afN\u0007\u0002_)\u0011\u0001'M\u0001\u0007G>lWn\u001c8\u000b\u0005M\u0011$BA\u000b4\u0015\t!T'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002m\u0005\u0019qN]4\n\u0005az#A\b(pI\u0016$vnQ8oiJ|G\u000e\\3s\u0007\"\fgN\\3m\u001b\u0006t\u0017mZ3s\u0003A9'o\\;q\u0007>|'\u000fZ5oCR|'\u000f\u0005\u0002<\u00016\tAH\u0003\u0002>}\u0005)qM]8va*\u0011qHM\u0001\fG>|'\u000fZ5oCR|'/\u0003\u0002By\t\u0001rI]8va\u000e{wN\u001d3j]\u0006$xN]\u0001\u000fibt7i\\8sI&t\u0017\r^8s!\t!\u0005*D\u0001F\u0015\t1u)A\u0006ue\u0006t7/Y2uS>t'BA \u0015\u0013\tIUI\u0001\fUe\u0006t7/Y2uS>t7i\\8sI&t\u0017\r^8s\u0003A\u0019\b.\u0019:f\u0007>|'\u000fZ5oCR|'\u000f\u0005\u0002M\u001f6\tQJ\u0003\u0002O}\u0005)1\u000f[1sK&\u0011\u0001+\u0014\u0002\u0011'\"\f'/Z\"p_J$\u0017N\\1u_J\fa\u0001P5oSRtDCB*U+Z;\u0006\f\u0005\u0002 \u0001!)\u0001F\u0002a\u0001S!)AF\u0002a\u0001[!)\u0011H\u0002a\u0001u!)!I\u0002a\u0001\u0007\")!J\u0002a\u0001\u0017\u0006q\u0011N\u001c4mS\u001eDG\u000fV8qS\u000e\u001cX#A.\u0011\u0007q\u000b7-D\u0001^\u0015\tqv,\u0001\u0003vi&d'\"\u00011\u0002\t)\fg/Y\u0005\u0003Ev\u00131aU3u!\t!7N\u0004\u0002fSB\u0011aMG\u0007\u0002O*\u0011\u0001NF\u0001\u0007yI|w\u000e\u001e \n\u0005)T\u0012A\u0002)sK\u0012,g-\u0003\u0002m[\n11\u000b\u001e:j]\u001eT!A\u001b\u000e\u0002\u001f%tg\r\\5hQR$v\u000e]5dg\u0002\nAb\u0019:fCR,Gk\u001c9jGN$r!]A\f\u0003?\tI\u0003E\u0002sk^l\u0011a\u001d\u0006\u0003ij\t!bY8mY\u0016\u001cG/[8o\u0013\t18OA\u0002TKF\u00042\u0001_A\t\u001d\rI\u00181\u0002\b\u0004u\u0006\u0015abA>\u0002\u00049\u0019A0!\u0001\u000f\u0005u|hB\u00014\u007f\u0013\u00051\u0014B\u0001\u001b6\u0013\t)2'\u0003\u00021e%!\u0011qAA\u0005\u0003\u001diWm]:bO\u0016T!\u0001\r\u001a\n\t\u00055\u0011qB\u0001\u0015\u001b\u0016$\u0018\rZ1uCJ+7\u000f]8og\u0016$\u0015\r^1\u000b\t\u0005\u001d\u0011\u0011B\u0005\u0005\u0003'\t)BA\u000bNKR\fG-\u0019;b%\u0016\u001c\bo\u001c8tKR{\u0007/[2\u000b\t\u00055\u0011q\u0002\u0005\b\u00033I\u0001\u0019AA\u000e\u0003\u0019!x\u000e]5dgB!!/!\bd\u0013\t\u00117\u000fC\u0004\u0002\"%\u0001\r!a\t\u0002/\r|g\u000e\u001e:pY2,'/T;uCRLwN\\)v_R\f\u0007cA\u0010\u0002&%\u0019\u0011q\u0005\n\u0003/\r{g\u000e\u001e:pY2,'/T;uCRLwN\\)v_R\f\u0007bBA\u0016\u0013\u0001\u0007\u0011QF\u0001\u0017[\u0016$\u0018\rZ1uCJ+\u0017/^3ti\u000e{g\u000e^3yiB)\u0011$a\f\u00024%\u0019\u0011\u0011\u0007\u000e\u0003\r=\u0003H/[8o!\u0011\t)$a\u000f\u000e\u0005\u0005]\"\u0002BA\u001d\u0003\u0013\t\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u0003{\t9D\u0001\bSKF,Xm\u001d;D_:$X\r\u001f;\u00027\r\u0014X-\u0019;f'R\u0014X-Y7t\u0013:$XM\u001d8bYR{\u0007/[2t)\u0019\t\u0019%!\u0013\u0002`A\u0019\u0011$!\u0012\n\u0007\u0005\u001d#D\u0001\u0003V]&$\bbBA\r\u0015\u0001\u0007\u00111\n\t\u0007e\u000653-!\u0015\n\u0007\u0005=3OA\u0002NCB\u0004B!a\u0015\u0002Z9\u0019\u00110!\u0016\n\t\u0005]\u0013qB\u0001\u0018\u0007J,\u0017\r^3U_BL7m\u001d*fcV,7\u000f\u001e#bi\u0006LA!a\u0017\u0002^\tq1I]3bi\u0006\u0014G.\u001a+pa&\u001c'\u0002BA,\u0003\u001fAq!!\u0019\u000b\u0001\u0004\t\u0019$\u0001\bsKF,Xm\u001d;D_:$X\r\u001f;\u0002-M,g\u000eZ\"sK\u0006$X\rV8qS\u000e\u0014V-];fgR$R!]A4\u0003WBq!!\u001b\f\u0001\u0004\tY%A\bde\u0016\fG/\u00192mKR{\u0007/[2t\u0011\u001d\t\tg\u0003a\u0001\u0003[\tQc\u00197fCJLeN\u001a7jO\"$(+Z9vKN$8\u000f\u0006\u0003\u0002D\u0005E\u0004bBA5\u0019\u0001\u0007\u00111J\u0001\u000fGJ,\u0017\r^1cY\u0016$v\u000e]5d)\u0011\t\t&a\u001e\t\r\u0005eT\u00021\u0001d\u0003\u0015!x\u000e]5d\u0003}\u0019wN\u001c<feR$v\u000eV8qS\u000e\u001cuN\u001c4jO\u000e{G\u000e\\3di&|gn\u001d\u000b\u0005\u0003\u007f\n)\t\u0005\u0003\u0002T\u0005\u0005\u0015\u0002BAB\u0003;\u0012ad\u0011:fCR\f'\r\\3U_BL7mQ8oM&<7i\u001c7mK\u000e$\u0018n\u001c8\t\r!r\u0001\u0019AAD!\ra\u0016\u0011R\u0005\u0004\u0003\u0017k&A\u0003)s_B,'\u000f^5fg\u0006\u0001\u0012n\u001d,bY&$Gk\u001c9jG:\u000bW.\u001a\u000b\u0005\u0003#\u000b9\nE\u0002\u001a\u0003'K1!!&\u001b\u0005\u001d\u0011un\u001c7fC:Da!!\u001f\u0010\u0001\u0004\u0019\u0017!\u00064jYR,'o\u0011:fCR\f'\r\\3U_BL7m\u001d\u000b\u0005\u0003;\u000b\u0019\u000b\u0005\u0004\u001a\u0003?\u000bY%]\u0005\u0004\u0003CS\"A\u0002+va2,'\u0007C\u0004\u0002\u001aA\u0001\r!a\u0007")
public class DefaultAutoTopicCreationManager
implements AutoTopicCreationManager,
Logging {
    private final KafkaConfig config;
    private final NodeToControllerChannelManager channelManager;
    private final GroupCoordinator groupCoordinator;
    private final TransactionCoordinator txnCoordinator;
    private final ShareCoordinator shareCoordinator;
    private final java.util.Set<String> inflightTopics;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private java.util.Set<String> inflightTopics() {
        return this.inflightTopics;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Seq<MetadataResponseData.MetadataResponseTopic> createTopics(Set<String> topics, ControllerMutationQuota controllerMutationQuota, Option<RequestContext> metadataRequestContext) {
        void var6_6;
        void var5_5;
        Tuple2<Map<String, CreateTopicsRequestData.CreatableTopic>, Seq<MetadataResponseData.MetadataResponseTopic>> tuple2 = this.filterCreatableTopics(topics);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Map creatableTopics = (Map)tuple2._1();
        Seq uncreatableTopicResponses = (Seq)tuple2._2();
        Seq<MetadataResponseData.MetadataResponseTopic> creatableTopicResponses = var5_5.isEmpty() ? (Seq<MetadataResponseData.MetadataResponseTopic>)Seq$.MODULE$.empty() : this.sendCreateTopicRequest((Map<String, CreateTopicsRequestData.CreatableTopic>)var5_5, metadataRequestContext);
        return (Seq)var6_6.$plus$plus(creatableTopicResponses);
    }

    @Override
    public void createStreamsInternalTopics(Map<String, CreateTopicsRequestData.CreatableTopic> topics, RequestContext requestContext) {
        topics.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)DefaultAutoTopicCreationManager.$anonfun$createStreamsInternalTopics$1(check$ifrefutable$1))).foreach((Function1 & Serializable)x$2 -> {
            if (x$2 != null) {
                CreateTopicsRequestData.CreatableTopic creatableTopic = (CreateTopicsRequestData.CreatableTopic)x$2._2();
                if (creatableTopic.numPartitions() == -1) {
                    creatableTopic.setNumPartitions(Predef$.MODULE$.Integer2int($this.config.numPartitions()));
                }
                if (creatableTopic.replicationFactor() == -1) {
                    return creatableTopic.setReplicationFactor((short)$this.config.defaultReplicationFactor());
                }
                return BoxedUnit.UNIT;
            }
            throw new MatchError(null);
        });
        if (topics.nonEmpty()) {
            this.sendCreateTopicRequest(topics, (Option<RequestContext>)new Some((Object)requestContext));
            return;
        }
    }

    private Seq<MetadataResponseData.MetadataResponseTopic> sendCreateTopicRequest(Map<String, CreateTopicsRequestData.CreatableTopic> creatableTopics, Option<RequestContext> requestContext) {
        CreateTopicsRequestData.CreatableTopicCollection topicsToCreate = new CreateTopicsRequestData.CreatableTopicCollection(creatableTopics.size());
        topicsToCreate.addAll(CollectionConverters$.MODULE$.IterableHasAsJava(creatableTopics.values()).asJavaCollection());
        CreateTopicsRequest.Builder createTopicsRequest = new CreateTopicsRequest.Builder(new CreateTopicsRequestData().setTimeoutMs(this.config.requestTimeoutMs()).setTopics(topicsToCreate));
        ControllerRequestCompletionHandler requestCompletionHandler = new ControllerRequestCompletionHandler(this, creatableTopics){
            private final /* synthetic */ DefaultAutoTopicCreationManager $outer;
            private final Map creatableTopics$1;

            public void onTimeout() {
                this.$outer.kafka$server$DefaultAutoTopicCreationManager$$clearInflightRequests((Map<String, CreateTopicsRequestData.CreatableTopic>)this.creatableTopics$1);
                this.$outer.debug((Function0<String>)(Function0 & Serializable)() -> "Auto topic creation timed out for " + $this.creatableTopics$1.keys() + ".");
            }

            public void onComplete(ClientResponse response) {
                this.$outer.kafka$server$DefaultAutoTopicCreationManager$$clearInflightRequests((Map<String, CreateTopicsRequestData.CreatableTopic>)this.creatableTopics$1);
                if (response.authenticationException() != null) {
                    this.$outer.warn((Function0<String>)(Function0 & Serializable)() -> "Auto topic creation failed for " + $this.creatableTopics$1.keys() + " with authentication exception");
                    return;
                }
                if (response.versionMismatch() != null) {
                    this.$outer.warn((Function0<String>)(Function0 & Serializable)() -> "Auto topic creation failed for " + $this.creatableTopics$1.keys() + " with invalid version exception");
                    return;
                }
                this.$outer.debug((Function0<String>)(Function0 & Serializable)() -> "Auto topic creation completed for " + $this.creatableTopics$1.keys() + " with response " + response.responseBody() + ".");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.creatableTopics$1 = creatableTopics$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onComplete$1(kafka.server.DefaultAutoTopicCreationManager$$anon$1 ), $anonfun$onComplete$2(kafka.server.DefaultAutoTopicCreationManager$$anon$1 ), $anonfun$onComplete$3(kafka.server.DefaultAutoTopicCreationManager$$anon$1 org.apache.kafka.clients.ClientResponse ), $anonfun$onTimeout$1(kafka.server.DefaultAutoTopicCreationManager$$anon$1 )}, serializedLambda);
            }
        };
        AbstractRequest.Builder request = (AbstractRequest.Builder)requestContext.map((Function1 & Serializable)context -> {
            short s;
            Option option = OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional($this.channelManager.controllerApiVersions()));
            if (None$.MODULE$.equals(option)) {
                s = ApiKeys.CREATE_TOPICS.latestVersion();
            } else if (option instanceof Some) {
                s = ((NodeApiVersions)((Some)option).value()).latestUsableVersion(ApiKeys.CREATE_TOPICS);
            } else {
                throw new MatchError((Object)option);
            }
            short requestVersion = s;
            RequestHeader requestHeader = new RequestHeader(ApiKeys.CREATE_TOPICS, requestVersion, context.clientId(), context.correlationId());
            return ForwardingManager$.MODULE$.buildEnvelopeRequest((RequestContext)context, createTopicsRequest.build(requestVersion).serializeWithHeader(requestHeader));
        }).getOrElse((Function0 & Serializable)() -> createTopicsRequest);
        this.channelManager.sendRequest(request, requestCompletionHandler);
        scala.collection.immutable.Seq creatableTopicResponses = (scala.collection.immutable.Seq)creatableTopics.keySet().toSeq().map((Function1 & Serializable)topic -> new MetadataResponseData.MetadataResponseTopic().setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()).setName(topic).setIsInternal(Topic.isInternal((String)topic)));
        this.info((Function0<String>)(Function0 & Serializable)() -> "Sent auto-creation request for " + creatableTopics.keys() + " to the active controller.");
        return creatableTopicResponses;
    }

    public void kafka$server$DefaultAutoTopicCreationManager$$clearInflightRequests(Map<String, CreateTopicsRequestData.CreatableTopic> creatableTopics) {
        creatableTopics.keySet().foreach((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DefaultAutoTopicCreationManager.$anonfun$clearInflightRequests$1(this, x$1)));
        this.debug((Function0<String>)(Function0 & Serializable)() -> "Cleared inflight topic creation state for " + creatableTopics);
    }

    private CreateTopicsRequestData.CreatableTopic creatableTopic(String topic) {
        switch (topic == null ? 0 : topic.hashCode()) {
            case -970371369: {
                if (!"__consumer_offsets".equals(topic)) break;
                return new CreateTopicsRequestData.CreatableTopic().setName(topic).setNumPartitions(this.config.groupCoordinatorConfig().offsetsTopicPartitions()).setReplicationFactor(this.config.groupCoordinatorConfig().offsetsTopicReplicationFactor()).setConfigs(this.convertToTopicConfigCollections(this.groupCoordinator.groupMetadataTopicConfigs()));
            }
            case -253293552: {
                if (!"__transaction_state".equals(topic)) break;
                TransactionLogConfig transactionLogConfig = new TransactionLogConfig((AbstractConfig)this.config);
                return new CreateTopicsRequestData.CreatableTopic().setName(topic).setNumPartitions(transactionLogConfig.transactionTopicPartitions()).setReplicationFactor(transactionLogConfig.transactionTopicReplicationFactor()).setConfigs(this.convertToTopicConfigCollections(this.txnCoordinator.transactionTopicConfigs()));
            }
            case -81655151: {
                if (!"__share_group_state".equals(topic)) break;
                return new CreateTopicsRequestData.CreatableTopic().setName(topic).setNumPartitions(this.config.shareCoordinatorConfig().shareCoordinatorStateTopicNumPartitions()).setReplicationFactor(this.config.shareCoordinatorConfig().shareCoordinatorStateTopicReplicationFactor()).setConfigs(this.convertToTopicConfigCollections(this.shareCoordinator.shareGroupStateTopicConfigs()));
            }
        }
        return new CreateTopicsRequestData.CreatableTopic().setName(topic).setNumPartitions(Predef$.MODULE$.Integer2int(this.config.numPartitions())).setReplicationFactor((short)this.config.defaultReplicationFactor());
    }

    private CreateTopicsRequestData.CreatableTopicConfigCollection convertToTopicConfigCollections(Properties config) {
        CreateTopicsRequestData.CreatableTopicConfigCollection topicConfigs = new CreateTopicsRequestData.CreatableTopicConfigCollection();
        config.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(x0$1, x1$1) -> topicConfigs.add((ImplicitLinkedHashCollection.Element)new CreateTopicsRequestData.CreatableTopicConfig().setName(x0$1.toString()).setValue(x1$1.toString()))));
        return topicConfigs;
    }

    private boolean isValidTopicName(String topic) {
        try {
            Topic.validate((String)topic);
            return true;
        }
        catch (InvalidTopicException invalidTopicException) {
            return false;
        }
    }

    private Tuple2<Map<String, CreateTopicsRequestData.CreatableTopic>, Seq<MetadataResponseData.MetadataResponseTopic>> filterCreatableTopics(Set<String> topics) {
        scala.collection.mutable.Map creatableTopics = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        Buffer uncreatableTopics = (Buffer)Buffer$.MODULE$.empty();
        topics.foreach((Function1 & Serializable)topic -> {
            Some validationError;
            Object object = !this.isValidTopicName((String)topic) ? new Some((Object)Errors.INVALID_TOPIC_EXCEPTION) : (validationError = !this.inflightTopics().add((String)topic) ? new Some((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION) : None$.MODULE$);
            if (validationError instanceof Some) {
                Errors error = (Errors)validationError.value();
                return uncreatableTopics.$plus$eq((Object)new MetadataResponseData.MetadataResponseTopic().setErrorCode(error.code()).setName(topic).setIsInternal(Topic.isInternal((String)topic)));
            }
            if (None$.MODULE$.equals(validationError)) {
                return creatableTopics.put(topic, (Object)this.creatableTopic((String)topic));
            }
            throw new MatchError((Object)validationError);
        });
        return new Tuple2((Object)creatableTopics, (Object)uncreatableTopics);
    }

    public static final /* synthetic */ boolean $anonfun$createStreamsInternalTopics$1(Tuple2 check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    public static final /* synthetic */ boolean $anonfun$clearInflightRequests$1(DefaultAutoTopicCreationManager $this, Object x$1) {
        return $this.inflightTopics().remove(x$1);
    }

    public DefaultAutoTopicCreationManager(KafkaConfig config, NodeToControllerChannelManager channelManager, GroupCoordinator groupCoordinator, TransactionCoordinator txnCoordinator, ShareCoordinator shareCoordinator) {
        this.config = config;
        this.channelManager = channelManager;
        this.groupCoordinator = groupCoordinator;
        this.txnCoordinator = txnCoordinator;
        this.shareCoordinator = shareCoordinator;
        this.inflightTopics = Collections.newSetFromMap(new ConcurrentHashMap());
    }
}

