/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.std;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.sf.juife.OkCancelDialog;
import net.sf.juife.event.TaskEvent;
import net.sf.juife.event.TaskListener;
import org.jsampler.CC;
import org.jsampler.JSPrefs;
import org.jsampler.OrchestraInstrument;
import org.jsampler.OrchestraModel;
import org.jsampler.task.Global;
import org.jsampler.task.InstrumentsDb;
import org.jsampler.view.std.JSDbInstrumentChooser;
import org.jsampler.view.std.StdI18n;
import org.jsampler.view.std.StdUtils;
import org.linuxsampler.lscp.DbInstrumentInfo;
import org.linuxsampler.lscp.Instrument;
import org.linuxsampler.lscp.Parser;

public class JSInstrumentChooser
extends OkCancelDialog {
    private final JRadioButton rbSelectFromOrchestra = new JRadioButton(StdI18n.i18n.getLabel("JSInstrumentChooser.rbSelectFromOrchestra"));
    private final JRadioButton rbSelectFromDb = new JRadioButton(StdI18n.i18n.getLabel("JSInstrumentChooser.rbSelectFromDb"));
    private final JRadioButton rbSelectFromFile = new JRadioButton(StdI18n.i18n.getLabel("JSInstrumentChooser.rbSelectFromFile"));
    private final JLabel lOrchestra = new JLabel(StdI18n.i18n.getLabel("JSInstrumentChooser.lOrchestra"));
    private final JLabel lInstrument = new JLabel(StdI18n.i18n.getLabel("JSInstrumentChooser.lInstrument"));
    private final JComboBox cbOrchestras = new JComboBox();
    private final JComboBox cbInstruments = new JComboBox();
    private final JComboBox cbDbInstrument = StdUtils.createPathComboBox();
    private final JButton btnBrowseDb;
    private final JLabel lFilename = new JLabel(StdI18n.i18n.getLabel("JSInstrumentChooser.lFilename"));
    private final JLabel lIndex = new JLabel(StdI18n.i18n.getLabel("JSInstrumentChooser.lIndex"));
    private final JComboBox cbFilename = StdUtils.createPathComboBox();
    private final JComboBox cbIndex = StdUtils.createEnhancedComboBox();
    private final JButton btnBrowse;
    private String instrumentFile = null;
    private int instrumentIndex = 0;
    private String engine = null;
    private final EventHandler eventHandler = new EventHandler();

    public JSInstrumentChooser(Frame frame) {
        super(frame, StdI18n.i18n.getLabel("JSInstrumentChooser.title"));
        String string;
        String[] stringArray;
        this.btnOk.setEnabled(false);
        Icon icon = CC.getViewConfig().getInstrumentsDbTreeView().getOpenIcon();
        this.btnBrowseDb = new JButton(icon);
        this.btnBrowse = new JButton(icon);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rbSelectFromOrchestra);
        buttonGroup.add(this.rbSelectFromDb);
        buttonGroup.add(this.rbSelectFromFile);
        this.rbSelectFromOrchestra.addActionListener(this.getHandler());
        this.rbSelectFromDb.addActionListener(this.getHandler());
        this.rbSelectFromFile.addActionListener(this.getHandler());
        this.rbSelectFromOrchestra.doClick(0);
        this.cbOrchestras.addFocusListener(this.getHandler());
        this.cbInstruments.addFocusListener(this.getHandler());
        this.cbDbInstrument.addFocusListener(this.getHandler());
        this.cbDbInstrument.addActionListener(this.getHandler());
        this.cbDbInstrument.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!JSInstrumentChooser.this.rbSelectFromDb.isSelected()) {
                    JSInstrumentChooser.this.rbSelectFromDb.doClick(0);
                }
            }
        });
        String[] stringArray2 = stringArray = this.preferences().getStringListProperty("recentDbInstruments");
        int n = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            String string2 = stringArray2[i];
            this.cbDbInstrument.addItem(string2);
        }
        this.cbDbInstrument.setSelectedItem(null);
        this.cbFilename.addFocusListener(this.getHandler());
        this.cbFilename.addActionListener(this.getHandler());
        for (String object2 : stringArray2 = this.preferences().getStringListProperty("recentInstrumentFiles")) {
            this.cbFilename.addItem(object2);
        }
        this.cbFilename.setSelectedItem(null);
        this.cbFilename.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!JSInstrumentChooser.this.rbSelectFromFile.isSelected()) {
                    JSInstrumentChooser.this.rbSelectFromFile.doClick(0);
                }
                JSInstrumentChooser.this.updateFileInstruments();
            }
        });
        this.cbIndex.addFocusListener(this.getHandler());
        this.cbIndex.addActionListener(this.getHandler());
        this.cbFilename.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!JSInstrumentChooser.this.rbSelectFromFile.isSelected()) {
                    JSInstrumentChooser.this.rbSelectFromFile.doClick(0);
                }
            }
        });
        for (int i = 0; i < 101; ++i) {
            this.cbIndex.addItem(i);
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.rbSelectFromOrchestra.setAlignmentX(0.0f);
        jPanel.add(this.rbSelectFromOrchestra);
        JPanel jPanel2 = this.createOrchestraPane();
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 32, 17, 0));
        jPanel.add(jPanel2);
        this.rbSelectFromDb.setAlignmentX(0.0f);
        jPanel.add(this.rbSelectFromDb);
        JPanel jPanel3 = this.createDbPane();
        jPanel3.setBorder(BorderFactory.createEmptyBorder(0, 32, 17, 0));
        jPanel.add(jPanel3);
        this.rbSelectFromFile.setAlignmentX(0.0f);
        jPanel.add(this.rbSelectFromFile);
        JPanel jPanel4 = this.createFilePane();
        jPanel4.setBorder(BorderFactory.createEmptyBorder(0, 32, 0, 0));
        jPanel.add(jPanel4);
        this.setMainPane(jPanel);
        if (!CC.getSamplerModel().getServerInfo().hasInstrumentsDbSupport()) {
            this.rbSelectFromDb.setEnabled(false);
            this.cbDbInstrument.setEnabled(false);
            this.btnBrowseDb.setEnabled(false);
        } else {
            this.btnBrowseDb.requestFocusInWindow();
        }
        int n2 = this.preferences().getIntProperty("lastUsedOrchestraIndex", 0);
        if (CC.getOrchestras().getOrchestraCount() > n2) {
            this.cbOrchestras.setSelectedIndex(n2);
            n2 = this.preferences().getIntProperty("lastUsedOrchestraInstrumentIndex", 0);
            if (this.cbInstruments.getItemCount() > n2) {
                this.cbInstruments.setSelectedIndex(n2);
            }
        }
        if ("fromOrchestra".equals(string = this.preferences().getStringProperty("lastUsedInstrumentSelectionMethod"))) {
            if (!this.rbSelectFromOrchestra.isSelected()) {
                this.rbSelectFromOrchestra.doClick(0);
            }
            this.cbInstruments.requestFocusInWindow();
        } else if ("fromDb".equals(string)) {
            if (!this.rbSelectFromDb.isSelected()) {
                this.rbSelectFromDb.doClick(0);
            }
        } else if ("fromFile".equals(string)) {
            if (!this.rbSelectFromFile.isSelected()) {
                this.rbSelectFromFile.doClick(0);
            }
            this.btnBrowse.requestFocusInWindow();
        } else if (!this.rbSelectFromOrchestra.isSelected()) {
            this.rbSelectFromOrchestra.doClick(0);
        }
        this.updateState();
        this.setMinimumSize(this.getPreferredSize());
        this.setResizable(true);
    }

    private JPanel createOrchestraPane() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 6, 6);
        gridBagLayout.setConstraints(this.lOrchestra, gridBagConstraints);
        jPanel.add(this.lOrchestra);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        gridBagLayout.setConstraints(this.lInstrument, gridBagConstraints);
        jPanel.add(this.lInstrument);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagLayout.setConstraints(this.cbOrchestras, gridBagConstraints);
        jPanel.add(this.cbOrchestras);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(this.cbInstruments, gridBagConstraints);
        jPanel.add(this.cbInstruments);
        this.cbOrchestras.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JSInstrumentChooser.this.orchestraChanged();
            }
        });
        this.cbInstruments.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JSInstrumentChooser.this.instrumentChanged();
            }
        });
        for (int i = 0; i < CC.getOrchestras().getOrchestraCount(); ++i) {
            this.cbOrchestras.addItem(CC.getOrchestras().getOrchestra(i));
        }
        jPanel.setAlignmentX(0.0f);
        return jPanel;
    }

    protected JSPrefs preferences() {
        return CC.getViewConfig().preferences();
    }

    private void orchestraChanged() {
        String string;
        OrchestraModel orchestraModel = (OrchestraModel)this.cbOrchestras.getSelectedItem();
        String string2 = string = orchestraModel == null ? null : orchestraModel.getDescription();
        if (string != null && string.length() == 0) {
            string = null;
        }
        this.cbOrchestras.setToolTipText(string);
        this.cbInstruments.removeAllItems();
        if (orchestraModel == null || orchestraModel.getInstrumentCount() == 0) {
            this.cbInstruments.setEnabled(false);
            return;
        }
        this.cbInstruments.setEnabled(true);
        for (int i = 0; i < orchestraModel.getInstrumentCount(); ++i) {
            this.cbInstruments.addItem(orchestraModel.getInstrument(i));
        }
    }

    private void instrumentChanged() {
        String string;
        OrchestraInstrument orchestraInstrument = (OrchestraInstrument)this.cbInstruments.getSelectedItem();
        String string2 = string = orchestraInstrument == null ? null : orchestraInstrument.getDescription();
        if (string != null && string.length() == 0) {
            string = null;
        }
        this.cbInstruments.setToolTipText(string);
        this.btnOk.setEnabled(orchestraInstrument != null);
    }

    private JPanel createDbPane() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(this.cbDbInstrument);
        jPanel.add(Box.createRigidArea(new Dimension(6, 0)));
        this.btnBrowseDb.setMargin(new Insets(0, 0, 0, 0));
        jPanel.add(this.btnBrowseDb);
        this.cbDbInstrument.setPreferredSize(new Dimension(200, this.cbDbInstrument.getPreferredSize().height));
        this.btnBrowseDb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JSInstrumentChooser.this.onBrowseDb();
            }
        });
        jPanel.setAlignmentX(0.0f);
        return jPanel;
    }

    private JPanel createFilePane() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagLayout.setConstraints(this.lFilename, gridBagConstraints);
        jPanel.add(this.lFilename);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.lIndex, gridBagConstraints);
        jPanel.add(this.lIndex);
        this.btnBrowse.setMargin(new Insets(0, 0, 0, 0));
        this.btnBrowse.setToolTipText(StdI18n.i18n.getLabel("JSInstrumentChooser.btnBrowse"));
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.btnBrowse, gridBagConstraints);
        jPanel.add(this.btnBrowse);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.cbFilename, gridBagConstraints);
        jPanel.add(this.cbFilename);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.cbIndex, gridBagConstraints);
        jPanel.add(this.cbIndex);
        this.cbFilename.setPreferredSize(new Dimension(200, this.cbFilename.getPreferredSize().height));
        this.btnBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JSInstrumentChooser.this.onBrowse();
            }
        });
        jPanel.setAlignmentX(0.0f);
        return jPanel;
    }

    protected JSDbInstrumentChooser createDbInstrumentChooser(Dialog dialog) {
        return new JSDbInstrumentChooser(dialog);
    }

    @Override
    protected void onOk() {
        if (!this.btnOk.isEnabled()) {
            return;
        }
        String string = "lastUsedInstrumentSelectionMethod";
        if (this.rbSelectFromOrchestra.isSelected()) {
            OrchestraInstrument orchestraInstrument = (OrchestraInstrument)this.cbInstruments.getSelectedItem();
            this.instrumentFile = orchestraInstrument.getFilePath();
            this.instrumentIndex = orchestraInstrument.getInstrumentIndex();
            this.engine = orchestraInstrument.getEngine();
            this.setVisible(false);
            int n = this.cbOrchestras.getSelectedIndex();
            if (n >= 0) {
                this.preferences().setIntProperty("lastUsedOrchestraIndex", n);
            }
            if ((n = this.cbInstruments.getSelectedIndex()) >= 0) {
                this.preferences().setIntProperty("lastUsedOrchestraInstrumentIndex", n);
            }
            this.preferences().setStringProperty(string, "fromOrchestra");
            return;
        }
        if (this.rbSelectFromFile.isSelected()) {
            this.instrumentFile = this.cbFilename.getSelectedItem().toString();
            this.instrumentIndex = this.cbIndex.getSelectedIndex();
            StdUtils.updateRecentElements("recentInstrumentFiles", this.instrumentFile);
            this.preferences().setStringProperty(string, "fromFile");
            this.setVisible(false);
            return;
        }
        if (!this.rbSelectFromDb.isSelected()) {
            return;
        }
        this.preferences().setStringProperty(string, "fromDb");
        String string2 = this.cbDbInstrument.getSelectedItem().toString();
        this.preferences().setStringProperty("lastUsedDbInstrument", string2);
        final InstrumentsDb.GetInstrument getInstrument = new InstrumentsDb.GetInstrument(string2);
        StdUtils.updateRecentElements("recentDbInstruments", string2);
        getInstrument.addTaskListener(new TaskListener(){

            @Override
            public void taskPerformed(TaskEvent taskEvent) {
                JSInstrumentChooser.this.updateState();
                if (getInstrument.doneWithErrors()) {
                    return;
                }
                JSInstrumentChooser.this.instrumentFile = ((DbInstrumentInfo)getInstrument.getResult()).getFilePath();
                JSInstrumentChooser.this.instrumentIndex = ((DbInstrumentInfo)getInstrument.getResult()).getInstrumentIndex();
                JSInstrumentChooser.this.engine = ((DbInstrumentInfo)getInstrument.getResult()).getFormatFamily();
                JSInstrumentChooser.this.setVisible(false);
            }
        });
        this.btnOk.setEnabled(false);
        CC.getTaskQueue().add(getInstrument);
    }

    @Override
    protected void onCancel() {
        this.setVisible(false);
    }

    private void onBrowse() {
        File file;
        if (!this.rbSelectFromFile.isSelected()) {
            this.rbSelectFromFile.doClick(0);
        }
        if ((file = StdUtils.showOpenInstrumentFileChooser(this)) == null) {
            return;
        }
        String string = file.getAbsolutePath();
        if (File.separatorChar == '\\') {
            string = string.replace('\\', '/');
        }
        this.cbFilename.setSelectedItem(Parser.toEscapedString(string));
        this.btnOk.requestFocusInWindow();
    }

    private void onBrowseDb() {
        if (!this.rbSelectFromDb.isSelected()) {
            this.rbSelectFromDb.doClick(0);
        }
        JSDbInstrumentChooser jSDbInstrumentChooser = this.createDbInstrumentChooser(this);
        Object object = this.cbDbInstrument.getSelectedItem();
        if (object != null && object.toString().length() > 0) {
            jSDbInstrumentChooser.setSelectedInstrument(object.toString());
        } else {
            String string = this.preferences().getStringProperty("lastUsedDbInstrument", "");
            if (string.length() > 0) {
                jSDbInstrumentChooser.setSelectedInstrument(string);
            } else {
                jSDbInstrumentChooser.setSelectedDirectory("/");
            }
        }
        jSDbInstrumentChooser.setVisible(true);
        if (jSDbInstrumentChooser.isCancelled()) {
            return;
        }
        this.cbDbInstrument.setSelectedItem(jSDbInstrumentChooser.getSelectedInstrument());
        this.cbDbInstrument.requestFocus();
    }

    public String getInstrumentFile() {
        return this.instrumentFile;
    }

    public int getInstrumentIndex() {
        return this.instrumentIndex;
    }

    public String getEngine() {
        return this.engine;
    }

    private void updateState() {
        boolean bl = false;
        if (this.rbSelectFromOrchestra.isSelected()) {
            bl = this.cbInstruments.getSelectedItem() != null;
        } else if (this.rbSelectFromDb.isSelected()) {
            Object object = this.cbDbInstrument.getSelectedItem();
            bl = object != null && object.toString().length() > 0;
        } else if (this.rbSelectFromFile.isSelected()) {
            Object object = this.cbFilename.getSelectedItem();
            bl = object == null ? false : object.toString().length() > 0;
            object = this.cbIndex.getSelectedItem();
            if (object == null || object.toString().length() == 0) {
                bl = false;
            }
        }
        this.btnOk.setEnabled(bl);
    }

    private void updateFileInstruments() {
        Object object = this.cbFilename.getSelectedItem();
        if (object == null) {
            return;
        }
        String string = object.toString();
        final Global.GetFileInstruments getFileInstruments = new Global.GetFileInstruments(string);
        getFileInstruments.addTaskListener(new TaskListener(){

            @Override
            public void taskPerformed(TaskEvent taskEvent) {
                Instrument[] instrumentArray = (Instrument[])getFileInstruments.getResult();
                if (instrumentArray == null) {
                    JSInstrumentChooser.this.cbIndex.removeAllItems();
                    for (int i = 0; i < 101; ++i) {
                        JSInstrumentChooser.this.cbIndex.addItem(i);
                    }
                    return;
                }
                JSInstrumentChooser.this.cbIndex.removeAllItems();
                for (int i = 0; i < instrumentArray.length; ++i) {
                    JSInstrumentChooser.this.cbIndex.addItem(i + " - " + instrumentArray[i].getName());
                }
            }
        });
        CC.getTaskQueue().add(getFileInstruments);
    }

    private EventHandler getHandler() {
        return this.eventHandler;
    }

    private class EventHandler
    extends FocusAdapter
    implements ActionListener,
    DocumentListener {
        private EventHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JSInstrumentChooser.this.updateState();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            JSInstrumentChooser.this.updateState();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            JSInstrumentChooser.this.updateState();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            JSInstrumentChooser.this.updateState();
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            Object object = focusEvent.getSource();
            if (object == JSInstrumentChooser.this.cbInstruments || object == JSInstrumentChooser.this.cbOrchestras) {
                if (!JSInstrumentChooser.this.rbSelectFromOrchestra.isSelected()) {
                    JSInstrumentChooser.this.rbSelectFromOrchestra.doClick(0);
                }
            } else if (object == JSInstrumentChooser.this.cbDbInstrument) {
                if (!JSInstrumentChooser.this.rbSelectFromDb.isSelected()) {
                    JSInstrumentChooser.this.rbSelectFromDb.doClick(0);
                }
            } else if (!(object != JSInstrumentChooser.this.cbFilename && object != JSInstrumentChooser.this.cbIndex || JSInstrumentChooser.this.rbSelectFromFile.isSelected())) {
                JSInstrumentChooser.this.rbSelectFromFile.doClick(0);
            }
        }
    }
}

