/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.std;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.sf.juife.OkCancelDialog;
import org.jsampler.CC;
import org.jsampler.DefaultOrchestraModel;
import org.jsampler.OrchestraModel;
import org.jsampler.view.std.StdI18n;

public class JSAddOrEditOrchestraDlg
extends OkCancelDialog {
    private final JLabel lName = new JLabel(StdI18n.i18n.getLabel("JSAddOrEditOrchestraDlg.lName"));
    private final JLabel lDesc = new JLabel(StdI18n.i18n.getLabel("JSAddOrEditOrchestraDlg.lDesc"));
    private final JTextField tfName = new JTextField();
    private final JTextField tfDesc = new JTextField();
    private OrchestraModel orchestraModel;
    private final Handler eventHandler = new Handler();

    public JSAddOrEditOrchestraDlg() {
        this(new DefaultOrchestraModel());
    }

    public JSAddOrEditOrchestraDlg(OrchestraModel orchestraModel) {
        super((Frame)CC.getMainFrame(), StdI18n.i18n.getLabel("JSAddOrEditOrchestraDlg.title"));
        this.orchestraModel = orchestraModel;
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagLayout.setConstraints(this.lName, gridBagConstraints);
        jPanel.add(this.lName);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.lDesc, gridBagConstraints);
        jPanel.add(this.lDesc);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.tfName, gridBagConstraints);
        jPanel.add(this.tfName);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.tfDesc, gridBagConstraints);
        jPanel.add(this.tfDesc);
        this.setMainPane(jPanel);
        int n = this.getPreferredSize().width;
        Dimension dimension = new Dimension(n > 400 ? n : 400, this.getPreferredSize().height);
        this.setPreferredSize(dimension);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
        this.btnOk.setEnabled(false);
        this.tfName.getDocument().addDocumentListener(this.getHandler());
        this.updateInfo();
        this.updateState();
    }

    private void updateInfo() {
        this.tfName.setText(this.getOrchestra().getName());
        this.tfDesc.setText(this.getOrchestra().getDescription());
    }

    private void updateState() {
        boolean bl = true;
        if (this.tfName.getText().length() == 0) {
            bl = false;
        }
        this.btnOk.setEnabled(bl);
    }

    @Override
    protected void onOk() {
        if (!this.btnOk.isEnabled()) {
            return;
        }
        this.orchestraModel.setName(this.tfName.getText());
        this.orchestraModel.setDescription(this.tfDesc.getText());
        this.setVisible(false);
        this.setCancelled(false);
    }

    @Override
    protected void onCancel() {
        this.setVisible(false);
    }

    public OrchestraModel getOrchestra() {
        return this.orchestraModel;
    }

    private Handler getHandler() {
        return this.eventHandler;
    }

    private class Handler
    implements DocumentListener {
        private Handler() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            JSAddOrEditOrchestraDlg.this.updateState();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            JSAddOrEditOrchestraDlg.this.updateState();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            JSAddOrEditOrchestraDlg.this.updateState();
        }
    }
}

