/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization.layout;

import java.io.File;
import org.gradle.api.internal.GradleInternal;
import org.gradle.cache.scopes.BuildScopedCacheBuilderFactory;
import org.gradle.initialization.layout.BuildLayout;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value={Scope.Build.class})
public class ResolvedBuildLayout {
    private final GradleInternal gradle;
    private final BuildLayout buildLayout;
    private final BuildScopedCacheBuilderFactory cacheBuilderFactory;

    public ResolvedBuildLayout(GradleInternal gradle, BuildLayout buildLayout, BuildScopedCacheBuilderFactory cacheBuilderFactory) {
        this.gradle = gradle;
        this.buildLayout = buildLayout;
        this.cacheBuilderFactory = cacheBuilderFactory;
    }

    public File getCurrentDirectory() {
        return this.gradle.getStartParameter().getCurrentDir();
    }

    public File getGlobalScopeCacheDirectory() {
        return this.gradle.getGradleUserHomeDir();
    }

    public File getBuildScopeCacheDirectory() {
        return this.cacheBuilderFactory.getRootDir();
    }

    public boolean isBuildDefinitionMissing() {
        boolean isNoBuildDefinitionFound = this.buildLayout.isBuildDefinitionMissing();
        boolean isCurrentDirNotPartOfContainingBuild = this.gradle.getSettings().getSettingsScript().getResource().getLocation().getFile() == null;
        return isNoBuildDefinitionFound || isCurrentDirNotPartOfContainingBuild;
    }
}

