/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ext4;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.ext4.Ext4XattrEntry;
import ghidra.file.formats.ext4.Ext4Xattributes;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class Ext4Inode
implements StructConverter {
    private static final int INODE_BASE_SIZE = 128;
    private static final int MINIMAL_SIZEOF_INODE = 160;
    private short i_mode;
    private short i_uid;
    private int i_size_lo;
    private int i_atime;
    private int i_ctime;
    private int i_mtime;
    private int i_dtime;
    private short i_gid;
    private short i_links_count;
    private int i_blocks_lo;
    private int i_flags;
    private int i_osd1;
    private byte[] i_block;
    private int i_generation;
    private int i_file_acl_lo;
    private int i_size_high;
    private int i_obso_faddr;
    private byte[] i_osd2;
    private short i_extra_isize;
    private short i_checksum_hi;
    private int i_ctime_extra;
    private int i_mtime_extra;
    private int i_atime_extra;
    private int i_crtime;
    private int i_crtime_extra;
    private int i_version_hi;
    private int i_projid;
    private Ext4Xattributes xAttributes;

    public Ext4Inode(BinaryReader reader) throws IOException {
        this(reader, 160);
    }

    public Ext4Inode(BinaryReader reader, int inodeSize) throws IOException {
        if (inodeSize < 128) {
            throw new IOException("Bad inodeSize: " + inodeSize);
        }
        long inodeStart = reader.getPointerIndex();
        this.i_mode = reader.readNextShort();
        this.i_uid = reader.readNextShort();
        this.i_size_lo = reader.readNextInt();
        this.i_atime = reader.readNextInt();
        this.i_ctime = reader.readNextInt();
        this.i_mtime = reader.readNextInt();
        this.i_dtime = reader.readNextInt();
        this.i_gid = reader.readNextShort();
        this.i_links_count = reader.readNextShort();
        this.i_blocks_lo = reader.readNextInt();
        this.i_flags = reader.readNextInt();
        this.i_osd1 = reader.readNextInt();
        this.i_block = reader.readNextByteArray(60);
        this.i_generation = reader.readNextInt();
        this.i_file_acl_lo = reader.readNextInt();
        this.i_size_high = reader.readNextInt();
        this.i_obso_faddr = reader.readNextInt();
        this.i_osd2 = reader.readNextByteArray(12);
        if (inodeSize > 128) {
            this.i_extra_isize = reader.readNextShort();
            this.i_checksum_hi = reader.readNextShort();
            this.i_ctime_extra = reader.readNextInt();
            this.i_mtime_extra = reader.readNextInt();
            this.i_atime_extra = reader.readNextInt();
            this.i_crtime = reader.readNextInt();
            this.i_crtime_extra = reader.readNextInt();
            this.i_version_hi = reader.readNextInt();
            this.i_projid = reader.readNextInt();
            reader.setPointerIndex(inodeStart + 128L + (long)this.i_extra_isize);
            this.xAttributes = Ext4Xattributes.readInodeXAttributes(reader, inodeStart + (long)inodeSize);
        }
    }

    public short getI_mode() {
        return this.i_mode;
    }

    public short getI_uid() {
        return this.i_uid;
    }

    public int getI_size_lo() {
        return this.i_size_lo;
    }

    public int getI_atime() {
        return this.i_atime;
    }

    public int getI_ctime() {
        return this.i_ctime;
    }

    public int getI_mtime() {
        return this.i_mtime;
    }

    public int getI_dtime() {
        return this.i_dtime;
    }

    public short getI_gid() {
        return this.i_gid;
    }

    public short getI_links_count() {
        return this.i_links_count;
    }

    public int getI_blocks_lo() {
        return this.i_blocks_lo;
    }

    public int getI_flags() {
        return this.i_flags;
    }

    public int getI_osd1() {
        return this.i_osd1;
    }

    public byte[] getI_block() {
        return this.i_block;
    }

    public int getI_generation() {
        return this.i_generation;
    }

    public int getI_file_acl_lo() {
        return this.i_file_acl_lo;
    }

    public int getI_size_high() {
        return this.i_size_high;
    }

    public int getI_obso_faddr() {
        return this.i_obso_faddr;
    }

    public byte[] getI_osd2() {
        return this.i_osd2;
    }

    public short getI_extra_isize() {
        return this.i_extra_isize;
    }

    public short getI_checksum_hi() {
        return this.i_checksum_hi;
    }

    public int getI_ctime_extra() {
        return this.i_ctime_extra;
    }

    public int getI_mtime_extra() {
        return this.i_mtime_extra;
    }

    public int getI_atime_extra() {
        return this.i_atime_extra;
    }

    public int getI_crtime() {
        return this.i_crtime;
    }

    public int getI_crtime_extra() {
        return this.i_crtime_extra;
    }

    public int getI_version_hi() {
        return this.i_version_hi;
    }

    public int getI_projid() {
        return this.i_projid;
    }

    public long getSize() {
        return Integer.toUnsignedLong(this.i_size_high) << 32 | Integer.toUnsignedLong(this.i_size_lo);
    }

    public boolean isUnused() {
        return this.i_links_count == 0;
    }

    public boolean isSymLink() {
        return (this.i_mode & 0xF000) == 40960;
    }

    public boolean isFile() {
        return (this.i_mode & 0xF000) == 32768;
    }

    public boolean isDir() {
        return (this.i_mode & 0xF000) == 16384;
    }

    public int getFileType() {
        return this.i_mode & 0xF000;
    }

    public boolean isFlagExtents() {
        return (this.i_flags & 0x80000) != 0;
    }

    public boolean isFlagInlineData() {
        return (this.i_flags & 0x10000000) != 0;
    }

    public byte[] getInlineDataValue() throws IOException {
        int bytesRemaining = (int)this.getSize();
        byte[] result = new byte[bytesRemaining];
        byte[] eaSystemData = this.getEAValue("system.data");
        if (eaSystemData == null) {
            eaSystemData = new byte[]{};
        }
        int bytesCopied = 0;
        int copyLen = Math.min(bytesRemaining, this.i_block.length);
        System.arraycopy(this.i_block, 0, result, 0, copyLen);
        bytesCopied += copyLen;
        if ((bytesRemaining -= copyLen) > 0) {
            copyLen = Math.min(bytesRemaining, eaSystemData.length);
            System.arraycopy(eaSystemData, 0, result, bytesCopied, copyLen);
            bytesCopied += copyLen;
            bytesRemaining -= copyLen;
        }
        if (bytesRemaining != 0) {
            throw new IOException("Unable to read inline data");
        }
        return result;
    }

    byte[] getEAValue(String name) {
        Ext4XattrEntry attr = this.xAttributes != null ? this.xAttributes.getAttribute(name) : null;
        return attr != null ? attr.getValue() : null;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType("ext4_inode", 0);
        structure.add(WORD, "i_mode", null);
        structure.add(WORD, "i_uid", null);
        structure.add(DWORD, "i_size_lo", null);
        structure.add(DWORD, "i_atime", null);
        structure.add(DWORD, "i_ctime", null);
        structure.add(DWORD, "i_mtime", null);
        structure.add(DWORD, "i_dtime", null);
        structure.add(WORD, "i_gid", null);
        structure.add(WORD, "i_links_count", null);
        structure.add(DWORD, "i_blocks_lo", null);
        structure.add(DWORD, "i_flags", null);
        structure.add(DWORD, "i_osd1", null);
        structure.add((DataType)new ArrayDataType(BYTE, 60, BYTE.getLength()), "i_block", null);
        structure.add(DWORD, "i_generation", null);
        structure.add(DWORD, "i_file_acl_lo", null);
        structure.add(DWORD, "i_size_high", null);
        structure.add(DWORD, "i_obso_faddr", null);
        structure.add((DataType)new ArrayDataType(BYTE, 12, BYTE.getLength()), "i_osd2", null);
        structure.add(WORD, "i_extra_isize", null);
        structure.add(WORD, "i_checksum_hi", null);
        structure.add(DWORD, "i_ctime_extra", null);
        structure.add(DWORD, "i_mtime_extra", null);
        structure.add(DWORD, "i_atime_extra", null);
        structure.add(DWORD, "i_crtime", null);
        structure.add(DWORD, "i_crtime_extra", null);
        structure.add(DWORD, "i_version_hi", null);
        structure.add(DWORD, "i_projid", null);
        return structure;
    }
}

