/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.format;

import ghidra.app.plugin.core.format.ByteBlock;
import ghidra.app.plugin.core.format.ByteBlockAccessException;
import ghidra.app.plugin.core.format.UniversalDataFormatModel;
import ghidra.util.HelpLocation;
import java.math.BigInteger;

public class OctalFormatModel
implements UniversalDataFormatModel {
    private int symbolSize = 3;
    private static final String GOOD_CHARS = "01234567";

    @Override
    public String getName() {
        return "Octal";
    }

    @Override
    public int getUnitByteSize() {
        return 1;
    }

    @Override
    public int getByteOffset(ByteBlock block, int position) {
        return 0;
    }

    @Override
    public int getColumnPosition(ByteBlock block, int byteOffset) {
        return 0;
    }

    @Override
    public int getDataUnitSymbolSize() {
        return this.symbolSize;
    }

    @Override
    public String getDataRepresentation(ByteBlock block, BigInteger index) throws ByteBlockAccessException {
        int b;
        int i = b = block.getByte(index);
        String str = Integer.toOctalString(i &= 0xFF);
        if (str.length() > this.symbolSize) {
            str = str.substring(str.length() - this.symbolSize);
        }
        return this.pad(str);
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    @Override
    public boolean replaceValue(ByteBlock block, BigInteger index, int charPosition, char c) throws ByteBlockAccessException {
        if (charPosition < 0 || charPosition > 2) {
            return false;
        }
        if (GOOD_CHARS.indexOf(c) == -1) {
            return false;
        }
        if (charPosition == 0 && GOOD_CHARS.indexOf(c) > 3) {
            return false;
        }
        byte b = block.getByte(index);
        char[] charArray = new char[]{c};
        byte cb = Byte.parseByte(new String(charArray), 8);
        if (charPosition == 0) {
            b = (byte)(b & 0x3F);
            cb = (byte)(cb << 6);
            b = (byte)(b + cb);
        } else if (charPosition == 1) {
            b = (byte)(b & 0xC7);
            cb = (byte)(cb << 3);
            b = (byte)(b + cb);
        } else {
            b = (byte)(b & 0xF8);
            b = (byte)(b + cb);
        }
        block.setByte(index, b);
        return true;
    }

    @Override
    public int getGroupSize() {
        return 1;
    }

    @Override
    public void setGroupSize(int groupSize) {
        throw new UnsupportedOperationException("groups are not supported");
    }

    @Override
    public int getUnitDelimiterSize() {
        return 1;
    }

    @Override
    public boolean validateBytesPerLine(int bytesPerLine) {
        return true;
    }

    private String pad(String value) {
        StringBuffer sb = new StringBuffer();
        int len = this.symbolSize - value.length();
        for (int i = 0; i < len; ++i) {
            sb.append("0");
        }
        sb.append(value);
        return sb.toString();
    }

    @Override
    public HelpLocation getHelpLocation() {
        return new HelpLocation("ByteViewerPlugin", "Octal");
    }

    @Override
    public void dispose() {
    }
}

