/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.wizard.project;

import docking.wizard.WizardModel;
import docking.wizard.WizardStep;
import generic.theme.GIcon;
import ghidra.framework.client.NotConnectedException;
import ghidra.framework.client.RepositoryAdapter;
import ghidra.framework.client.RepositoryServerAdapter;
import ghidra.framework.main.wizard.project.ProjectAccessStep;
import ghidra.framework.main.wizard.project.ProjectTypeStep;
import ghidra.framework.main.wizard.project.ProjectWizardData;
import ghidra.framework.main.wizard.project.RepositoryStep;
import ghidra.framework.main.wizard.project.SelectProjectStep;
import ghidra.framework.main.wizard.project.ServerStep;
import ghidra.framework.model.ProjectLocator;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.UserAccessException;
import java.awt.Dimension;
import java.io.IOException;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.border.Border;

public class ProjectWizardModel
extends WizardModel<ProjectWizardData> {
    private static final Icon NEW_PROJECT_ICON = new GIcon("icon.menu.file.new.project");
    public static final Border STANDARD_BORDER = BorderFactory.createEmptyBorder(60, 50, 0, 50);
    private PluginTool tool;

    public ProjectWizardModel(PluginTool tool) {
        super("New Project", (Object)new ProjectWizardData(), NEW_PROJECT_ICON);
        this.tool = tool;
    }

    protected void addWizardSteps(List<WizardStep<ProjectWizardData>> steps) {
        steps.add(new ProjectTypeStep(this));
        steps.add(new ServerStep(this, this.tool.getProjectManager()));
        steps.add(new RepositoryStep(this));
        steps.add(new ProjectAccessStep(this, this.tool));
        steps.add(new SelectProjectStep(this));
    }

    public Dimension getPreferredSize() {
        return new Dimension(500, 300);
    }

    protected boolean doFinish() {
        if (((ProjectWizardData)this.data).isSharedProject()) {
            RepositoryAdapter repository = this.getOrCreateRepository();
            if (repository == null) {
                return false;
            }
            try {
                repository.connect();
            }
            catch (IOException e) {
                this.setStatusMessage("Can't connect to repository: " + ((ProjectWizardData)this.data).getRepositoryName());
                return false;
            }
            ((ProjectWizardData)this.data).setRepository(repository);
        }
        return true;
    }

    public void cancel() {
        RepositoryAdapter repository = ((ProjectWizardData)this.data).getRepository();
        if (repository != null) {
            repository.disconnect();
            ((ProjectWizardData)this.data).setRepository(null);
        }
        ((ProjectWizardData)this.data).setServer(null);
        ((ProjectWizardData)this.data).setProjectLocator(null);
    }

    private RepositoryAdapter getOrCreateRepository() {
        String repositoryName = ((ProjectWizardData)this.data).getRepositoryName();
        RepositoryServerAdapter server = ((ProjectWizardData)this.data).getServer();
        if (!((ProjectWizardData)this.data).isNewRepository()) {
            RepositoryAdapter repository = server.getRepository(repositoryName);
            if (repository == null) {
                this.setStatusMessage("Can't open repository: " + repositoryName);
            }
            return repository;
        }
        try {
            RepositoryAdapter repository = server.createRepository(repositoryName);
            repository.setUserList(((ProjectWizardData)this.data).getProjectUsers(), ((ProjectWizardData)this.data).allowAnonymousAccess());
            return repository;
        }
        catch (DuplicateNameException e) {
            this.setStatusMessage("Repository " + repositoryName + " exists");
        }
        catch (UserAccessException exc) {
            this.setStatusMessage("Could not update the user list: " + exc.getMessage());
        }
        catch (NotConnectedException e) {
            Object statusMessage = e.getMessage();
            if (statusMessage == null) {
                String serverName = ((ProjectWizardData)this.data).getServerInfo().getServerName();
                statusMessage = "Not connected to server " + serverName;
            }
            this.setStatusMessage((String)statusMessage);
        }
        catch (IOException e) {
            this.setStatusMessage("Error occurred while updating the user list: " + e.getMessage());
        }
        return null;
    }

    public ProjectLocator getProjectLocator() {
        return ((ProjectWizardData)this.data).getProjectLocator();
    }

    public RepositoryAdapter getRepository() {
        return ((ProjectWizardData)this.data).getRepository();
    }
}

