/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.util.synthetics;

import java.util.function.Function;
import java.util.function.Supplier;
import org.jgrapht.Graph;
import org.jungrapht.visualization.layout.util.synthetics.SE;
import org.jungrapht.visualization.layout.util.synthetics.SV;
import org.jungrapht.visualization.layout.util.synthetics.SingletonTransformer;
import org.jungrapht.visualization.layout.util.synthetics.TransformingGraphView;

public class SVTransformedGraphSupplier<V, E>
implements Supplier<Graph<SV<V>, SE<E>>> {
    protected Graph<V, E> graph;
    protected SingletonTransformer<V, SV<V>> vertexTransformer;

    public SVTransformedGraphSupplier(Graph<V, E> graph) {
        this.graph = graph;
    }

    public SingletonTransformer<V, SV<V>> getVertexTransformer() {
        return this.vertexTransformer;
    }

    @Override
    public Graph<SV<V>, SE<E>> get() {
        Function<Object, SV> vertexTransformFunction = SV::of;
        this.vertexTransformer = new SingletonTransformer<Object, SV>(vertexTransformFunction);
        Function<Object, SE> edgeTransformFunction = e -> SE.of(e);
        SingletonTransformer<Object, SE> edgeTransformer = new SingletonTransformer<Object, SE>(edgeTransformFunction);
        Object builder = ((TransformingGraphView.Builder)TransformingGraphView.builder(this.graph).vertexTransformFunction(this.vertexTransformer)).edgeTransformFunction(edgeTransformer);
        Object graphView = ((TransformingGraphView.Builder)builder).build();
        return ((TransformingGraphView)graphView).build();
    }
}

