/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.tracermi;

import ghidra.app.plugin.core.debug.service.tracermi.OpenTrace;
import ghidra.app.plugin.core.debug.service.tracermi.ValueDecoder;
import ghidra.debug.api.tracermi.RemoteAsyncResult;
import ghidra.util.Swing;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class DefaultRemoteAsyncResult
extends CompletableFuture<Object>
implements RemoteAsyncResult {
    final ValueDecoder decoder;

    public DefaultRemoteAsyncResult() {
        this.decoder = ValueDecoder.DEFAULT;
    }

    public DefaultRemoteAsyncResult(OpenTrace open) {
        this.decoder = open;
    }

    @Override
    public Object get() throws InterruptedException, ExecutionException {
        if (Swing.isSwingThread()) {
            throw new AssertionError((Object)"Refusing indefinite wait on Swing thread");
        }
        return super.get();
    }

    @Override
    public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (Swing.isSwingThread() && unit.toSeconds(timeout) > 1L) {
            throw new AssertionError((Object)"Refusing a timeout > 1 second on Swing thread");
        }
        return super.get(timeout, unit);
    }
}

