/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.format.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.widgets.OptionDialog;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.app.util.viewer.format.FieldHeader;
import ghidra.app.util.viewer.format.FieldHeaderLocation;
import ghidra.util.HelpLocation;
import java.awt.Component;

public class RemoveAllFieldsAction
extends DockingAction {
    private FieldHeader panel;

    public RemoveAllFieldsAction(String owner, FieldHeader panel) {
        super("Remove All Fields", owner, false);
        this.panel = panel;
        this.setPopupMenuData(new MenuData(new String[]{"Remove All Fields"}, "field"));
        this.setEnabled(true);
        this.setHelpLocation(new HelpLocation("CodeBrowserPlugin", "Remove Field"));
    }

    public boolean isEnabledForContext(ActionContext context) {
        return context.getContextObject() instanceof FieldHeaderLocation;
    }

    public void actionPerformed(ActionContext context) {
        int userChoice = OptionDialog.showOptionDialog((Component)this.panel, (String)"Remove All Fields?", (String)"There is no undo for this action.\nAre you sure you want to remove all fields?", (String)"Continue", (int)2);
        if (userChoice == 0) {
            return;
        }
        this.panel.setTabLock(true);
        FieldHeaderLocation loc = (FieldHeaderLocation)context.getContextObject();
        FieldFormatModel modelAtLocation = loc.getModel();
        modelAtLocation.removeAllFactories();
    }
}

