/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.support.FieldHighlightFactory;
import docking.widgets.fieldpanel.support.Highlight;
import ghidra.app.util.ListingHighlightProvider;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.util.Msg;
import utilities.util.reflection.ReflectionUtilities;

public class ListingFieldHighlightFactoryAdapter
implements FieldHighlightFactory {
    private ListingHighlightProvider provider;
    private ListingField listingField;

    public ListingFieldHighlightFactoryAdapter(ListingHighlightProvider provider) {
        this.provider = provider;
    }

    void setListingField(ListingField listingField) {
        this.listingField = listingField;
    }

    public Highlight[] createHighlights(Field field, String text, int cursorTextOffset) {
        if (this.listingField == null) {
            Msg.error((Object)this, (Object)"Listing highlight factory not correctly setup; ListingField must be set", (Throwable)ReflectionUtilities.createJavaFilteredThrowable());
            return NO_HIGHLIGHTS;
        }
        return this.provider.createHighlights(text, this.listingField, cursorTextOffset);
    }
}

