/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfSectionHeader;
import ghidra.app.util.bin.format.elf.ElfStringTable;
import ghidra.app.util.bin.format.elf.ElfSymbolTable;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;

public class ElfSymbol {
    public static final String FORMATTED_NO_NAME = "<no name>";
    public static final byte STB_LOCAL = 0;
    public static final byte STB_GLOBAL = 1;
    public static final byte STB_WEAK = 2;
    public static final byte STB_GNU_UNIQUE = 10;
    public static final byte STT_NOTYPE = 0;
    public static final byte STT_OBJECT = 1;
    public static final byte STT_FUNC = 2;
    public static final byte STT_SECTION = 3;
    public static final byte STT_FILE = 4;
    public static final byte STT_COMMON = 5;
    public static final byte STT_TLS = 6;
    public static final byte STT_RELC = 8;
    public static final byte STT_SRELC = 9;
    public static final byte STV_DEFAULT = 0;
    public static final byte STV_INTERNAL = 1;
    public static final byte STV_HIDDEN = 2;
    public static final byte STV_PROTECTED = 3;
    private ElfSymbolTable symbolTable;
    private final int symbolTableIndex;
    private final int st_name;
    private final long st_value;
    private final long st_size;
    private final byte st_info;
    private final byte st_other;
    private final short st_shndx;
    private String nameAsString;

    public ElfSymbol() {
        this.symbolTableIndex = 0;
        this.st_name = 0;
        this.st_value = 0L;
        this.st_size = 0L;
        this.st_info = 0;
        this.st_other = 0;
        this.st_shndx = 0;
        this.nameAsString = "";
    }

    public ElfSymbol(BinaryReader reader, int symbolIndex, ElfSymbolTable symbolTable, ElfHeader header) throws IOException {
        this.symbolTable = symbolTable;
        this.symbolTableIndex = symbolIndex;
        if (header.is32Bit()) {
            this.st_name = reader.readNextInt();
            this.st_value = reader.readNextUnsignedInt();
            this.st_size = reader.readNextUnsignedInt();
            this.st_info = reader.readNextByte();
            this.st_other = reader.readNextByte();
            this.st_shndx = reader.readNextShort();
        } else {
            this.st_name = reader.readNextInt();
            this.st_info = reader.readNextByte();
            this.st_other = reader.readNextByte();
            this.st_shndx = reader.readNextShort();
            this.st_value = reader.readNextLong();
            this.st_size = reader.readNextLong();
        }
        if (this.st_name == 0 && this.getType() == 3) {
            ElfSectionHeader[] sections = header.getSections();
            int uSectionIndex = Short.toUnsignedInt(this.st_shndx);
            if (Short.compareUnsigned(this.st_shndx, (short)-256) < 0 && uSectionIndex < sections.length) {
                ElfSectionHeader section = sections[uSectionIndex];
                this.nameAsString = section.getNameAsString();
            }
        }
    }

    public void initSymbolName(BinaryReader reader, ElfStringTable stringTable) {
        if (this.nameAsString == null && stringTable != null) {
            this.nameAsString = stringTable.readString(reader, this.st_name);
        }
    }

    public ElfSymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    public int getSymbolTableIndex() {
        return this.symbolTableIndex;
    }

    public boolean isNoType() {
        return this.getType() == 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.st_info;
        result = 31 * result + this.st_name;
        result = 31 * result + this.st_other;
        result = 31 * result + this.st_shndx;
        result = 31 * result + (int)(this.st_size ^ this.st_size >>> 32);
        result = 31 * result + (int)(this.st_value ^ this.st_value >>> 32);
        result = 31 * result + this.symbolTableIndex;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ElfSymbol other = (ElfSymbol)obj;
        if (this.st_info != other.st_info) {
            return false;
        }
        if (this.st_name != other.st_name) {
            return false;
        }
        if (this.st_other != other.st_other) {
            return false;
        }
        if (this.st_shndx != other.st_shndx) {
            return false;
        }
        if (this.st_size != other.st_size) {
            return false;
        }
        if (this.st_value != other.st_value) {
            return false;
        }
        return this.symbolTableIndex == other.symbolTableIndex;
    }

    public boolean isLocal() {
        return this.getBind() == 0;
    }

    public boolean isGlobal() {
        return this.getBind() == 1;
    }

    public boolean isWeak() {
        return this.getBind() == 2;
    }

    public boolean isExternal() {
        return (this.isGlobal() || this.isWeak()) && this.getValue() == 0L && this.getSize() == 0L && this.getType() == 0 && this.getSectionHeaderIndex() == 0;
    }

    public boolean isSection() {
        return this.getType() == 3;
    }

    public boolean isFunction() {
        return this.getType() == 2;
    }

    public boolean isObject() {
        return this.getType() == 1;
    }

    public boolean isFile() {
        return this.getType() == 4;
    }

    public boolean isTLS() {
        return this.getType() == 6;
    }

    public boolean isAbsolute() {
        return this.st_shndx == -15;
    }

    public boolean isCommon() {
        return this.st_shndx == -14;
    }

    public byte getInfo() {
        return this.st_info;
    }

    public byte getVisibility() {
        return (byte)(this.st_other & 3);
    }

    public byte getBind() {
        return (byte)(this.st_info >> 4);
    }

    public byte getType() {
        return (byte)(this.st_info & 0xF);
    }

    public int getName() {
        return this.st_name;
    }

    public String getNameAsString() {
        return this.nameAsString;
    }

    public String getFormattedName() {
        return StringUtils.isBlank((CharSequence)this.nameAsString) ? FORMATTED_NO_NAME : this.nameAsString;
    }

    public byte getOther() {
        return this.st_other;
    }

    public short getSectionHeaderIndex() {
        return this.st_shndx;
    }

    public int getExtendedSectionHeaderIndex() {
        return this.symbolTable != null ? this.symbolTable.getExtendedSectionIndex(this) : 0;
    }

    public boolean hasProcessorSpecificSymbolSectionIndex() {
        return Short.compareUnsigned(this.st_shndx, (short)-256) >= 0 && Short.compareUnsigned(this.st_shndx, (short)-225) <= 0;
    }

    public long getSize() {
        return this.st_size;
    }

    public long getValue() {
        return this.st_value;
    }

    public String toString() {
        return this.nameAsString + " - st_value: 0x" + Long.toHexString(this.st_value) + " - st_size: 0x" + Long.toHexString(this.st_size) + " - st_info: 0x" + Integer.toHexString(Byte.toUnsignedInt(this.st_info)) + " - st_other: 0x" + Integer.toHexString(Byte.toUnsignedInt(this.st_other)) + " - st_shndx: 0x" + Integer.toHexString(Short.toUnsignedInt(this.st_shndx));
    }
}

