/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.filters;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gephi.filters.api.Query;
import org.gephi.filters.spi.Category;
import org.gephi.project.api.Workspace;

public final class FilterUIModel {
    private final Workspace workspace;
    private final List<Query> expandedQueryNodes;
    private final List<Query> expandedParametersNodes;
    private final List<Category> expandedCategoryNodes;
    private final List<ChangeListener> listeners;
    private Query selectedQuery;

    public FilterUIModel(Workspace workspace) {
        this.workspace = workspace;
        this.listeners = new ArrayList<ChangeListener>();
        this.expandedQueryNodes = new ArrayList<Query>();
        this.expandedCategoryNodes = new ArrayList<Category>();
        this.expandedParametersNodes = new ArrayList<Query>();
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public Query getSelectedQuery() {
        return this.selectedQuery;
    }

    public void setSelectedQuery(Query query) {
        this.selectedQuery = query;
        this.fireChangeEvent();
    }

    public Query getSelectedRoot() {
        if (this.selectedQuery != null) {
            Query root = this.selectedQuery;
            while (root.getParent() != null) {
                root = root.getParent();
            }
            return root;
        }
        return null;
    }

    public void setExpand(Query query, boolean expanded, boolean parametersExpanded) {
        if (expanded && !this.expandedQueryNodes.contains(query)) {
            this.expandedQueryNodes.add(query);
        } else if (!expanded) {
            this.expandedQueryNodes.remove(query);
        }
        if (parametersExpanded && !this.expandedParametersNodes.contains(query)) {
            this.expandedParametersNodes.add(query);
        } else if (!parametersExpanded) {
            this.expandedParametersNodes.remove(query);
        }
    }

    public void setExpand(Category category, boolean expanded) {
        if (expanded && !this.expandedCategoryNodes.contains(category)) {
            this.expandedCategoryNodes.add(category);
        } else if (!expanded) {
            this.expandedCategoryNodes.remove(category);
        }
    }

    public boolean isExpanded(Query query) {
        return this.expandedQueryNodes.contains(query);
    }

    public boolean isParametersExpanded(Query query) {
        return this.expandedParametersNodes.contains(query);
    }

    public boolean isExpanded(Category category) {
        return this.expandedCategoryNodes.contains(category);
    }

    public void addChangeListener(ChangeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    private void fireChangeEvent() {
        ChangeEvent evt = new ChangeEvent(this);
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(evt);
        }
    }
}

