/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf.extensions;

import org.apache.fop.render.intermediate.IFContext;
import org.apache.fop.render.pdf.extensions.PDFArrayExtension;
import org.apache.fop.render.pdf.extensions.PDFCollectionEntryExtension;
import org.apache.fop.render.pdf.extensions.PDFDictionaryExtension;
import org.apache.fop.render.pdf.extensions.PDFDictionaryType;
import org.apache.fop.render.pdf.extensions.PDFExtensionAttachment;
import org.apache.fop.render.pdf.extensions.PDFPageExtension;
import org.apache.fop.render.pdf.extensions.PDFReferenceExtension;
import org.apache.fop.util.GenerationHelperContentHandler;
import org.apache.xmlgraphics.util.XMLizable;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class PDFDictionaryAttachment
extends PDFExtensionAttachment {
    private static final long serialVersionUID = -5576832955238384505L;
    private PDFDictionaryExtension extension;

    public PDFDictionaryAttachment(PDFDictionaryExtension extension) {
        this.extension = extension;
    }

    public PDFDictionaryExtension getExtension() {
        return this.extension;
    }

    public void toSAX(ContentHandler handler) throws SAXException {
        Object context;
        int pageNumber = 0;
        if (this.extension instanceof PDFPageExtension && handler instanceof GenerationHelperContentHandler && (context = ((GenerationHelperContentHandler)handler).getContentHandlerContext()) instanceof IFContext) {
            int pageIndex = ((IFContext)context).getPageIndex();
            pageNumber = pageIndex >= 0 && ((PDFPageExtension)this.extension).matchesPageNumber(pageIndex + 1) ? pageIndex + 1 : -1;
        }
        if (pageNumber >= 0) {
            this.toSAX(handler, this.extension);
        }
    }

    private void toSAX(ContentHandler handler, PDFDictionaryExtension dictionary) throws SAXException {
        AttributesImpl attributes = new AttributesImpl();
        String ln = dictionary.getElementName();
        String qn = "pdf:" + ln;
        attributes = PDFDictionaryAttachment.extractIFAttributes(attributes, dictionary);
        handler.startElement("apache:fop:extensions:pdf", ln, qn, attributes);
        for (PDFCollectionEntryExtension entry : dictionary.getEntries()) {
            this.toSAX(handler, entry);
        }
        if (this.extension.getExtension() != null) {
            ((XMLizable)this.extension.getExtension()).toSAX(handler);
        }
        handler.endElement("apache:fop:extensions:pdf", ln, qn);
    }

    private void toSAX(ContentHandler handler, PDFArrayExtension array) throws SAXException {
        AttributesImpl attributes = new AttributesImpl();
        String ln = array.getElementName();
        String qn = "pdf:" + ln;
        attributes = PDFDictionaryAttachment.extractIFAttributes(attributes, array);
        handler.startElement("apache:fop:extensions:pdf", ln, qn, attributes);
        for (PDFCollectionEntryExtension entry : array.getEntries()) {
            this.toSAX(handler, entry);
        }
        handler.endElement("apache:fop:extensions:pdf", ln, qn);
    }

    private void toSAX(ContentHandler handler, PDFCollectionEntryExtension entry) throws SAXException {
        if (entry instanceof PDFDictionaryExtension) {
            this.toSAX(handler, (PDFDictionaryExtension)entry);
        } else if (entry instanceof PDFArrayExtension) {
            this.toSAX(handler, (PDFArrayExtension)entry);
        } else {
            char[] characters;
            AttributesImpl attributes = new AttributesImpl();
            String ln = entry.getElementName();
            String qn = "pdf:" + ln;
            attributes = PDFDictionaryAttachment.extractIFAttributes(attributes, entry);
            handler.startElement("apache:fop:extensions:pdf", ln, qn, attributes);
            if (!(entry instanceof PDFReferenceExtension) && (characters = entry.getValueAsXMLEscapedString().toCharArray()).length > 0) {
                handler.characters(characters, 0, characters.length);
            }
            handler.endElement("apache:fop:extensions:pdf", ln, qn);
        }
    }

    private static AttributesImpl extractIFAttributes(AttributesImpl attributes, PDFDictionaryExtension dictionary) {
        PDFDictionaryType type = dictionary.getDictionaryType();
        if (dictionary.usesIDAttribute()) {
            String idName = "id";
            String id = dictionary.getProperty("id");
            if (id != null) {
                attributes.addAttribute("", idName, idName, "ID", id);
            }
        }
        if (type == PDFDictionaryType.Action) {
            String actionTypeName = "type";
            String actionType = dictionary.getProperty("type");
            if (actionType != null) {
                attributes.addAttribute("", actionTypeName, actionTypeName, "CDATA", actionType);
            }
        } else if (type == PDFDictionaryType.Page) {
            String pageNumbersName = "page-numbers";
            String pageNumbers = dictionary.getProperty(pageNumbersName);
            if (pageNumbers != null) {
                attributes.addAttribute("", pageNumbersName, pageNumbersName, "CDATA", pageNumbers);
            }
        } else if (type == PDFDictionaryType.Dictionary) {
            String keyName = "key";
            String key = dictionary.getKey();
            if (key != null) {
                attributes.addAttribute("", keyName, keyName, "CDATA", key);
            }
        }
        return attributes;
    }

    private static AttributesImpl extractIFAttributes(AttributesImpl attributes, PDFArrayExtension array) {
        String keyName = "key";
        String key = array.getKey();
        if (key != null) {
            attributes.addAttribute("", keyName, keyName, "CDATA", key);
        }
        return attributes;
    }

    private static AttributesImpl extractIFAttributes(AttributesImpl attributes, PDFCollectionEntryExtension entry) {
        String refid;
        String keyName = "key";
        String key = entry.getKey();
        if (key != null) {
            attributes.addAttribute("", keyName, keyName, "CDATA", key);
        }
        if (entry instanceof PDFReferenceExtension && (refid = ((PDFReferenceExtension)entry).getReferenceId()) != null) {
            String refidName = "refid";
            attributes.addAttribute("", refidName, refidName, "IDREF", refid);
        }
        return attributes;
    }
}

