/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.dsl;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.DSLAccessor;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Objects;
import sun.misc.Unsafe;

public final class InlineSupport {
    static final ReferenceField<Node> PARENT = new ReferenceField<Node>((Class<?>)Node.class, (Class<?>)Node.class, DSLAccessor.nodeAccessor().nodeLookup(), "parent", Node.class);

    private InlineSupport() {
    }

    public static boolean validate(Node node, InlinableField field0, InlinableField field1, InlinableField ... fields) {
        field0.validate(node);
        field1.validate(node);
        for (InlinableField field : fields) {
            field.validate(node);
        }
        return true;
    }

    public static boolean validate(Node node, InlinableField field0, InlinableField field1) {
        field0.validate(node);
        field1.validate(node);
        return true;
    }

    public static boolean validate(Node node, InlinableField field0) {
        field0.validate(node);
        return true;
    }

    private static String getEnclosingSimpleName(Class<?> c) {
        if (c.getEnclosingClass() != null) {
            return InlineSupport.getEnclosingSimpleName(c.getEnclosingClass()) + "." + c.getSimpleName();
        }
        return c.getSimpleName();
    }

    public static abstract class InlinableField
    extends UnsafeField {
        InlinableField(Class<?> receiverClass, Class<?> declaringClass, MethodHandles.Lookup declaringLookup, String fieldName, Class<?> valueClass) {
            super(receiverClass, declaringClass, declaringLookup, fieldName, valueClass);
        }

        InlinableField(InlinableField prev) {
            super(prev);
        }

        public final boolean validate(Node node) {
            this.resolveReceiver(node);
            return true;
        }

        static RuntimeException invalidValue(Class<?> expectedClass, Object value) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            String message = String.format("Invalid parameter type passed to set. Instance of type '%s' expected but was '%s'. ", InlineSupport.getEnclosingSimpleName(expectedClass), value != null ? InlineSupport.getEnclosingSimpleName(value.getClass()) : "null");
            throw new IllegalArgumentException(message);
        }
    }

    public static final class ReferenceField<T>
    extends InlinableField {
        final Class<?> valueClass;

        ReferenceField(Class<?> receiverClass, Class<?> lookupFieldClass, MethodHandles.Lookup declaringLookup, String fieldName, Class<T> valueClass) {
            super(receiverClass, lookupFieldClass, declaringLookup, fieldName, valueClass);
            this.valueClass = valueClass;
        }

        @Deprecated
        public ReferenceField<T> createParentAccessor(Class<? extends Node> parentClass) {
            return this;
        }

        public T get(Node node) {
            return (T)this.getObject(node);
        }

        public void set(Node node, T value) {
            this.setObject(node, value, this.valueClass);
        }

        public T getVolatile(Node node) {
            return (T)this.getObjectVolatile(node);
        }

        public boolean compareAndSet(Node node, T expect, T update) {
            return this.compareAndSetObject(node, expect, update, this.valueClass);
        }

        public static <T> ReferenceField<T> create(MethodHandles.Lookup declaringLookup, String field, Class<? super T> valueClass) {
            Class<?> lookupClass = declaringLookup.lookupClass();
            return new ReferenceField<T>(lookupClass, lookupClass, declaringLookup, field, valueClass);
        }
    }

    static abstract class VarHandleField {
        private final Class<?> receiverClass;
        private final VarHandle handle;

        VarHandleField(Class<?> receiverClass, Class<?> lookupClass, MethodHandles.Lookup declaringLookup, String fieldName, Class<?> valueClass) {
            try {
                this.receiverClass = receiverClass;
                this.handle = declaringLookup.findVarHandle(lookupClass, fieldName, valueClass);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new IllegalArgumentException(e);
            }
        }

        VarHandleField(VarHandleField prev) {
            this.handle = prev.handle;
            this.receiverClass = prev.receiverClass;
        }

        Class<?> getFieldClass() {
            return this.handle.varType();
        }

        final boolean getBoolean(Object node) {
            return this.handle.get(node);
        }

        final byte getByte(Object node) {
            return this.handle.get(node);
        }

        final short getShort(Object node) {
            return this.handle.get(node);
        }

        final char getChar(Object node) {
            return this.handle.get(node);
        }

        final int getInt(Object node) {
            return this.handle.get(node);
        }

        final float getFloat(Object node) {
            return this.handle.get(node);
        }

        final long getLong(Object node) {
            return this.handle.get(node);
        }

        final double getDouble(Object node) {
            return this.handle.get(node);
        }

        final void setBoolean(Object node, boolean v) {
            this.handle.set(node, v);
        }

        final void setByte(Object node, byte v) {
            this.handle.set(node, v);
        }

        final void setShort(Object node, short v) {
            this.handle.set(node, v);
        }

        final void setChar(Object node, char v) {
            this.handle.set(node, v);
        }

        final void setInt(Object node, int v) {
            this.handle.set(node, v);
        }

        final void setFloat(Object node, float v) {
            this.handle.set(node, v);
        }

        final void setLong(Object node, long v) {
            this.handle.set(node, v);
        }

        final void setDouble(Object node, double v) {
            this.handle.set(node, v);
        }

        final void setObject(Object node, Object v) {
            this.handle.set(node, v);
        }

        final Object getObject(Object node) {
            return this.handle.get(node);
        }

        final Object getObjectVolatile(Object node) {
            return this.handle.getVolatile(node);
        }

        final boolean compareAndSetObject(Object node, Object expect, Object update) {
            return this.handle.compareAndSet(node, expect, update);
        }

        public final String toString() {
            StringBuilder b = new StringBuilder(this.getClass().getSimpleName());
            b.append("[");
            b.append(this.handle);
            b.append("]");
            return b.toString();
        }
    }

    static abstract class UnsafeField {
        final Class<?> declaringClass;
        final String name;
        final Class<?> receiverClass;
        final long offset;
        static final Unsafe U = UnsafeField.getUnsafe();

        UnsafeField(UnsafeField prev) {
            this.offset = prev.offset;
            this.receiverClass = prev.receiverClass;
            this.declaringClass = prev.declaringClass;
            this.name = prev.name;
        }

        UnsafeField(Class<?> receiverClass, final Class<?> declaringClass, final MethodHandles.Lookup declaringLookup, final String fieldName, Class<?> valueClass) {
            Class<?> fieldClass;
            Field field;
            Objects.requireNonNull(receiverClass);
            Objects.requireNonNull(declaringClass);
            Objects.requireNonNull(declaringLookup);
            Objects.requireNonNull(fieldName);
            Objects.requireNonNull(valueClass);
            try {
                this.declaringClass = declaringClass;
                this.name = fieldName;
                field = AccessController.doPrivileged(new PrivilegedExceptionAction<Field>(){
                    final /* synthetic */ UnsafeField this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public Field run() throws NoSuchFieldException {
                        if (declaringLookup == null) {
                            return null;
                        }
                        return declaringClass.getDeclaredField(fieldName);
                    }
                });
                fieldClass = field.getType();
            }
            catch (PrivilegedActionException pae) {
                if (pae.getException() instanceof NoSuchFieldException) {
                    throw new IllegalArgumentException(String.format("No such field %s.%s.", declaringClass.getName(), fieldName), pae);
                }
                throw new AssertionError((Object)pae.getException());
            }
            if (!fieldClass.isAssignableFrom(valueClass)) {
                throw new IllegalArgumentException(String.format("Expected field type %s, but got %s. ", valueClass.getName(), fieldClass.getName()));
            }
            if (!declaringClass.isAssignableFrom(receiverClass)) {
                throw new AssertionError((Object)String.format("Receiver class %s is not assignable to the declaring class %s.", receiverClass.getName(), declaringClass.getName()));
            }
            int modifiers = field.getModifiers();
            if (Modifier.isFinal(modifiers)) {
                throw new IllegalArgumentException("Must not be final field");
            }
            this.receiverClass = receiverClass;
            this.offset = U.objectFieldOffset(field);
        }

        final Object resolveReceiver(Object node) {
            CompilerAsserts.partialEvaluationConstant(this);
            CompilerAsserts.partialEvaluationConstant(node);
            Object value = node.getClass() == this.receiverClass ? node : this.resolveReceiverSlow(node);
            return this.receiverClass.cast(value);
        }

        @ExplodeLoop
        private Object resolveReceiverSlow(Object node) {
            if (this.receiverClass.isInstance(node)) {
                return node;
            }
            Object receiver = node;
            while (receiver != null) {
                assert (this.validateForParentLookup(node, receiver));
                if (!this.receiverClass.isInstance(receiver = U.getObject(receiver, InlineSupport.PARENT.offset))) continue;
            }
            if (receiver == null) {
                throw this.nullError(node);
            }
            return receiver;
        }

        @CompilerDirectives.TruffleBoundary
        private boolean validateForParentLookup(Object inlineTarget, Object parent) {
            if (CompilerDirectives.inCompiledCode()) {
                return true;
            }
            if (parent == null) {
                return true;
            }
            if (inlineTarget instanceof DSLSupport.SpecializationDataNode && !(parent instanceof DSLSupport.SpecializationDataNode)) {
                throw this.invalidReceiver(inlineTarget);
            }
            return true;
        }

        private RuntimeException nullError(Object node) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            if (node == null) {
                throw this.nullReceiver(node);
            }
            throw this.invalidReceiver(node);
        }

        private NullPointerException nullReceiver(Object node) {
            CompilerAsserts.neverPartOfCompilation();
            return new NullPointerException(String.format("Invalid inline context node passed to an inlined field. A receiver of type '%s' was expected but is null. Did you pass the wrong node to an execute method of an inlined cached node?", InlineSupport.getEnclosingSimpleName(this.receiverClass)));
        }

        private RuntimeException invalidReceiver(Object inlineTarget) {
            CompilerAsserts.neverPartOfCompilation();
            throw new ClassCastException(String.format("Invalid inline context node passed to an inlined field. A receiver of type '%s' was expected but is '%s'. Did you pass the wrong node to an execute method of an inlined cached node?", InlineSupport.getEnclosingSimpleName(this.receiverClass), InlineSupport.getEnclosingSimpleName(inlineTarget.getClass())));
        }

        final boolean getBoolean(Object node) {
            return U.getBoolean(this.resolveReceiver(node), this.offset);
        }

        final byte getByte(Object node) {
            return U.getByte(this.resolveReceiver(node), this.offset);
        }

        final short getShort(Object node) {
            return U.getShort(this.resolveReceiver(node), this.offset);
        }

        final char getChar(Object node) {
            return U.getChar(this.resolveReceiver(node), this.offset);
        }

        final int getInt(Object node) {
            return U.getInt(this.resolveReceiver(node), this.offset);
        }

        final float getFloat(Object node) {
            return U.getFloat(this.resolveReceiver(node), this.offset);
        }

        final long getLong(Object node) {
            return U.getLong(this.resolveReceiver(node), this.offset);
        }

        final double getDouble(Object node) {
            return U.getDouble(this.resolveReceiver(node), this.offset);
        }

        final Object getObject(Object node) {
            return U.getObject(this.resolveReceiver(node), this.offset);
        }

        final void setBoolean(Object node, boolean v) {
            U.putBoolean(this.resolveReceiver(node), this.offset, v);
        }

        final void setByte(Object node, byte v) {
            U.putByte(this.resolveReceiver(node), this.offset, v);
        }

        final void setShort(Object node, short v) {
            U.putShort(this.resolveReceiver(node), this.offset, v);
        }

        final void setChar(Object node, char v) {
            U.putChar(this.resolveReceiver(node), this.offset, v);
        }

        final void setInt(Object node, int v) {
            U.putInt(this.resolveReceiver(node), this.offset, v);
        }

        final void setFloat(Object node, float v) {
            U.putFloat(this.resolveReceiver(node), this.offset, v);
        }

        final void setLong(Object node, long v) {
            U.putLong(this.resolveReceiver(node), this.offset, v);
        }

        final void setDouble(Object node, double v) {
            U.putDouble(this.resolveReceiver(node), this.offset, v);
        }

        final void setObject(Object node, Object v, Class<?> valueClass) {
            if (!valueClass.isInstance(v) && v != null) {
                throw InlinableField.invalidValue(valueClass, v);
            }
            U.putObject(this.resolveReceiver(node), this.offset, v);
        }

        final Object getObjectVolatile(Object node) {
            return U.getObjectVolatile(this.resolveReceiver(node), this.offset);
        }

        final boolean compareAndSetObject(Object node, Object expect, Object update, Class<?> valueClass) {
            if (!valueClass.isInstance(update) && update != null) {
                throw InlinableField.invalidValue(valueClass, update);
            }
            return U.compareAndSwapObject(this.resolveReceiver(node), this.offset, expect, update);
        }

        private static Unsafe getUnsafe() {
            try {
                return Unsafe.getUnsafe();
            }
            catch (SecurityException securityException) {
                try {
                    Field theUnsafeInstance = Unsafe.class.getDeclaredField("theUnsafe");
                    theUnsafeInstance.setAccessible(true);
                    return (Unsafe)theUnsafeInstance.get(Unsafe.class);
                }
                catch (Exception e) {
                    throw new RuntimeException("exception while trying to get Unsafe.theUnsafe via reflection:", e);
                }
            }
        }
    }

    public static final class DoubleField
    extends InlinableField {
        DoubleField(MethodHandles.Lookup declaringLookup, String fieldName) {
            super(declaringLookup.lookupClass(), declaringLookup.lookupClass(), declaringLookup, fieldName, Double.TYPE);
        }

        @Deprecated
        public DoubleField createParentAccessor(Class<? extends Node> parentClass) {
            return this;
        }

        public double get(Node node) {
            return this.getDouble(node);
        }

        public void set(Node node, double value) {
            this.setDouble(node, value);
        }

        public static DoubleField create(MethodHandles.Lookup declaringLookup, String field) {
            return new DoubleField(declaringLookup, field);
        }
    }

    public static final class LongField
    extends InlinableField {
        LongField(MethodHandles.Lookup declaringLookup, String fieldName) {
            super(declaringLookup.lookupClass(), declaringLookup.lookupClass(), declaringLookup, fieldName, Long.TYPE);
        }

        @Deprecated
        public LongField createParentAccessor(Class<? extends Node> parentClass) {
            return this;
        }

        public long get(Node node) {
            return this.getLong(node);
        }

        public void set(Node node, long value) {
            this.setLong(node, value);
        }

        public static LongField create(MethodHandles.Lookup declaringLookup, String field) {
            return new LongField(declaringLookup, field);
        }
    }

    public static final class IntField
    extends InlinableField {
        IntField(MethodHandles.Lookup declaringLookup, String fieldName) {
            super(declaringLookup.lookupClass(), declaringLookup.lookupClass(), declaringLookup, fieldName, Integer.TYPE);
        }

        @Deprecated
        public IntField createParentAccessor(Class<? extends Node> parentClass) {
            return this;
        }

        public int get(Node node) {
            return this.getInt(node);
        }

        public void set(Node node, int value) {
            this.setInt(node, value);
        }

        public static IntField create(MethodHandles.Lookup declaringLookup, String field) {
            return new IntField(declaringLookup, field);
        }
    }

    public static final class FloatField
    extends InlinableField {
        FloatField(MethodHandles.Lookup declaringLookup, String fieldName) {
            super(declaringLookup.lookupClass(), declaringLookup.lookupClass(), declaringLookup, fieldName, Float.TYPE);
        }

        @Deprecated
        public FloatField createParentAccessor(Class<? extends Node> parentClass) {
            return this;
        }

        public float get(Node node) {
            return this.getFloat(node);
        }

        public void set(Node node, float value) {
            this.setFloat(node, value);
        }

        public static FloatField create(MethodHandles.Lookup declaringLookup, String field) {
            return new FloatField(declaringLookup, field);
        }
    }

    public static final class CharField
    extends InlinableField {
        CharField(MethodHandles.Lookup declaringLookup, String fieldName) {
            super(declaringLookup.lookupClass(), declaringLookup.lookupClass(), declaringLookup, fieldName, Character.TYPE);
        }

        @Deprecated
        public CharField createParentAccessor(Class<? extends Node> parentClass) {
            return this;
        }

        public char get(Node node) {
            return this.getChar(node);
        }

        public void set(Node node, char value) {
            this.setChar(node, value);
        }

        public static CharField create(MethodHandles.Lookup declaringLookup, String field) {
            return new CharField(declaringLookup, field);
        }
    }

    public static final class ShortField
    extends InlinableField {
        ShortField(MethodHandles.Lookup declaringLookup, String fieldName) {
            super(declaringLookup.lookupClass(), declaringLookup.lookupClass(), declaringLookup, fieldName, Short.TYPE);
        }

        @Deprecated
        public ShortField createParentAccessor(Class<? extends Node> parentClass) {
            return this;
        }

        public short get(Node node) {
            return this.getShort(node);
        }

        public void set(Node node, short value) {
            this.setShort(node, value);
        }

        public static ShortField create(MethodHandles.Lookup declaringLookup, String field) {
            return new ShortField(declaringLookup, field);
        }
    }

    public static final class ByteField
    extends InlinableField {
        ByteField(MethodHandles.Lookup declaringLookup, String fieldName) {
            super(declaringLookup.lookupClass(), declaringLookup.lookupClass(), declaringLookup, fieldName, Byte.TYPE);
        }

        @Deprecated
        public ByteField createParentAccessor(Class<? extends Node> parentClass) {
            return this;
        }

        public byte get(Node node) {
            return this.getByte(node);
        }

        public void set(Node node, byte value) {
            this.setByte(node, value);
        }

        public static ByteField create(MethodHandles.Lookup declaringLookup, String field) {
            return new ByteField(declaringLookup, field);
        }
    }

    public static final class BooleanField
    extends InlinableField {
        BooleanField(MethodHandles.Lookup lookup, String fieldName) {
            super(lookup.lookupClass(), lookup.lookupClass(), lookup, fieldName, Boolean.TYPE);
        }

        @Deprecated
        public BooleanField createParentAccessor(Class<? extends Node> parentClass) {
            return this;
        }

        public boolean get(Node node) {
            return this.getBoolean(node);
        }

        public void set(Node node, boolean value) {
            this.setBoolean(node, value);
        }

        public static BooleanField create(MethodHandles.Lookup declaringLookup, String field) {
            return new BooleanField(declaringLookup, field);
        }
    }

    public static final class StateField
    extends InlinableField {
        final int bitOffset;
        final int bitLength;
        final int bitMask;

        StateField(MethodHandles.Lookup declaringLookup, String fieldName, int offset, int length) {
            super(declaringLookup.lookupClass(), declaringLookup.lookupClass(), declaringLookup, fieldName, Integer.TYPE);
            this.bitOffset = offset;
            this.bitLength = length;
            this.bitMask = StateField.computeMask(offset, length);
        }

        StateField(StateField prev, int offset, int length) {
            super(prev);
            this.bitOffset = prev.bitOffset + offset;
            this.bitLength = length;
            this.bitMask = StateField.computeMask(this.bitOffset, length);
        }

        private static int computeMask(int offset, int length) {
            int mask = 0;
            for (int i = offset; i < offset + length; ++i) {
                mask |= 1 << i;
            }
            return mask;
        }

        @Deprecated
        public StateField createParentAccessor(Class<? extends Node> parentClass) {
            return this;
        }

        public StateField subUpdater(int newOffset, int newLength) {
            if (newOffset < 0) {
                throw new IllegalArgumentException("New offset parameter must not be negative.");
            }
            if (newOffset + newLength > this.bitLength) {
                throw new IllegalArgumentException("Illegal new length parameter must not exceed the available bit length.");
            }
            if (newLength <= 0) {
                throw new IllegalArgumentException("Invalid new length.");
            }
            if (newOffset == 0 && newLength == this.bitLength) {
                return this;
            }
            return new StateField(this, newOffset, newLength);
        }

        public int get(Node node) {
            return (this.getInt(node) & this.bitMask) >>> this.bitOffset;
        }

        public void set(Node node, int value) {
            assert (this.noBitsLost(value));
            Node receiver = node;
            int newState = this.getInt(receiver) & ~this.bitMask | value << this.bitOffset & this.bitMask;
            this.setInt(receiver, newState);
        }

        private boolean noBitsLost(int providedBits) {
            int writtenBits = (providedBits << this.bitOffset & this.bitMask) >>> this.bitOffset;
            if (writtenBits != providedBits) {
                throw new IllegalArgumentException(String.format("Bits lost in masked state updater set. Provided bits: 0x%s Written bits: 0x%s. This could indicate a bug in subUpdater indices in the node object inlining logic.", Integer.toHexString(providedBits), Integer.toHexString(writtenBits)));
            }
            return true;
        }

        public static StateField create(MethodHandles.Lookup declaringLookup, String field) {
            return new StateField(declaringLookup, field, 0, 32);
        }
    }

    public static final class InlineTarget {
        private final Class<?> targetClass;
        private final InlinableField[] updaters;

        InlineTarget(Class<?> targetClass, InlinableField[] updaters) {
            this.targetClass = targetClass;
            this.updaters = updaters;
        }

        public Class<?> getTargetClass() {
            return this.targetClass;
        }

        public <T extends InlinableField> T getPrimitive(int index, Class<T> fieldClass) {
            Objects.requireNonNull(fieldClass);
            if (!InlineTarget.isPrimitiveField(fieldClass)) {
                throw InlineTarget.incompatibleAccessError(String.format("Invalid or modified field type. Expected primitive field but got %s.", fieldClass.getName()));
            }
            return (T)((InlinableField)this.get(index, fieldClass));
        }

        public StateField getState(int index, int minimumBits) {
            if (minimumBits <= 0 || minimumBits > 32) {
                throw new IllegalArgumentException("Invalid minimum bits. Expected >= 0 and <= 32 but was " + minimumBits + ".");
            }
            StateField field = this.get(index, StateField.class);
            if (minimumBits > field.bitLength) {
                throw InlineTarget.incompatibleAccessError(String.format("Expected minimum state bits %s, but got %s.", minimumBits, field.bitLength));
            }
            return field;
        }

        public <V> ReferenceField<V> getReference(int index, Class<?> valueClass) {
            Objects.requireNonNull(valueClass);
            ReferenceField reference = this.get(index, ReferenceField.class);
            Class<?> varType = reference.valueClass;
            if (!varType.isAssignableFrom(valueClass)) {
                throw InlineTarget.incompatibleAccessError(String.format("Expected reference type %s, but got %s. ", valueClass.getName(), varType.getName()));
            }
            return reference;
        }

        private <T> T get(int index, Class<T> fieldClass) throws IncompatibleClassChangeError {
            if (index >= this.updaters.length) {
                throw InlineTarget.incompatibleAccessError(String.format("Expected number of updaters %s, but got %s. ", index + 1, this.updaters.length));
            }
            if (this.updaters[index].getClass() != fieldClass) {
                throw InlineTarget.incompatibleAccessError(String.format("Expected field type %s, but got %s. ", fieldClass, this.updaters[index].getClass()));
            }
            return fieldClass.cast(this.updaters[index]);
        }

        private static IncompatibleClassChangeError incompatibleAccessError(String detailMessage) {
            return new IncompatibleClassChangeError(String.format("Node inlining specification has changed in an incompatible way. %sRecompilation from source may solve this problem.", detailMessage));
        }

        private static boolean isReferenceField(Class<?> fieldClass) {
            return fieldClass == ReferenceField.class;
        }

        private static boolean isStateField(Class<?> fieldClass) {
            return fieldClass == StateField.class;
        }

        private static boolean isPrimitiveField(Class<?> fieldClass) {
            return !InlineTarget.isReferenceField(fieldClass) && !InlineTarget.isStateField(fieldClass);
        }

        public static InlineTarget create(Class<?> targetClass, InlinableField ... updaters) {
            Objects.requireNonNull(targetClass);
            Objects.requireNonNull(updaters);
            for (InlinableField updater : updaters) {
                Objects.requireNonNull(updater);
            }
            return new InlineTarget(targetClass, updaters);
        }
    }

    @Retention(value=RetentionPolicy.CLASS)
    @Target(value={ElementType.PARAMETER})
    public static @interface RequiredFields {
        public RequiredField[] value();
    }

    @Retention(value=RetentionPolicy.CLASS)
    @Target(value={ElementType.FIELD})
    public static @interface UnsafeAccessedField {
    }

    @Retention(value=RetentionPolicy.CLASS)
    @Target(value={ElementType.PARAMETER})
    @Repeatable(value=RequiredFields.class)
    public static @interface RequiredField {
        public Class<? extends InlinableField> value();

        public int bits() default 0;

        public Class<?> type() default InlinableField.class;

        public int dimensions() default 0;
    }
}

