/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime.formatting;

import com.oracle.truffle.api.CompilerDirectives;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.IntStream;

abstract class FormattingBuffer
implements CharSequence {
    FormattingBuffer() {
    }

    public abstract FormattingBuffer append(char var1);

    public final FormattingBuffer append(int value) {
        return this.append(Integer.toString(value));
    }

    public abstract FormattingBuffer append(CharSequence var1);

    public abstract FormattingBuffer append(CharSequence var1, int var2, int var3);

    public abstract FormattingBuffer appendCodePoint(int var1);

    public abstract FormattingBuffer setCharAt(int var1, char var2);

    public abstract FormattingBuffer replace(int var1, int var2, String var3);

    public abstract FormattingBuffer insert(int var1, char var2);

    public abstract FormattingBuffer setLength(int var1);

    @Override
    public abstract int length();

    public abstract String substring(int var1);

    public abstract int codePointCount(int var1, int var2);

    public abstract Object toResult();

    @Override
    public abstract String toString();

    public abstract FormattingBuffer ensureCapacity(int var1);

    public final FormattingBuffer ensureAdditionalCapacity(int additional) {
        int newCapacity = this.length() + additional;
        if (newCapacity < 0) {
            throw new OutOfMemoryError();
        }
        return this.ensureCapacity(newCapacity);
    }

    static final class BytesFormattingBuffer
    extends FormattingBuffer {
        private byte[] data = new byte[32];
        private int size;
        private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

        BytesFormattingBuffer() {
        }

        @Override
        public FormattingBuffer append(char c) {
            this.ensureCapacity(this.size, 1);
            this.data[this.size++] = (byte)c;
            return this;
        }

        @Override
        public FormattingBuffer append(CharSequence str) {
            return this.append(str.toString().getBytes(StandardCharsets.US_ASCII));
        }

        @Override
        public FormattingBuffer append(CharSequence str, int start, int end) {
            byte[] bytes = str.subSequence(start, end).toString().getBytes(StandardCharsets.US_ASCII);
            return this.append(bytes);
        }

        public FormattingBuffer append(byte[] bytes) {
            return this.append(bytes, 0, bytes.length);
        }

        public FormattingBuffer append(byte[] bytes, int offset, int len) {
            this.ensureCapacity(this.size, len);
            System.arraycopy(bytes, offset, this.data, this.size, len);
            this.size += len;
            return this;
        }

        @Override
        public FormattingBuffer appendCodePoint(int value) {
            this.append((char)value);
            return this;
        }

        @Override
        public FormattingBuffer setCharAt(int index, char c) {
            this.ensureCapacity(index, 1);
            this.size = Math.max(index + 1, this.size);
            this.data[index] = (byte)c;
            return this;
        }

        @Override
        public FormattingBuffer replace(int start, int end, String str) {
            this.ensureCapacity(end);
            byte[] bytes = str.getBytes(StandardCharsets.US_ASCII);
            System.arraycopy(bytes, 0, this.data, start, Math.min(bytes.length, end - start));
            return this;
        }

        @Override
        public FormattingBuffer insert(int index, char c) {
            this.ensureCapacity(this.size, 1);
            System.arraycopy(this.data, index, this.data, index + 1, this.size - index);
            this.data[index] = (byte)c;
            ++this.size;
            return this;
        }

        @Override
        public FormattingBuffer setLength(int newLength) {
            this.size = newLength;
            return this;
        }

        @Override
        public int length() {
            return this.size;
        }

        @Override
        public char charAt(int index) {
            return (char)this.data[index];
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return new String(Arrays.copyOfRange(this.data, start, end), StandardCharsets.US_ASCII);
        }

        @Override
        public String substring(int index) {
            return new String(Arrays.copyOfRange(this.data, index, this.size), StandardCharsets.US_ASCII);
        }

        @Override
        public int codePointCount(int mark, int length) {
            return length - mark;
        }

        public byte[] toResult() {
            return Arrays.copyOf(this.data, this.size);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public String toString() {
            return Objects.toString(this);
        }

        @Override
        public FormattingBuffer ensureCapacity(int capacity) {
            if (capacity < 0) {
                throw new IllegalArgumentException();
            }
            this.ensureCapacity(capacity, 0);
            return this;
        }

        public void ensureCapacity(int capacity, int add) {
            assert (capacity >= 0);
            assert (add >= 0);
            int newCapacity = capacity + add;
            if (newCapacity < capacity || newCapacity > 0x7FFFFFF7) {
                throw new OutOfMemoryError();
            }
            if (this.data.length < newCapacity) {
                this.data = Arrays.copyOf(this.data, this.newCapacity(newCapacity));
            }
        }

        private int newCapacity(int minCapacity) {
            int newCapacity = (this.data.length << 1) + 2;
            if (newCapacity < this.data.length || newCapacity > 0x7FFFFFF7) {
                return 0x7FFFFFF7;
            }
            return Math.max(newCapacity, minCapacity);
        }
    }

    static final class StringFormattingBuffer
    extends FormattingBuffer {
        private final StringBuilder buffer;

        public StringFormattingBuffer() {
            this.buffer = new StringBuilder();
        }

        public StringFormattingBuffer(int capacity) {
            this.buffer = new StringBuilder(capacity);
        }

        @Override
        public FormattingBuffer append(char c) {
            this.buffer.append(c);
            return this;
        }

        @Override
        public FormattingBuffer append(CharSequence str) {
            this.buffer.append(str);
            return this;
        }

        @Override
        public FormattingBuffer append(CharSequence str, int start, int end) {
            this.buffer.append(str, start, end);
            return this;
        }

        @Override
        public FormattingBuffer insert(int index, char c) {
            this.buffer.insert(index, c);
            return this;
        }

        @Override
        public FormattingBuffer setCharAt(int index, char c) {
            this.buffer.setCharAt(index, c);
            return this;
        }

        @Override
        public FormattingBuffer replace(int start, int end, String str) {
            this.buffer.replace(start, end, str);
            return this;
        }

        @Override
        public FormattingBuffer setLength(int newLength) {
            this.buffer.setLength(newLength);
            return this;
        }

        @Override
        public int length() {
            return this.buffer.length();
        }

        @Override
        public String toResult() {
            return this.buffer.toString();
        }

        @Override
        public String toString() {
            return this.toResult();
        }

        @Override
        public IntStream chars() {
            return this.buffer.chars();
        }

        @Override
        public IntStream codePoints() {
            return this.buffer.codePoints();
        }

        @Override
        public char charAt(int index) {
            return this.buffer.charAt(index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.buffer.subSequence(start, end);
        }

        @Override
        public FormattingBuffer appendCodePoint(int value) {
            this.buffer.appendCodePoint(value);
            return this;
        }

        @Override
        public String substring(int len) {
            return this.buffer.substring(len);
        }

        @Override
        public int codePointCount(int mark, int length) {
            return this.buffer.codePointCount(mark, length);
        }

        @Override
        public FormattingBuffer ensureCapacity(int capacity) {
            this.buffer.ensureCapacity(capacity);
            return this;
        }
    }
}

