/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid;

import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.GridUtilCore;
import com.intellij.database.remote.jdbc.LobInfo;
import com.intellij.openapi.util.Comparing;
import java.math.BigInteger;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridRowComparator
implements Comparator<GridRow> {
    protected final GridColumn myColumn;

    protected GridRowComparator(@NotNull GridColumn column) {
        if (column == null) {
            GridRowComparator.$$$reportNull$$$0(0);
        }
        this.myColumn = column;
    }

    @Override
    public int compare(GridRow row1, GridRow row2) {
        Object v1 = this.myColumn.getValue(row1);
        Object v2 = this.myColumn.getValue(row2);
        return this.compareObjects(v1, v2);
    }

    public int compareObjects(Object v1, Object v2) {
        if (v1 instanceof String && v2 instanceof String) {
            if (this.myColumn.getType() == 4) {
                try {
                    int i1 = Integer.parseInt((String)v1);
                    int i2 = Integer.parseInt((String)v2);
                    return Integer.compare(i1, i2);
                }
                catch (NumberFormatException i1) {}
            } else if (this.myColumn.getType() == 8) {
                try {
                    double i1 = Double.parseDouble((String)v1);
                    double i2 = Double.parseDouble((String)v2);
                    return Double.compare(i1, i2);
                }
                catch (NumberFormatException i1) {}
            } else if (this.myColumn.getType() == -5) {
                try {
                    BigInteger i1 = new BigInteger((String)v1);
                    BigInteger i2 = new BigInteger((String)v2);
                    return i1.compareTo(i2);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return GridRowComparator.compareValues(v1, v2);
    }

    @Nullable
    public static GridRowComparator create(@NotNull GridColumn column) {
        if (column == null) {
            GridRowComparator.$$$reportNull$$$0(1);
        }
        return GridUtilCore.isRowId((GridColumn)column) ? null : new GridRowComparator(column);
    }

    private static int compareValues(Object v1, Object v2) {
        if (v1 == v2) {
            return 0;
        }
        if (v1 == null) {
            return -1;
        }
        if (v2 == null) {
            return 1;
        }
        if (GridUtil.isFailedToLoad(v1)) {
            return GridUtil.isFailedToLoad(v2) ? Comparing.compare((Comparable)((Object)((String)v1)), (Comparable)((Object)((String)v2))) : -1;
        }
        if (GridUtil.isFailedToLoad(v2)) {
            return 1;
        }
        if (v1 instanceof Comparable && v2 instanceof Comparable && v1.getClass() == v2.getClass()) {
            return ((Comparable)v1).compareTo(v2);
        }
        if (v1 instanceof String && v2 instanceof LobInfo.ClobInfo) {
            return -((LobInfo.ClobInfo)v2).compareTo((String)v1);
        }
        if (v2 instanceof String && v1 instanceof LobInfo.ClobInfo) {
            return ((LobInfo.ClobInfo)v1).compareTo((String)v2);
        }
        if (v1 instanceof Number && v2 instanceof Number) {
            int result1 = Double.compare(((Number)v1).doubleValue(), ((Number)v2).doubleValue());
            long result2 = ((Number)v1).longValue() - ((Number)v2).longValue();
            if (result1 < 0 && result2 < 0L) {
                return -1;
            }
            if (result1 > 0 && result2 > 0L) {
                return 1;
            }
            return 0;
        }
        if (v1 instanceof byte[] && v2 instanceof LobInfo.BlobInfo) {
            return -((LobInfo.BlobInfo)v2).compareTo((byte[])v1);
        }
        if (v2 instanceof byte[] && v1 instanceof LobInfo.BlobInfo) {
            return ((LobInfo.BlobInfo)v1).compareTo((byte[])v2);
        }
        if (v1 instanceof Object[]) {
            Object[] array1 = (Object[])v1;
            if (v2 instanceof Object[]) {
                Object[] array2 = (Object[])v2;
                int maxLength = Math.max(array1.length, array2.length);
                for (int i = 0; i < maxLength; ++i) {
                    int comparisonResult = GridRowComparator.compareValues(i < array1.length ? array1[i] : null, i < array2.length ? array2[i] : null);
                    if (comparisonResult == 0) continue;
                    return comparisonResult;
                }
                return 0;
            }
        }
        return v1.getClass().getCanonicalName().compareTo(v2.getClass().getCanonicalName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "column";
        objectArray2[1] = "com/intellij/database/run/ui/grid/GridRowComparator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

