/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.data;

import com.google.common.collect.Maps;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.elk.core.AbstractLayoutProvider;
import org.eclipse.elk.core.data.ILayoutMetaData;
import org.eclipse.elk.core.util.IFactory;
import org.eclipse.elk.core.util.InstancePool;
import org.eclipse.elk.core.validation.IValidatingGraphElementVisitor;
import org.eclipse.elk.graph.properties.GraphFeature;
import org.eclipse.elk.graph.properties.IProperty;

public final class LayoutAlgorithmData
implements ILayoutMetaData {
    private final String id;
    private final String name;
    private final InstancePool<AbstractLayoutProvider> providerPool;
    private final String category;
    private final String melkBundleName;
    private final String definingBundleId;
    private final String description;
    private final String imagePath;
    private final Set<GraphFeature> supportedFeatures;
    private final Class<? extends IValidatingGraphElementVisitor> validatorClass;
    private final Map<String, Object> knownOptions = Maps.newHashMap();

    private LayoutAlgorithmData(Builder builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.providerPool = new InstancePool<AbstractLayoutProvider>(builder.providerFactory);
        this.category = builder.category;
        this.melkBundleName = builder.melkBundleName;
        this.definingBundleId = builder.definingBundleId;
        this.imagePath = builder.imagePath;
        this.supportedFeatures = builder.supportedFeatures == null ? EnumSet.noneOf(GraphFeature.class) : builder.supportedFeatures;
        this.validatorClass = builder.validatorClass;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LayoutAlgorithmData) {
            return this.id.equals(((LayoutAlgorithmData)obj).id);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return "Layout Algorithm: " + this.id;
    }

    public void addKnownOption(IProperty<?> property, Object defaultValue) {
        this.knownOptions.put(property.getId(), defaultValue);
    }

    public Set<String> getKnownOptionIds() {
        return this.knownOptions.keySet();
    }

    public boolean knowsOption(IProperty<?> property) {
        return this.knowsOption(property.getId());
    }

    public boolean knowsOption(String propertyId) {
        return this.knownOptions.containsKey(propertyId);
    }

    public Object getDefaultValue(IProperty<?> property) {
        return this.getDefaultValue(property.getId());
    }

    public Object getDefaultValue(String propertyId) {
        return this.knownOptions.get(propertyId);
    }

    public boolean supportsFeature(GraphFeature graphFeature) {
        return this.supportedFeatures.contains((Object)graphFeature);
    }

    public Set<GraphFeature> getSupportedFeatures() {
        return this.supportedFeatures;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public InstancePool<AbstractLayoutProvider> getInstancePool() {
        return this.providerPool;
    }

    public Class<? extends IValidatingGraphElementVisitor> getValidatorClass() {
        return this.validatorClass;
    }

    public String getCategoryId() {
        return this.category;
    }

    public String getBundleName() {
        return this.melkBundleName;
    }

    public String getDefiningBundleId() {
        return this.definingBundleId;
    }

    public String getPreviewImagePath() {
        return this.imagePath;
    }

    public static class Builder {
        private String id;
        private String name;
        private IFactory<AbstractLayoutProvider> providerFactory;
        private String category;
        private String melkBundleName;
        private String definingBundleId;
        private String description;
        private String imagePath;
        private Set<GraphFeature> supportedFeatures;
        private Class<? extends IValidatingGraphElementVisitor> validatorClass;

        public LayoutAlgorithmData create() {
            return new LayoutAlgorithmData(this);
        }

        public Builder id(String aid) {
            this.id = aid;
            return this;
        }

        public Builder name(String aname) {
            this.name = aname;
            return this;
        }

        public Builder providerFactory(IFactory<AbstractLayoutProvider> aproviderFactory) {
            this.providerFactory = aproviderFactory;
            return this;
        }

        public Builder category(String acategory) {
            this.category = acategory;
            return this;
        }

        public Builder melkBundleName(String amelkBundleName) {
            this.melkBundleName = amelkBundleName;
            return this;
        }

        public Builder definingBundleId(String adefiningBundleId) {
            this.definingBundleId = adefiningBundleId;
            return this;
        }

        public Builder description(String adescription) {
            this.description = adescription;
            return this;
        }

        public Builder imagePath(String aimagePath) {
            this.imagePath = aimagePath;
            return this;
        }

        public Builder supportedFeatures(Set<GraphFeature> asupportedFeatures) {
            this.supportedFeatures = asupportedFeatures;
            return this;
        }

        public Builder validatorClass(Class<? extends IValidatingGraphElementVisitor> avalidator) {
            this.validatorClass = avalidator;
            return this;
        }
    }
}

