/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.core.impl;

import java.time.Instant;
import javax.annotation.Nonnull;
import net.shibboleth.shared.xml.AttributeSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.saml.common.AbstractSAMLObjectMarshaller;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.w3c.dom.Element;

public class AuthnStatementMarshaller
extends AbstractSAMLObjectMarshaller {
    @Override
    protected void marshallAttributes(@Nonnull XMLObject xmlObject, @Nonnull Element domElement) throws MarshallingException {
        AuthnStatement authnStatement = (AuthnStatement)xmlObject;
        Instant i = authnStatement.getAuthnInstant();
        if (i != null) {
            AttributeSupport.appendDateTimeAttribute(domElement, AuthnStatement.AUTHN_INSTANT_ATTRIB_QNAME, i);
        }
        if (authnStatement.getSessionIndex() != null) {
            domElement.setAttributeNS(null, "SessionIndex", authnStatement.getSessionIndex());
        }
        if ((i = authnStatement.getSessionNotOnOrAfter()) != null) {
            AttributeSupport.appendDateTimeAttribute(domElement, AuthnStatement.SESSION_NOT_ON_OR_AFTER_ATTRIB_QNAME, i);
        }
    }
}

