/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.condition;

import java.util.ArrayList;
import java.util.List;
import org.keycloak.models.KeycloakSession;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.services.clientpolicy.condition.AbstractClientPolicyConditionProviderFactory;
import org.keycloak.services.clientpolicy.condition.ClientAttributesCondition;
import org.keycloak.services.clientpolicy.condition.ClientPolicyConditionProvider;

public class ClientAttributesConditionFactory
extends AbstractClientPolicyConditionProviderFactory {
    public static final String PROVIDER_ID = "client-attributes";
    public static final String ATTRIBUTES = "attributes";
    private static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();

    public ClientPolicyConditionProvider create(KeycloakSession session) {
        return new ClientAttributesCondition(session);
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getHelpText() {
        return "The condition checks whether all of the specified client attributes exists on the client to determine whether the policy is applied. This effectively allows client administrator to create client attribute of specified name on the client to make sure that particular client policy will be applied on requests of this client. Condition is checked during most of OpenID Connect requests (Authorization request, token requests, introspection endpoint request etc.).";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    static {
        ClientAttributesConditionFactory.addCommonConfigProperties(configProperties);
        ProviderConfigProperty property = new ProviderConfigProperty(ATTRIBUTES, "client-attributes.label", "client-attributes-condition.tooltip", "Map", null);
        configProperties.add(property);
    }
}

