/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

public enum HistogramType {
    DB_GET(0),
    DB_WRITE(1),
    COMPACTION_TIME(2),
    COMPACTION_CPU_TIME(3),
    SUBCOMPACTION_SETUP_TIME(4),
    TABLE_SYNC_MICROS(5),
    COMPACTION_OUTFILE_SYNC_MICROS(6),
    WAL_FILE_SYNC_MICROS(7),
    MANIFEST_FILE_SYNC_MICROS(8),
    TABLE_OPEN_IO_MICROS(9),
    DB_MULTIGET(10),
    READ_BLOCK_COMPACTION_MICROS(11),
    READ_BLOCK_GET_MICROS(12),
    WRITE_RAW_BLOCK_MICROS(13),
    NUM_FILES_IN_SINGLE_COMPACTION(14),
    DB_SEEK(15),
    WRITE_STALL(16),
    SST_READ_MICROS(17),
    FILE_READ_FLUSH_MICROS(18),
    FILE_READ_COMPACTION_MICROS(19),
    FILE_READ_DB_OPEN_MICROS(20),
    FILE_READ_GET_MICROS(21),
    FILE_READ_MULTIGET_MICROS(22),
    FILE_READ_DB_ITERATOR_MICROS(23),
    FILE_READ_VERIFY_DB_CHECKSUM_MICROS(24),
    FILE_READ_VERIFY_FILE_CHECKSUMS_MICROS(25),
    SST_WRITE_MICROS(26),
    FILE_WRITE_FLUSH_MICROS(27),
    FILE_WRITE_COMPACTION_MICROS(28),
    FILE_WRITE_DB_OPEN_MICROS(29),
    NUM_SUBCOMPACTIONS_SCHEDULED(30),
    BYTES_PER_READ(31),
    BYTES_PER_WRITE(32),
    BYTES_PER_MULTIGET(33),
    COMPRESSION_TIMES_NANOS(34),
    DECOMPRESSION_TIMES_NANOS(35),
    READ_NUM_MERGE_OPERANDS(36),
    BLOB_DB_KEY_SIZE(37),
    BLOB_DB_VALUE_SIZE(38),
    BLOB_DB_WRITE_MICROS(39),
    BLOB_DB_GET_MICROS(40),
    BLOB_DB_MULTIGET_MICROS(41),
    BLOB_DB_SEEK_MICROS(42),
    BLOB_DB_NEXT_MICROS(43),
    BLOB_DB_PREV_MICROS(44),
    BLOB_DB_BLOB_FILE_WRITE_MICROS(45),
    BLOB_DB_BLOB_FILE_READ_MICROS(46),
    BLOB_DB_BLOB_FILE_SYNC_MICROS(47),
    BLOB_DB_COMPRESSION_MICROS(48),
    BLOB_DB_DECOMPRESSION_MICROS(49),
    FLUSH_TIME(50),
    SST_BATCH_SIZE(51),
    MULTIGET_IO_BATCH_SIZE(52),
    NUM_INDEX_AND_FILTER_BLOCKS_READ_PER_LEVEL(53),
    NUM_SST_READ_PER_LEVEL(54),
    NUM_LEVEL_READ_PER_MULTIGET(55),
    ERROR_HANDLER_AUTORESUME_RETRY_COUNT(56),
    ASYNC_READ_BYTES(57),
    POLL_WAIT_MICROS(58),
    PREFETCHED_BYTES_DISCARDED(59),
    ASYNC_PREFETCH_ABORT_MICROS(60),
    TABLE_OPEN_PREFETCH_TAIL_READ_BYTES(61),
    HISTOGRAM_ENUM_MAX(62);

    private final byte value;

    private HistogramType(byte by) {
        this.value = by;
    }

    public byte getValue() {
        return this.value;
    }

    public static HistogramType getHistogramType(byte by) {
        for (HistogramType histogramType : HistogramType.values()) {
            if (histogramType.getValue() != by) continue;
            return histogramType;
        }
        throw new IllegalArgumentException("Illegal value provided for HistogramType.");
    }
}

