/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.main;

import com.headius.options.Option;
import java.io.InputStream;
import org.crac.CheckpointException;
import org.crac.Context;
import org.crac.Core;
import org.crac.Resource;
import org.crac.RestoreException;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.exceptions.RaiseException;
import org.jruby.main.PrebootMain;
import org.jruby.util.cli.Options;

public class CheckpointMain
extends PrebootMain {
    public static void main(String[] args2) {
        CheckpointMain.preboot(new CheckpointMain(), args2);
    }

    @Override
    protected String[] warmup(String[] args2) {
        Ruby ruby = Ruby.newInstance();
        ruby.evalScriptlet("1 + 1");
        Ruby.clearGlobalRuntime();
        return args2;
    }

    @Override
    protected RubyInstanceConfig prepareConfig(String[] args2) {
        RubyInstanceConfig config2 = super.prepareConfig(args2);
        if (args2.length > 0) {
            config2.processArguments(args2);
        }
        return config2;
    }

    @Override
    protected Ruby prepareRuntime(RubyInstanceConfig config2, String[] args2) {
        Ruby ruby = super.prepareRuntime(config2, args2);
        if (args2.length > 0) {
            InputStream in = config2.getScriptSource();
            String filename2 = config2.displayedFileName();
            try {
                if (in != null && !config2.getShouldCheckSyntax()) {
                    ruby.runFromMain(in, filename2);
                }
            }
            catch (RaiseException rj) {
                CheckpointMain.handleRaiseException(rj);
            }
        }
        return ruby;
    }

    @Override
    protected void endPreboot(RubyInstanceConfig config2, Ruby ruby, String[] args2) {
        super.endPreboot(config2, ruby, args2);
        try {
            Core.getGlobalContext().register(new JRubyContext());
            Core.checkpointRestore();
        }
        catch (CheckpointException | RestoreException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static class JRubyContext
    extends Context<Resource> {
        private JRubyContext() {
        }

        @Override
        public void beforeCheckpoint(Context<? extends Resource> context) throws CheckpointException {
        }

        @Override
        public void afterRestore(Context<? extends Resource> context) throws RestoreException {
            Options.PROPERTIES.forEach(Option::reload);
        }

        @Override
        public void register(Resource resource) {
        }
    }
}

