
package org.virtualbox_7_2.jaxws;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>Java class for TrackedObjectState.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <p>
 * <pre>
 * &lt;simpleType name="TrackedObjectState">
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     &lt;enumeration value="None"/>
 *     &lt;enumeration value="Alive"/>
 *     &lt;enumeration value="Deleted"/>
 *     &lt;enumeration value="Invalid"/>
 *   &lt;/restriction>
 * &lt;/simpleType>
 * </pre>
 * 
 */
@XmlType(name = "TrackedObjectState")
@XmlEnum
public enum TrackedObjectState {

    @XmlEnumValue("None")
    NONE("None"),
    @XmlEnumValue("Alive")
    ALIVE("Alive"),
    @XmlEnumValue("Deleted")
    DELETED("Deleted"),
    @XmlEnumValue("Invalid")
    INVALID("Invalid");
    private final String value;

    TrackedObjectState(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static TrackedObjectState fromValue(String v) {
        for (TrackedObjectState c: TrackedObjectState.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
