/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model;

import dev.langchain4j.model.StreamingResponseHandler;
import java.util.function.Consumer;

public class LambdaStreamingResponseHandler<T> {
    public static <T> StreamingResponseHandler<T> onNext(final Consumer<String> nextLambda) {
        return new StreamingResponseHandler<T>(){

            @Override
            public void onNext(String text) {
                nextLambda.accept(text);
            }

            @Override
            public void onError(Throwable error) {
                throw new RuntimeException(error);
            }
        };
    }

    public static <T> StreamingResponseHandler<T> onNextAndError(final Consumer<String> nextLambda, final Consumer<Throwable> errorLambda) {
        return new StreamingResponseHandler<T>(){

            @Override
            public void onNext(String text) {
                nextLambda.accept(text);
            }

            @Override
            public void onError(Throwable error) {
                errorLambda.accept(error);
            }
        };
    }
}

