/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.core.osgi;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import org.apache.camel.CamelContext;
import org.apache.camel.core.osgi.OsgiNamingHelper;
import org.apache.camel.impl.DefaultManagementNameStrategy;
import org.osgi.framework.BundleContext;

public class OsgiManagementNameStrategy
extends DefaultManagementNameStrategy {
    private static final AtomicInteger CONTEXT_COUNTER = new AtomicInteger(0);
    private final BundleContext bundleContext;

    public OsgiManagementNameStrategy(CamelContext camelContext, BundleContext bundleContext) {
        super(camelContext, "#symbolicName#-#name#", "#symbolicName#-#name#-#counter#");
        this.bundleContext = bundleContext;
    }

    protected String customResolveManagementName(String pattern, String answer) {
        String bundleId = "" + this.bundleContext.getBundle().getBundleId();
        String symbolicName = this.bundleContext.getBundle().getSymbolicName();
        symbolicName = symbolicName != null ? Matcher.quoteReplacement(symbolicName) : "";
        String version = Matcher.quoteReplacement(this.bundleContext.getBundle().getVersion().toString());
        answer = answer.replaceFirst("#bundleId#", bundleId);
        answer = answer.replaceFirst("#symbolicName#", symbolicName);
        answer = answer.replaceFirst("#version#", version);
        answer = OsgiNamingHelper.findFreeCamelContextName(this.bundleContext, answer, "camel.context.managementname", CONTEXT_COUNTER, true);
        return answer;
    }
}

