/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.kar.internal.osgi;

import java.util.Hashtable;
import org.apache.karaf.cellar.core.ClusterManager;
import org.apache.karaf.cellar.core.GroupManager;
import org.apache.karaf.cellar.core.event.EventHandler;
import org.apache.karaf.cellar.core.event.EventProducer;
import org.apache.karaf.cellar.kar.KarEventHandler;
import org.apache.karaf.kar.KarService;
import org.apache.karaf.util.tracker.BaseActivator;
import org.apache.karaf.util.tracker.annotation.ProvideService;
import org.apache.karaf.util.tracker.annotation.RequireService;
import org.apache.karaf.util.tracker.annotation.Services;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Services(provides={@ProvideService(value=EventHandler.class)}, requires={@RequireService(value=ClusterManager.class), @RequireService(value=GroupManager.class), @RequireService(value=EventProducer.class), @RequireService(value=ConfigurationAdmin.class), @RequireService(value=KarService.class)})
public class Activator
extends BaseActivator {
    private static final Logger LOGGER = LoggerFactory.getLogger(Activator.class);
    private KarEventHandler karEventHandler;

    @Override
    public void doStart() throws Exception {
        ConfigurationAdmin configurationAdmin = this.getTrackedService(ConfigurationAdmin.class);
        if (configurationAdmin == null) {
            return;
        }
        ClusterManager clusterManager = this.getTrackedService(ClusterManager.class);
        if (clusterManager == null) {
            return;
        }
        GroupManager groupManager = this.getTrackedService(GroupManager.class);
        if (groupManager == null) {
            return;
        }
        EventProducer eventProducer = this.getTrackedService(EventProducer.class);
        if (eventProducer == null) {
            return;
        }
        KarService karService = this.getTrackedService(KarService.class);
        if (karService == null) {
            return;
        }
        LOGGER.debug("CELLAR KAR: init event handler");
        this.karEventHandler = new KarEventHandler();
        this.karEventHandler.setConfigurationAdmin(configurationAdmin);
        this.karEventHandler.setClusterManager(clusterManager);
        this.karEventHandler.setGroupManager(groupManager);
        this.karEventHandler.setKarService(karService);
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("managed", "true");
        this.register(new Class[]{EventHandler.class}, (Object)this.karEventHandler, props);
    }
}

