/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph;

import io.github.classgraph.AnnotationInfo;
import io.github.classgraph.AnnotationInfoList;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ClasspathElement;
import io.github.classgraph.HasName;
import io.github.classgraph.ModuleRef;
import io.github.classgraph.PackageInfo;
import io.github.classgraph.PackageInfoList;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public class ModuleInfo
implements Comparable<ModuleInfo>,
HasName {
    private String name;
    private String locationURIStr;
    private transient ModuleRef moduleRef;
    private AnnotationInfoList annotationInfo;
    private LinkedHashSet<PackageInfo> packageInfoSet;
    private final Set<ClassInfo> classInfoSet = new HashSet<ClassInfo>();

    ModuleInfo() {
    }

    ModuleInfo(ModuleRef moduleRef, ClasspathElement classpathElement) {
        this.moduleRef = moduleRef;
        this.name = classpathElement.moduleName;
        URI locationURI = moduleRef != null ? moduleRef.getLocation() : classpathElement.getURI();
        this.locationURIStr = locationURI == null ? null : locationURI.toASCIIString();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public URI getLocation() {
        try {
            return this.locationURIStr == null ? null : new URI(this.locationURIStr);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public ModuleRef getModuleRef() {
        return this.moduleRef;
    }

    void addClassInfo(ClassInfo classInfo) {
        this.classInfoSet.add(classInfo);
    }

    public ClassInfo getClassInfo(String className) {
        if (this.classInfoSet == null) {
            return null;
        }
        for (ClassInfo ci : this.classInfoSet) {
            if (!ci.getName().equals(className)) continue;
            return ci;
        }
        return null;
    }

    public ClassInfoList getClassInfo() {
        return new ClassInfoList(this.classInfoSet, true);
    }

    void addPackageInfo(PackageInfo packageInfo) {
        if (this.packageInfoSet == null) {
            this.packageInfoSet = new LinkedHashSet();
        }
        this.packageInfoSet.add(packageInfo);
    }

    public PackageInfo getPackageInfo(String packageName) {
        if (this.packageInfoSet == null) {
            return null;
        }
        for (PackageInfo pi : this.packageInfoSet) {
            if (!pi.getName().equals(packageName)) continue;
            return pi;
        }
        return null;
    }

    public PackageInfoList getPackageInfo() {
        if (this.packageInfoSet == null) {
            return new PackageInfoList(1);
        }
        PackageInfoList packageInfoList = new PackageInfoList((Collection<PackageInfo>)this.packageInfoSet);
        Collections.sort(packageInfoList);
        return packageInfoList;
    }

    void addAnnotations(AnnotationInfoList moduleAnnotations) {
        if (moduleAnnotations != null && !moduleAnnotations.isEmpty()) {
            if (this.annotationInfo == null) {
                this.annotationInfo = new AnnotationInfoList(moduleAnnotations);
            } else {
                this.annotationInfo.addAll(moduleAnnotations);
            }
        }
    }

    public AnnotationInfo getAnnotationInfo(String annotationName) {
        return (AnnotationInfo)this.getAnnotationInfo().get(annotationName);
    }

    public AnnotationInfoList getAnnotationInfo() {
        return this.annotationInfo == null ? AnnotationInfoList.EMPTY_LIST : this.annotationInfo;
    }

    public boolean hasAnnotation(String annotationName) {
        return this.getAnnotationInfo().containsName(annotationName);
    }

    @Override
    public int compareTo(ModuleInfo o) {
        int diff = this.name.compareTo(o.name);
        if (diff != 0) {
            return diff;
        }
        if (this.locationURIStr != null && o.locationURIStr != null) {
            return this.locationURIStr.compareTo(o.locationURIStr);
        }
        return (o.locationURIStr == null ? 0 : 1) - (this.locationURIStr == null ? 0 : 1);
    }

    public int hashCode() {
        return this.name.hashCode() * (this.locationURIStr == null ? 1 : this.locationURIStr.hashCode());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModuleInfo)) {
            return false;
        }
        return this.compareTo((ModuleInfo)o) == 0;
    }

    public String toString() {
        return this.name + " [" + (this.locationURIStr == null ? "" : this.locationURIStr) + "]";
    }
}

