/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.internal;

import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Objects;
import javax.money.MonetaryAmount;
import javax.money.MonetaryAmountFactory;
import javax.money.MonetaryAmountFactoryQuery;
import javax.money.MonetaryContext;
import javax.money.MonetaryContextBuilder;
import javax.money.MonetaryException;
import javax.money.spi.Bootstrap;
import javax.money.spi.MonetaryAmountFactoryProviderSpi;
import javax.money.spi.MonetaryAmountsSingletonQuerySpi;

public class DefaultMonetaryAmountsSingletonQuerySpi
implements MonetaryAmountsSingletonQuerySpi {
    private static final Comparator<MonetaryAmountFactoryProviderSpi<? extends MonetaryAmount>> CONTEXT_COMPARATOR = (f1, f2) -> {
        int compare = 0;
        MonetaryContext c1 = f1.getMaximalMonetaryContext();
        MonetaryContext c2 = f2.getMaximalMonetaryContext();
        if (c1.getPrecision() == 0 && c2.getPrecision() != 0) {
            compare = -1;
        }
        if (compare == 0 && c2.getPrecision() == 0 && c1.getPrecision() != 0) {
            compare = 1;
        }
        if (compare == 0 && c1.getPrecision() != 0 && c2.getPrecision() > c1.getPrecision()) {
            compare = 1;
        }
        if (compare == 0 && c2.getPrecision() != 0 && c2.getPrecision() < c1.getPrecision()) {
            compare = -1;
        }
        if (compare == 0 && c1.getMaxScale() > c2.getMaxScale()) {
            compare = -1;
        }
        if (compare == 0 && c1.getMaxScale() < c2.getMaxScale()) {
            compare = 1;
        }
        return compare;
    };

    public Collection<MonetaryAmountFactory<?>> getAmountFactories(MonetaryAmountFactoryQuery factoryQuery) {
        Objects.requireNonNull(factoryQuery);
        ArrayList factories = new ArrayList();
        for (Object factory : Bootstrap.getServices(MonetaryAmountFactoryProviderSpi.class)) {
            if (factory.getQueryInclusionPolicy() == MonetaryAmountFactoryProviderSpi.QueryInclusionPolicy.NEVER || factoryQuery.getTargetType() != factory.getAmountType()) continue;
            if (this.isPrecisionOK(factoryQuery, factory.getMaximalMonetaryContext())) {
                factories.add(factory.createMonetaryAmountFactory());
                continue;
            }
            throw new MonetaryException("Incompatible context required=" + factoryQuery + ", maximal=" + factory.getMaximalMonetaryContext());
        }
        ArrayList<MonetaryAmountFactoryProviderSpi> selection = new ArrayList<MonetaryAmountFactoryProviderSpi>();
        for (MonetaryAmountFactoryProviderSpi factory : Bootstrap.getServices(MonetaryAmountFactoryProviderSpi.class)) {
            if (factory.getQueryInclusionPolicy() == MonetaryAmountFactoryProviderSpi.QueryInclusionPolicy.DIRECT_REFERENCE_ONLY || factory.getQueryInclusionPolicy() == MonetaryAmountFactoryProviderSpi.QueryInclusionPolicy.NEVER || !this.isPrecisionOK(factoryQuery, factory.getMaximalMonetaryContext())) continue;
            selection.add(factory);
        }
        if (selection.isEmpty()) {
            for (MonetaryAmountFactoryProviderSpi factory : Bootstrap.getServices(MonetaryAmountFactoryProviderSpi.class)) {
                if (factory.getQueryInclusionPolicy() == MonetaryAmountFactoryProviderSpi.QueryInclusionPolicy.DIRECT_REFERENCE_ONLY || factory.getQueryInclusionPolicy() == MonetaryAmountFactoryProviderSpi.QueryInclusionPolicy.NEVER || !this.isPrecisionOK(factoryQuery, factory.getMaximalMonetaryContext())) continue;
                selection.add(factory);
            }
        }
        if (selection.size() == 1) {
            factories.add(((MonetaryAmountFactoryProviderSpi)selection.get(0)).createMonetaryAmountFactory());
        }
        MonetaryContext context = this.createContext(factoryQuery);
        factories.forEach(f -> f.setContext(context));
        Collections.sort(selection, CONTEXT_COMPARATOR);
        factories.add(((MonetaryAmountFactoryProviderSpi)selection.get(0)).createMonetaryAmountFactory());
        return factories;
    }

    private MonetaryContext createContext(MonetaryAmountFactoryQuery factoryQuery) {
        MonetaryContextBuilder contextBuilder = MonetaryContextBuilder.of();
        if (Objects.nonNull(factoryQuery.getPrecision())) {
            contextBuilder.setPrecision(factoryQuery.getPrecision().intValue());
        }
        if (Objects.nonNull(factoryQuery.get(RoundingMode.class))) {
            contextBuilder.set(factoryQuery.get(RoundingMode.class));
        }
        return contextBuilder.build();
    }

    private boolean isPrecisionOK(MonetaryAmountFactoryQuery requiredContext, MonetaryContext maxMonetaryContext) {
        if (maxMonetaryContext.getPrecision() == 0) {
            return true;
        }
        if (requiredContext.getPrecision() != null) {
            if (requiredContext.getPrecision() == 0) {
                return false;
            }
            if (requiredContext.getPrecision() > maxMonetaryContext.getPrecision()) {
                return false;
            }
        }
        return null == requiredContext.getMaxScale() || requiredContext.getMaxScale() <= maxMonetaryContext.getMaxScale();
    }
}

