/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.shell.migration.utils;

import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.karaf.shell.api.console.Session;
import org.apache.unomi.shell.migration.utils.HttpUtils;
import org.jline.reader.LineReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsoleUtils {
    private static final Logger logger = LoggerFactory.getLogger(HttpUtils.class);

    public static String askUserWithDefaultAnswer(Session session, String msg, String defaultAnswer) throws IOException {
        String answer = ConsoleUtils.promptMessageToUser(session, msg);
        if (StringUtils.isBlank((CharSequence)answer)) {
            return defaultAnswer;
        }
        return answer;
    }

    public static String askUserWithAuthorizedAnswer(Session session, String msg, List<String> authorizedAnswer) throws IOException {
        String answer;
        while (!authorizedAnswer.contains((answer = ConsoleUtils.promptMessageToUser(session, msg)).toLowerCase())) {
        }
        return answer;
    }

    public static String promptMessageToUser(Session session, String msg) throws IOException {
        LineReader reader = (LineReader)session.get(".jline.reader");
        return reader.readLine(msg, null);
    }

    public static void printMessage(Session session, String msg) {
        PrintStream writer = session.getConsole();
        writer.println(msg);
    }

    public static void printException(Session session, String msg, Throwable t) {
        PrintStream writer = session.getConsole();
        writer.println(msg);
        t.printStackTrace(writer);
    }
}

