/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.services.impl.segments;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.apache.unomi.api.Event;
import org.apache.unomi.api.Item;
import org.apache.unomi.api.Metadata;
import org.apache.unomi.api.PartialList;
import org.apache.unomi.api.Profile;
import org.apache.unomi.api.actions.Action;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.api.conditions.ConditionType;
import org.apache.unomi.api.query.Query;
import org.apache.unomi.api.rules.Rule;
import org.apache.unomi.api.segments.DependentMetadata;
import org.apache.unomi.api.segments.Scoring;
import org.apache.unomi.api.segments.ScoringElement;
import org.apache.unomi.api.segments.Segment;
import org.apache.unomi.api.segments.SegmentsAndScores;
import org.apache.unomi.api.services.EventService;
import org.apache.unomi.api.services.RulesService;
import org.apache.unomi.api.services.SchedulerService;
import org.apache.unomi.api.services.SegmentService;
import org.apache.unomi.persistence.spi.CustomObjectMapper;
import org.apache.unomi.persistence.spi.aggregate.BaseAggregate;
import org.apache.unomi.persistence.spi.aggregate.TermsAggregate;
import org.apache.unomi.services.impl.AbstractServiceImpl;
import org.apache.unomi.services.impl.ParserHelper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentServiceImpl
extends AbstractServiceImpl
implements SegmentService,
SynchronousBundleListener {
    private static final Logger logger = LoggerFactory.getLogger((String)SegmentServiceImpl.class.getName());
    private BundleContext bundleContext;
    private EventService eventService;
    private RulesService rulesService;
    private SchedulerService schedulerService;
    private long taskExecutionPeriod = 1L;
    private List<Segment> allSegments;
    private List<Scoring> allScoring;
    private int segmentUpdateBatchSize = 1000;
    private long segmentRefreshInterval = 1000L;
    private int aggregateQueryBucketSize = 5000;
    private int maximumIdsQueryCount = 5000;
    private boolean pastEventsDisablePartitions = false;

    public SegmentServiceImpl() {
        logger.info("Initializing segment service...");
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void setEventService(EventService eventService) {
        this.eventService = eventService;
    }

    public void setRulesService(RulesService rulesService) {
        this.rulesService = rulesService;
    }

    public void setSchedulerService(SchedulerService schedulerService) {
        this.schedulerService = schedulerService;
    }

    public void setSegmentUpdateBatchSize(int segmentUpdateBatchSize) {
        this.segmentUpdateBatchSize = segmentUpdateBatchSize;
    }

    public void setAggregateQueryBucketSize(int aggregateQueryBucketSize) {
        this.aggregateQueryBucketSize = aggregateQueryBucketSize;
    }

    public void setMaximumIdsQueryCount(int maximumIdsQueryCount) {
        this.maximumIdsQueryCount = maximumIdsQueryCount;
    }

    public void setPastEventsDisablePartitions(boolean pastEventsDisablePartitions) {
        this.pastEventsDisablePartitions = pastEventsDisablePartitions;
    }

    public void setSegmentRefreshInterval(long segmentRefreshInterval) {
        this.segmentRefreshInterval = segmentRefreshInterval;
    }

    public void postConstruct() {
        logger.debug("postConstruct {" + this.bundleContext.getBundle() + "}");
        this.loadPredefinedSegments(this.bundleContext);
        this.loadPredefinedScorings(this.bundleContext);
        for (Bundle bundle : this.bundleContext.getBundles()) {
            if (bundle.getBundleContext() == null || bundle.getBundleId() == this.bundleContext.getBundle().getBundleId()) continue;
            this.loadPredefinedSegments(bundle.getBundleContext());
            this.loadPredefinedScorings(bundle.getBundleContext());
        }
        this.bundleContext.addBundleListener((BundleListener)this);
        this.initializeTimer();
        logger.info("Segment service initialized.");
    }

    public void preDestroy() {
        this.bundleContext.removeBundleListener((BundleListener)this);
        logger.info("Segment service shutdown.");
    }

    private void processBundleStartup(BundleContext bundleContext) {
        if (bundleContext == null) {
            return;
        }
        this.loadPredefinedSegments(bundleContext);
        this.loadPredefinedScorings(bundleContext);
    }

    private void processBundleStop(BundleContext bundleContext) {
        if (bundleContext == null) {
            return;
        }
    }

    private void loadPredefinedSegments(BundleContext bundleContext) {
        Enumeration predefinedSegmentEntries = bundleContext.getBundle().findEntries("META-INF/cxs/segments", "*.json", true);
        if (predefinedSegmentEntries == null) {
            return;
        }
        while (predefinedSegmentEntries.hasMoreElements()) {
            URL predefinedSegmentURL = (URL)predefinedSegmentEntries.nextElement();
            logger.debug("Found predefined segment at " + predefinedSegmentURL + ", loading... ");
            try {
                Segment segment = (Segment)CustomObjectMapper.getObjectMapper().readValue(predefinedSegmentURL, Segment.class);
                if (segment.getMetadata().getScope() == null) {
                    segment.getMetadata().setScope("systemscope");
                }
                if (this.getSegmentDefinition(segment.getMetadata().getId()) == null) {
                    this.setSegmentDefinition(segment);
                    logger.info("Predefined segment with id {} registered", (Object)segment.getMetadata().getId());
                    continue;
                }
                logger.info("The predefined segment with id {} is already registered, this segment will be skipped", (Object)segment.getMetadata().getId());
            }
            catch (IOException e) {
                logger.error("Error while loading segment definition " + predefinedSegmentURL, (Throwable)e);
            }
        }
    }

    private void loadPredefinedScorings(BundleContext bundleContext) {
        Enumeration predefinedScoringEntries = bundleContext.getBundle().findEntries("META-INF/cxs/scoring", "*.json", true);
        if (predefinedScoringEntries == null) {
            return;
        }
        while (predefinedScoringEntries.hasMoreElements()) {
            URL predefinedScoringURL = (URL)predefinedScoringEntries.nextElement();
            logger.debug("Found predefined scoring at " + predefinedScoringURL + ", loading... ");
            try {
                Scoring scoring = (Scoring)CustomObjectMapper.getObjectMapper().readValue(predefinedScoringURL, Scoring.class);
                if (scoring.getMetadata().getScope() == null) {
                    scoring.getMetadata().setScope("systemscope");
                }
                if (this.getScoringDefinition(scoring.getMetadata().getId()) == null) {
                    this.setScoringDefinition(scoring);
                    logger.info("Predefined scoring with id {} registered", (Object)scoring.getMetadata().getId());
                    continue;
                }
                logger.info("The predefined scoring with id {} is already registered, this scoring will be skipped", (Object)scoring.getMetadata().getId());
            }
            catch (IOException e) {
                logger.error("Error while loading segment definition " + predefinedScoringURL, (Throwable)e);
            }
        }
    }

    public PartialList<Metadata> getSegmentMetadatas(int offset, int size, String sortBy) {
        return this.getMetadatas(offset, size, sortBy, Segment.class);
    }

    public PartialList<Metadata> getSegmentMetadatas(String scope, int offset, int size, String sortBy) {
        PartialList segments = this.persistenceService.query("metadata.scope", scope, sortBy, Segment.class, offset, size);
        LinkedList<Metadata> details = new LinkedList<Metadata>();
        for (Segment definition : segments.getList()) {
            details.add(definition.getMetadata());
        }
        return new PartialList(details, segments.getOffset(), segments.getPageSize(), segments.getTotalSize(), segments.getTotalSizeRelation());
    }

    public PartialList<Metadata> getSegmentMetadatas(Query query) {
        return this.getMetadatas(query, Segment.class);
    }

    private List<Segment> getAllSegmentDefinitions() {
        List allItems = this.persistenceService.getAllItems(Segment.class);
        for (Segment segment : allItems) {
            ParserHelper.resolveConditionType(this.definitionsService, segment.getCondition());
        }
        return allItems;
    }

    public Segment getSegmentDefinition(String segmentId) {
        Segment definition = (Segment)this.persistenceService.load(segmentId, Segment.class);
        if (definition != null) {
            ParserHelper.resolveConditionType(this.definitionsService, definition.getCondition());
        }
        return definition;
    }

    public void setSegmentDefinition(Segment segment) {
        ParserHelper.resolveConditionType(this.definitionsService, segment.getCondition());
        if (segment.getMetadata().isEnabled() && !segment.getMetadata().isMissingPlugins()) {
            this.updateAutoGeneratedRules(segment.getMetadata(), segment.getCondition());
        }
        this.persistenceService.save((Item)segment);
        this.updateExistingProfilesForSegment(segment);
    }

    private boolean checkSegmentDeletionImpact(Condition condition, String segmentToDeleteId) {
        if (condition != null) {
            List referencedSegmentIds;
            List subConditions = (List)condition.getParameter("subConditions");
            if (subConditions != null) {
                for (Condition subCondition : subConditions) {
                    if (!this.checkSegmentDeletionImpact(subCondition, segmentToDeleteId)) continue;
                    return true;
                }
            } else if ("profileSegmentCondition".equals(condition.getConditionTypeId()) && (referencedSegmentIds = (List)condition.getParameter("segments")).indexOf(segmentToDeleteId) >= 0) {
                return true;
            }
        }
        return false;
    }

    private Condition updateSegmentDependentCondition(Condition condition, String segmentId) {
        List referencedSegmentIds;
        if ("booleanCondition".equals(condition.getConditionTypeId())) {
            List subConditions = (List)condition.getParameter("subConditions");
            LinkedList<Condition> updatedSubConditions = new LinkedList<Condition>();
            for (Condition subCondition : subConditions) {
                Condition updatedCondition = this.updateSegmentDependentCondition(subCondition, segmentId);
                if (updatedCondition == null) continue;
                updatedSubConditions.add(updatedCondition);
            }
            if (!updatedSubConditions.isEmpty()) {
                if (updatedSubConditions.size() == 1) {
                    return (Condition)updatedSubConditions.get(0);
                }
                condition.setParameter("subConditions", updatedSubConditions);
                return condition;
            }
            return null;
        }
        if ("profileSegmentCondition".equals(condition.getConditionTypeId()) && (referencedSegmentIds = (List)condition.getParameter("segments")).indexOf(segmentId) >= 0) {
            referencedSegmentIds.remove(segmentId);
            if (referencedSegmentIds.isEmpty()) {
                return null;
            }
            condition.setParameter("segments", (Object)referencedSegmentIds);
        }
        return condition;
    }

    private Set<Segment> getSegmentDependentSegments(String segmentId) {
        HashSet<Segment> impactedSegments = new HashSet<Segment>(this.allSegments.size());
        for (Segment segment : this.allSegments) {
            if (!this.checkSegmentDeletionImpact(segment.getCondition(), segmentId)) continue;
            impactedSegments.add(segment);
        }
        return impactedSegments;
    }

    private Set<Scoring> getSegmentDependentScorings(String segmentId) {
        HashSet<Scoring> impactedScoring = new HashSet<Scoring>(this.allScoring.size());
        block0: for (Scoring scoring : this.allScoring) {
            for (ScoringElement element : scoring.getElements()) {
                if (!this.checkSegmentDeletionImpact(element.getCondition(), segmentId)) continue;
                impactedScoring.add(scoring);
                continue block0;
            }
        }
        return impactedScoring;
    }

    public DependentMetadata getSegmentDependentMetadata(String segmentId) {
        LinkedList<Metadata> segments = new LinkedList<Metadata>();
        LinkedList<Metadata> scorings = new LinkedList<Metadata>();
        for (Segment segment : this.getSegmentDependentSegments(segmentId)) {
            segments.add(segment.getMetadata());
        }
        for (Scoring scoring : this.getSegmentDependentScorings(segmentId)) {
            scorings.add(scoring.getMetadata());
        }
        return new DependentMetadata(segments, scorings);
    }

    public DependentMetadata removeSegmentDefinition(String segmentId, boolean validate) {
        Set<Segment> impactedSegments = this.getSegmentDependentSegments(segmentId);
        Set<Scoring> impactedScorings = this.getSegmentDependentScorings(segmentId);
        if (!validate || impactedSegments.isEmpty() && impactedScorings.isEmpty()) {
            Condition segmentCondition = new Condition();
            segmentCondition.setConditionType(this.definitionsService.getConditionType("profilePropertyCondition"));
            segmentCondition.setParameter("propertyName", (Object)"segments");
            segmentCondition.setParameter("comparisonOperator", (Object)"equals");
            segmentCondition.setParameter("propertyValue", (Object)segmentId);
            List previousProfiles = this.persistenceService.query(segmentCondition, null, Profile.class);
            long updatedProfileCount = 0L;
            long profileRemovalStartTime = System.currentTimeMillis();
            for (Profile profileToRemove : previousProfiles) {
                profileToRemove.getSegments().remove(segmentId);
                HashMap<String, Object> sourceMap = new HashMap<String, Object>();
                sourceMap.put("segments", profileToRemove.getSegments());
                profileToRemove.setSystemProperty("lastUpdated", (Object)new Date());
                sourceMap.put("systemProperties", profileToRemove.getSystemProperties());
                this.persistenceService.update(profileToRemove.getItemId(), null, Profile.class, sourceMap);
                ++updatedProfileCount;
            }
            logger.info("Removed segment from {} profiles in {} ms", (Object)updatedProfileCount, (Object)(System.currentTimeMillis() - profileRemovalStartTime));
            for (Segment segment : impactedSegments) {
                Condition updatedCondition = this.updateSegmentDependentCondition(segment.getCondition(), segmentId);
                segment.setCondition(updatedCondition);
                if (updatedCondition == null) {
                    this.clearAutoGeneratedRules(this.persistenceService.query("linkedItems", segment.getMetadata().getId(), null, Rule.class), segment.getMetadata().getId());
                    segment.getMetadata().setEnabled(false);
                }
                this.setSegmentDefinition(segment);
            }
            for (Scoring scoring : impactedScorings) {
                ArrayList<ScoringElement> updatedScoringElements = new ArrayList<ScoringElement>();
                for (ScoringElement scoringElement : scoring.getElements()) {
                    Condition updatedCondition = this.updateSegmentDependentCondition(scoringElement.getCondition(), segmentId);
                    if (updatedCondition == null) continue;
                    scoringElement.setCondition(updatedCondition);
                    updatedScoringElements.add(scoringElement);
                }
                scoring.setElements(updatedScoringElements);
                if (updatedScoringElements.isEmpty()) {
                    this.clearAutoGeneratedRules(this.persistenceService.query("linkedItems", scoring.getMetadata().getId(), null, Rule.class), scoring.getMetadata().getId());
                    scoring.getMetadata().setEnabled(false);
                }
                this.setScoringDefinition(scoring);
            }
            this.persistenceService.remove(segmentId, Segment.class);
            List previousRules = this.persistenceService.query("linkedItems", segmentId, null, Rule.class);
            this.clearAutoGeneratedRules(previousRules, segmentId);
        }
        LinkedList<Metadata> segments = new LinkedList<Metadata>();
        LinkedList<Metadata> scorings = new LinkedList<Metadata>();
        for (Segment segment : impactedSegments) {
            segments.add(segment.getMetadata());
        }
        for (Scoring scoring : impactedScorings) {
            scorings.add(scoring.getMetadata());
        }
        return new DependentMetadata(segments, scorings);
    }

    public PartialList<Profile> getMatchingIndividuals(String segmentID, int offset, int size, String sortBy) {
        Segment segment = this.getSegmentDefinition(segmentID);
        if (segment == null) {
            return new PartialList();
        }
        Condition segmentCondition = new Condition(this.definitionsService.getConditionType("profilePropertyCondition"));
        segmentCondition.setParameter("propertyName", (Object)"segments");
        segmentCondition.setParameter("comparisonOperator", (Object)"equals");
        segmentCondition.setParameter("propertyValue", (Object)segmentID);
        return this.persistenceService.query(segmentCondition, sortBy, Profile.class, offset, size);
    }

    public long getMatchingIndividualsCount(String segmentID) {
        if (this.getSegmentDefinition(segmentID) == null) {
            return 0L;
        }
        Condition segmentCondition = new Condition(this.definitionsService.getConditionType("profilePropertyCondition"));
        segmentCondition.setParameter("propertyName", (Object)"segments");
        segmentCondition.setParameter("comparisonOperator", (Object)"equals");
        segmentCondition.setParameter("propertyValue", (Object)segmentID);
        return this.persistenceService.queryCount(segmentCondition, "profile");
    }

    public Boolean isProfileInSegment(Profile profile, String segmentId) {
        Set matchingSegments = this.getSegmentsAndScoresForProfile(profile).getSegments();
        return matchingSegments.contains(segmentId);
    }

    public SegmentsAndScores getSegmentsAndScoresForProfile(Profile profile) {
        HashSet<String> segments = new HashSet<String>();
        HashMap<String, Integer> scores = new HashMap<String, Integer>();
        List<Segment> allSegments = this.allSegments;
        for (Segment segment : allSegments) {
            if (!segment.getMetadata().isEnabled() || !this.persistenceService.testMatch(segment.getCondition(), (Item)profile)) continue;
            segments.add(segment.getMetadata().getId());
        }
        List<Scoring> allScoring = this.allScoring;
        Map scoreModifiers = (Map)profile.getSystemProperties().get("scoreModifiers");
        for (Scoring scoring : allScoring) {
            if (!scoring.getMetadata().isEnabled()) continue;
            int score = 0;
            for (ScoringElement scoringElement : scoring.getElements()) {
                if (!this.persistenceService.testMatch(scoringElement.getCondition(), (Item)profile)) continue;
                score += scoringElement.getValue();
            }
            String scoringId = scoring.getMetadata().getId();
            if (scoreModifiers != null && scoreModifiers.containsKey(scoringId) && scoreModifiers.get(scoringId) != null) {
                score += ((Integer)scoreModifiers.get(scoringId)).intValue();
            }
            scores.put(scoringId, score);
        }
        return new SegmentsAndScores(segments, scores);
    }

    public List<Metadata> getSegmentMetadatasForProfile(Profile profile) {
        ArrayList<Metadata> metadatas = new ArrayList<Metadata>();
        List<Segment> allSegments = this.allSegments;
        for (Segment segment : allSegments) {
            if (!this.persistenceService.testMatch(segment.getCondition(), (Item)profile)) continue;
            metadatas.add(segment.getMetadata());
        }
        return metadatas;
    }

    public PartialList<Metadata> getScoringMetadatas(int offset, int size, String sortBy) {
        return this.getMetadatas(offset, size, sortBy, Scoring.class);
    }

    public PartialList<Metadata> getScoringMetadatas(Query query) {
        return this.getMetadatas(query, Scoring.class);
    }

    private List<Scoring> getAllScoringDefinitions() {
        List allItems = this.persistenceService.getAllItems(Scoring.class);
        for (Scoring scoring : allItems) {
            for (ScoringElement element : scoring.getElements()) {
                ParserHelper.resolveConditionType(this.definitionsService, element.getCondition());
            }
        }
        return allItems;
    }

    public Scoring getScoringDefinition(String scoringId) {
        Scoring definition = (Scoring)this.persistenceService.load(scoringId, Scoring.class);
        if (definition != null) {
            for (ScoringElement element : definition.getElements()) {
                ParserHelper.resolveConditionType(this.definitionsService, element.getCondition());
            }
        }
        return definition;
    }

    public void setScoringDefinition(Scoring scoring) {
        for (ScoringElement element : scoring.getElements()) {
            ParserHelper.resolveConditionType(this.definitionsService, element.getCondition());
        }
        for (ScoringElement element : scoring.getElements()) {
            if (!scoring.getMetadata().isEnabled() || scoring.getMetadata().isMissingPlugins()) continue;
            this.updateAutoGeneratedRules(scoring.getMetadata(), element.getCondition());
        }
        this.persistenceService.save((Item)scoring);
        this.persistenceService.createMapping("profile", String.format("{\n  \"properties\": {\n    \"scores\": {\n      \"properties\": {\n        \"%s\": {\n          \"type\":\"long\"\n        }\n      }\n    }\n  }\n}", scoring.getItemId()));
        this.updateExistingProfilesForScoring(scoring);
    }

    public void createScoringDefinition(String scope, String scoringId, String name, String description) {
        Metadata metadata = new Metadata(scope, scoringId, name, description);
        Scoring scoring = new Scoring(metadata);
        Condition rootCondition = new Condition();
        rootCondition.setConditionType(this.definitionsService.getConditionType("booleanCondition"));
        rootCondition.setParameter("operator", (Object)"and");
        rootCondition.setParameter("subConditions", new ArrayList());
        scoring.setElements(new ArrayList());
        this.setScoringDefinition(scoring);
    }

    private boolean checkScoringDeletionImpact(Condition condition, String scoringToDeleteId) {
        if (condition != null) {
            List subConditions = (List)condition.getParameter("subConditions");
            if (subConditions != null) {
                for (Condition subCondition : subConditions) {
                    if (!this.checkScoringDeletionImpact(subCondition, scoringToDeleteId)) continue;
                    return true;
                }
            } else if ("scoringCondition".equals(condition.getConditionTypeId()) && scoringToDeleteId.equals(condition.getParameter("scoringPlanId"))) {
                return true;
            }
        }
        return false;
    }

    private Condition updateScoringDependentCondition(Condition condition, String scoringId) {
        if ("booleanCondition".equals(condition.getConditionTypeId())) {
            List subConditions = (List)condition.getParameter("subConditions");
            LinkedList<Condition> updatedSubConditions = new LinkedList<Condition>();
            for (Condition subCondition : subConditions) {
                Condition updatedCondition = this.updateScoringDependentCondition(subCondition, scoringId);
                if (updatedCondition == null) continue;
                updatedSubConditions.add(updatedCondition);
            }
            if (!updatedSubConditions.isEmpty()) {
                if (updatedSubConditions.size() == 1) {
                    return (Condition)updatedSubConditions.get(0);
                }
                condition.setParameter("subConditions", updatedSubConditions);
                return condition;
            }
            return null;
        }
        if ("scoringCondition".equals(condition.getConditionTypeId()) && scoringId.equals(condition.getParameter("scoringPlanId"))) {
            return null;
        }
        return condition;
    }

    private Set<Segment> getScoringDependentSegments(String scoringId) {
        HashSet<Segment> impactedSegments = new HashSet<Segment>(this.allSegments.size());
        for (Segment segment : this.allSegments) {
            if (!this.checkScoringDeletionImpact(segment.getCondition(), scoringId)) continue;
            impactedSegments.add(segment);
        }
        return impactedSegments;
    }

    private Set<Scoring> getScoringDependentScorings(String scoringId) {
        HashSet<Scoring> impactedScoring = new HashSet<Scoring>(this.allScoring.size());
        block0: for (Scoring scoring : this.allScoring) {
            for (ScoringElement element : scoring.getElements()) {
                if (!this.checkScoringDeletionImpact(element.getCondition(), scoringId)) continue;
                impactedScoring.add(scoring);
                continue block0;
            }
        }
        return impactedScoring;
    }

    public DependentMetadata getScoringDependentMetadata(String scoringId) {
        LinkedList<Metadata> segments = new LinkedList<Metadata>();
        LinkedList<Metadata> scorings = new LinkedList<Metadata>();
        for (Segment segment : this.getScoringDependentSegments(scoringId)) {
            segments.add(segment.getMetadata());
        }
        for (Scoring scoring : this.getScoringDependentScorings(scoringId)) {
            scorings.add(scoring.getMetadata());
        }
        return new DependentMetadata(segments, scorings);
    }

    public DependentMetadata removeScoringDefinition(String scoringId, boolean validate) {
        Set<Segment> impactedSegments = this.getScoringDependentSegments(scoringId);
        Set<Scoring> impactedScorings = this.getScoringDependentScorings(scoringId);
        if (!validate || impactedSegments.isEmpty() && impactedScorings.isEmpty()) {
            this.updateExistingProfilesForRemovedScoring(scoringId);
            for (Segment segment : impactedSegments) {
                Condition updatedCondition = this.updateScoringDependentCondition(segment.getCondition(), scoringId);
                segment.setCondition(updatedCondition);
                if (updatedCondition == null) {
                    this.clearAutoGeneratedRules(this.persistenceService.query("linkedItems", segment.getMetadata().getId(), null, Rule.class), segment.getMetadata().getId());
                    segment.getMetadata().setEnabled(false);
                }
                this.setSegmentDefinition(segment);
            }
            for (Scoring scoring : impactedScorings) {
                ArrayList<ScoringElement> updatedScoringElements = new ArrayList<ScoringElement>();
                for (ScoringElement scoringElement : scoring.getElements()) {
                    Condition updatedCondition = this.updateScoringDependentCondition(scoringElement.getCondition(), scoringId);
                    if (updatedCondition == null) continue;
                    scoringElement.setCondition(updatedCondition);
                    updatedScoringElements.add(scoringElement);
                }
                scoring.setElements(updatedScoringElements);
                if (updatedScoringElements.isEmpty()) {
                    this.clearAutoGeneratedRules(this.persistenceService.query("linkedItems", scoring.getMetadata().getId(), null, Rule.class), scoring.getMetadata().getId());
                    scoring.getMetadata().setEnabled(false);
                }
                this.setScoringDefinition(scoring);
            }
            this.persistenceService.remove(scoringId, Scoring.class);
            List previousRules = this.persistenceService.query("linkedItems", scoringId, null, Rule.class);
            this.clearAutoGeneratedRules(previousRules, scoringId);
        }
        LinkedList<Metadata> segments = new LinkedList<Metadata>();
        LinkedList<Metadata> scorings = new LinkedList<Metadata>();
        for (Segment segment : impactedSegments) {
            segments.add(segment.getMetadata());
        }
        for (Scoring scoring : impactedScorings) {
            scorings.add(scoring.getMetadata());
        }
        return new DependentMetadata(segments, scorings);
    }

    public void updateAutoGeneratedRules(Metadata metadata, Condition condition) {
        List previousRules = this.persistenceService.query("linkedItems", metadata.getId(), null, Rule.class);
        ArrayList<Rule> rules = new ArrayList<Rule>();
        if (condition != null) {
            this.getAutoGeneratedRules(metadata, condition, null, rules);
        }
        for (Rule rule : rules) {
            this.rulesService.setRule(rule);
        }
        previousRules.removeAll(rules);
        this.clearAutoGeneratedRules(previousRules, metadata.getId());
    }

    private void clearAutoGeneratedRules(List<Rule> rules, String idWithScope) {
        for (Rule previousRule : rules) {
            previousRule.getLinkedItems().remove(idWithScope);
            if (previousRule.getLinkedItems().isEmpty()) {
                this.persistenceService.remove(previousRule.getItemId(), Rule.class);
                continue;
            }
            this.persistenceService.update(previousRule.getItemId(), null, Rule.class, "linkedItems", (Object)previousRule.getLinkedItems());
        }
    }

    private void getAutoGeneratedRules(Metadata metadata, Condition condition, Condition parentCondition, List<Rule> rules) {
        Set tags = condition.getConditionType().getMetadata().getSystemTags();
        if (tags.contains("eventCondition") && !tags.contains("profileCondition")) {
            String key = this.getGeneratedPropertyKey(condition, parentCondition);
            if (key != null) {
                parentCondition.setParameter("generatedPropertyKey", (Object)key);
                Rule rule = this.rulesService.getRule(key);
                if (rule == null) {
                    rule = new Rule(new Metadata(metadata.getScope(), key, "Auto generated rule for " + metadata.getName(), ""));
                    rule.setCondition(condition);
                    rule.getMetadata().setHidden(true);
                    Action action = new Action();
                    action.setActionType(this.definitionsService.getActionType("setEventOccurenceCountAction"));
                    action.setParameter("pastEventCondition", (Object)parentCondition);
                    rule.setActions(Arrays.asList(action));
                    rule.setLinkedItems(Arrays.asList(metadata.getId()));
                    rules.add(rule);
                    this.updateExistingProfilesForPastEventCondition(condition, parentCondition);
                } else {
                    rule.getLinkedItems().add(metadata.getId());
                    rules.add(rule);
                }
            }
        } else {
            ArrayList values = new ArrayList(condition.getParameterValues().values());
            for (Object parameterValue : values) {
                if (parameterValue instanceof Condition) {
                    this.getAutoGeneratedRules(metadata, (Condition)parameterValue, condition, rules);
                    continue;
                }
                if (!(parameterValue instanceof Collection)) continue;
                for (Object subCondition : (Collection)parameterValue) {
                    if (!(subCondition instanceof Condition)) continue;
                    this.getAutoGeneratedRules(metadata, (Condition)subCondition, condition, rules);
                }
            }
        }
    }

    private void updateExistingProfilesForPastEventCondition(Condition eventCondition, Condition parentCondition) {
        long t = System.currentTimeMillis();
        ArrayList<Condition> l = new ArrayList<Condition>();
        Condition andCondition = new Condition();
        andCondition.setConditionType(this.definitionsService.getConditionType("booleanCondition"));
        andCondition.setParameter("operator", (Object)"and");
        andCondition.setParameter("subConditions", l);
        l.add(eventCondition);
        Integer numberOfDays = (Integer)parentCondition.getParameter("numberOfDays");
        String fromDate = (String)parentCondition.getParameter("fromDate");
        String toDate = (String)parentCondition.getParameter("toDate");
        if (numberOfDays != null) {
            Condition numberOfDaysCondition = new Condition();
            numberOfDaysCondition.setConditionType(this.definitionsService.getConditionType("sessionPropertyCondition"));
            numberOfDaysCondition.setParameter("propertyName", (Object)"timeStamp");
            numberOfDaysCondition.setParameter("comparisonOperator", (Object)"greaterThan");
            numberOfDaysCondition.setParameter("propertyValue", (Object)("now-" + numberOfDays + "d"));
            l.add(numberOfDaysCondition);
        }
        if (fromDate != null) {
            Condition startDateCondition = new Condition();
            startDateCondition.setConditionType(this.definitionsService.getConditionType("sessionPropertyCondition"));
            startDateCondition.setParameter("propertyName", (Object)"timeStamp");
            startDateCondition.setParameter("comparisonOperator", (Object)"greaterThanOrEqualTo");
            startDateCondition.setParameter("propertyValueDate", (Object)fromDate);
            l.add(startDateCondition);
        }
        if (toDate != null) {
            Condition endDateCondition = new Condition();
            endDateCondition.setConditionType(this.definitionsService.getConditionType("sessionPropertyCondition"));
            endDateCondition.setParameter("propertyName", (Object)"timeStamp");
            endDateCondition.setParameter("comparisonOperator", (Object)"lessThanOrEqualTo");
            endDateCondition.setParameter("propertyValueDate", (Object)toDate);
            l.add(endDateCondition);
        }
        String propertyKey = (String)parentCondition.getParameter("generatedPropertyKey");
        if (this.pastEventsDisablePartitions) {
            Map eventCountByProfile = this.persistenceService.aggregateWithOptimizedQuery(eventCondition, (BaseAggregate)new TermsAggregate("profileId"), "event", this.maximumIdsQueryCount);
            this.updateProfilesWithPastEventProperty(eventCountByProfile, propertyKey);
        } else {
            Map m = this.persistenceService.getSingleValuesMetrics(andCondition, new String[]{"card"}, "profileId.keyword", "event");
            long card = ((Double)m.get("_card")).longValue();
            int numParts = (int)(card / (long)this.aggregateQueryBucketSize) + 2;
            for (int i = 0; i < numParts; ++i) {
                Map eventCountByProfile = this.persistenceService.aggregateWithOptimizedQuery(andCondition, (BaseAggregate)new TermsAggregate("profileId", i, numParts), "event");
                this.updateProfilesWithPastEventProperty(eventCountByProfile, propertyKey);
            }
        }
        logger.info("Profiles past condition updated in {}ms", (Object)(System.currentTimeMillis() - t));
    }

    public String getGeneratedPropertyKey(Condition condition, Condition parentCondition) {
        try {
            Object toDate;
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("condition", condition);
            m.put("numberOfDays", parentCondition.getParameter("numberOfDays"));
            Object fromDate = parentCondition.getParameter("fromDate");
            if (fromDate != null) {
                m.put("fromDate", parentCondition.getParameter("fromDate"));
            }
            if ((toDate = parentCondition.getParameter("toDate")) != null) {
                m.put("fromDate", parentCondition.getParameter("toDate"));
            }
            String key = CustomObjectMapper.getObjectMapper().writeValueAsString(m);
            return "eventTriggered" + this.getMD5(key);
        }
        catch (JsonProcessingException e) {
            logger.error("Cannot generate key", (Throwable)e);
            return null;
        }
    }

    private void updateProfilesWithPastEventProperty(Map<String, Long> eventCountByProfile, String propertyKey) {
        for (Map.Entry<String, Long> entry : eventCountByProfile.entrySet()) {
            String profileId = entry.getKey();
            if (profileId.startsWith("_")) continue;
            HashMap<String, Long> pastEventCounts = new HashMap<String, Long>();
            pastEventCounts.put(propertyKey, entry.getValue());
            HashMap<String, Cloneable> systemProperties = new HashMap<String, Cloneable>();
            systemProperties.put("pastEvents", pastEventCounts);
            try {
                systemProperties.put("lastUpdated", new Date());
                Profile profile = new Profile();
                profile.setItemId(profileId);
                this.persistenceService.update(profile.getItemId(), null, Profile.class, "systemProperties", systemProperties);
            }
            catch (Exception e) {
                logger.error("Error updating profile {} past event system properties", (Object)profileId, (Object)e);
            }
        }
    }

    private String getMD5(String md5) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] array = md.digest(md5.getBytes());
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < array.length; ++i) {
                sb.append(Integer.toHexString(array[i] & 0xFF | 0x100).substring(1, 3));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private void updateExistingProfilesForSegment(Segment segment) {
        long updateProfilesForSegmentStartTime = System.currentTimeMillis();
        Condition segmentCondition = new Condition();
        long updatedProfileCount = 0L;
        segmentCondition.setConditionType(this.definitionsService.getConditionType("profilePropertyCondition"));
        segmentCondition.setParameter("propertyName", (Object)"segments");
        segmentCondition.setParameter("comparisonOperator", (Object)"equals");
        segmentCondition.setParameter("propertyValue", (Object)segment.getItemId());
        if (segment.getMetadata().isEnabled()) {
            Event profileUpdated;
            HashMap<String, Object> sourceMap;
            ConditionType booleanConditionType = this.definitionsService.getConditionType("booleanCondition");
            ConditionType notConditionType = this.definitionsService.getConditionType("notCondition");
            Condition profilesToAddCondition = new Condition(booleanConditionType);
            profilesToAddCondition.setParameter("operator", (Object)"and");
            ArrayList<Condition> profilesToAddSubConditions = new ArrayList<Condition>();
            profilesToAddSubConditions.add(segment.getCondition());
            Condition notOldSegmentCondition = new Condition(notConditionType);
            notOldSegmentCondition.setParameter("subCondition", (Object)segmentCondition);
            profilesToAddSubConditions.add(notOldSegmentCondition);
            profilesToAddCondition.setParameter("subConditions", profilesToAddSubConditions);
            Condition profilesToRemoveCondition = new Condition(booleanConditionType);
            profilesToRemoveCondition.setParameter("operator", (Object)"and");
            ArrayList<Condition> profilesToRemoveSubConditions = new ArrayList<Condition>();
            profilesToRemoveSubConditions.add(segmentCondition);
            Condition notNewSegmentCondition = new Condition(notConditionType);
            notNewSegmentCondition.setParameter("subCondition", (Object)segment.getCondition());
            profilesToRemoveSubConditions.add(notNewSegmentCondition);
            profilesToRemoveCondition.setParameter("subConditions", profilesToRemoveSubConditions);
            PartialList profilesToRemove = this.persistenceService.query(profilesToRemoveCondition, null, Profile.class, 0, this.segmentUpdateBatchSize, "10m");
            PartialList profilesToAdd = this.persistenceService.query(profilesToAddCondition, null, Profile.class, 0, this.segmentUpdateBatchSize, "10m");
            while (profilesToAdd.getList().size() > 0) {
                long profilesToAddStartTime = System.currentTimeMillis();
                for (Profile profileToAdd : profilesToAdd.getList()) {
                    profileToAdd.getSegments().add(segment.getItemId());
                    sourceMap = new HashMap<String, Object>();
                    sourceMap.put("segments", profileToAdd.getSegments());
                    profileToAdd.setSystemProperty("lastUpdated", (Object)new Date());
                    sourceMap.put("systemProperties", profileToAdd.getSystemProperties());
                    this.persistenceService.update(profileToAdd.getItemId(), null, Profile.class, sourceMap);
                    profileUpdated = new Event("profileUpdated", null, profileToAdd, null, null, (Item)profileToAdd, new Date());
                    profileUpdated.setPersistent(false);
                    this.eventService.send(profileUpdated);
                    ++updatedProfileCount;
                }
                logger.info("{} profiles added to segment in {}ms", (Object)profilesToAdd.size(), (Object)(System.currentTimeMillis() - profilesToAddStartTime));
                if ((profilesToAdd = this.persistenceService.continueScrollQuery(Profile.class, profilesToAdd.getScrollIdentifier(), profilesToAdd.getScrollTimeValidity())) != null && profilesToAdd.getList().size() != 0) continue;
                break;
            }
            while (profilesToRemove.getList().size() > 0) {
                long profilesToRemoveStartTime = System.currentTimeMillis();
                for (Profile profileToRemove : profilesToRemove.getList()) {
                    profileToRemove.getSegments().remove(segment.getItemId());
                    sourceMap = new HashMap();
                    sourceMap.put("segments", profileToRemove.getSegments());
                    profileToRemove.setSystemProperty("lastUpdated", (Object)new Date());
                    sourceMap.put("systemProperties", profileToRemove.getSystemProperties());
                    this.persistenceService.update(profileToRemove.getItemId(), null, Profile.class, sourceMap);
                    profileUpdated = new Event("profileUpdated", null, profileToRemove, null, null, (Item)profileToRemove, new Date());
                    profileUpdated.setPersistent(false);
                    this.eventService.send(profileUpdated);
                    ++updatedProfileCount;
                }
                logger.info("{} profiles removed from segment in {}ms", (Object)profilesToRemove.size(), (Object)(System.currentTimeMillis() - profilesToRemoveStartTime));
                if ((profilesToRemove = this.persistenceService.continueScrollQuery(Profile.class, profilesToRemove.getScrollIdentifier(), profilesToRemove.getScrollTimeValidity())) != null && profilesToRemove.getList().size() != 0) continue;
                break;
            }
        } else {
            PartialList profilesToRemove = this.persistenceService.query(segmentCondition, null, Profile.class, 0, 200, "10m");
            while (profilesToRemove.getList().size() > 0) {
                long profilesToRemoveStartTime = System.currentTimeMillis();
                for (Profile profileToRemove : profilesToRemove.getList()) {
                    profileToRemove.getSegments().remove(segment.getItemId());
                    HashMap<String, Object> sourceMap = new HashMap<String, Object>();
                    sourceMap.put("segments", profileToRemove.getSegments());
                    profileToRemove.setSystemProperty("lastUpdated", (Object)new Date());
                    sourceMap.put("systemProperties", profileToRemove.getSystemProperties());
                    this.persistenceService.update(profileToRemove.getItemId(), null, Profile.class, sourceMap);
                    Event profileUpdated = new Event("profileUpdated", null, profileToRemove, null, null, (Item)profileToRemove, new Date());
                    profileUpdated.setPersistent(false);
                    this.eventService.send(profileUpdated);
                    ++updatedProfileCount;
                }
                logger.info("{} profiles removed from segment in {}ms", (Object)profilesToRemove.size(), (Object)(System.currentTimeMillis() - profilesToRemoveStartTime));
                if ((profilesToRemove = this.persistenceService.continueScrollQuery(Profile.class, profilesToRemove.getScrollIdentifier(), profilesToRemove.getScrollTimeValidity())) != null && profilesToRemove.getList().size() != 0) continue;
                break;
            }
        }
        logger.info("{} profiles updated in {}ms", (Object)updatedProfileCount, (Object)(System.currentTimeMillis() - updateProfilesForSegmentStartTime));
    }

    private void updateExistingProfilesForScoring(Scoring scoring) {
        long startTime = System.currentTimeMillis();
        Condition scoringCondition = new Condition();
        scoringCondition.setConditionType(this.definitionsService.getConditionType("profilePropertyCondition"));
        scoringCondition.setParameter("propertyName", (Object)("scores." + scoring.getItemId()));
        scoringCondition.setParameter("comparisonOperator", (Object)"exists");
        String[] scripts = new String[scoring.getElements().size() + 1];
        Map[] scriptParams = new HashMap[scoring.getElements().size() + 1];
        Condition[] conditions = new Condition[scoring.getElements().size() + 1];
        String lastUpdatedScriptPart = " if (!ctx._source.containsKey(\"systemProperties\")) { ctx._source.put(\"systemProperties\", [:]) } ctx._source.systemProperties.put(\"lastUpdated\", ZonedDateTime.ofInstant(Instant.ofEpochMilli(System.currentTimeMillis()), ZoneId.of(\"Z\")))";
        scriptParams[0] = new HashMap();
        scriptParams[0].put("scoringId", scoring.getItemId());
        scripts[0] = "if (ctx._source.containsKey(\"systemProperties\") && ctx._source.systemProperties.containsKey(\"scoreModifiers\") && ctx._source.systemProperties.scoreModifiers.containsKey(params.scoringId) ) { ctx._source.scores.put(params.scoringId, ctx._source.systemProperties.scoreModifiers.get(params.scoringId)) } else { ctx._source.scores.remove(params.scoringId) } " + lastUpdatedScriptPart;
        conditions[0] = scoringCondition;
        if (scoring.getMetadata().isEnabled()) {
            String scriptToAdd = "if (!ctx._source.containsKey(\"scores\")) { ctx._source.put(\"scores\", [:])} if (ctx._source.scores.containsKey(params.scoringId) ) { ctx._source.scores.put(params.scoringId, ctx._source.scores.get(params.scoringId)+params.scoringValue) } else { ctx._source.scores.put(params.scoringId, params.scoringValue) } " + lastUpdatedScriptPart;
            int idx = 1;
            for (ScoringElement element : scoring.getElements()) {
                scriptParams[idx] = new HashMap();
                ((HashMap)scriptParams[idx]).put("scoringId", scoring.getItemId());
                ((HashMap)scriptParams[idx]).put("scoringValue", element.getValue());
                scripts[idx] = scriptToAdd;
                conditions[idx] = element.getCondition();
                ++idx;
            }
        }
        this.persistenceService.updateWithQueryAndScript(null, Profile.class, scripts, scriptParams, conditions);
        logger.info("Updated scoring for profiles in {}ms", (Object)(System.currentTimeMillis() - startTime));
    }

    private void updateExistingProfilesForRemovedScoring(String scoringId) {
        long startTime = System.currentTimeMillis();
        Condition scoringCondition = new Condition();
        scoringCondition.setConditionType(this.definitionsService.getConditionType("profilePropertyCondition"));
        scoringCondition.setParameter("propertyName", (Object)("scores." + scoringId));
        scoringCondition.setParameter("comparisonOperator", (Object)"exists");
        Condition[] conditions = new Condition[]{scoringCondition};
        Map[] scriptParams = new HashMap[]{new HashMap()};
        scriptParams[0].put("scoringId", scoringId);
        String[] script = new String[]{"ctx._source.scores.remove(params.scoringId); if (!ctx._source.containsKey(\"systemProperties\")) { ctx._source.put(\"systemProperties\", [:]) } ctx._source.systemProperties.put(\"lastUpdated\", ZonedDateTime.ofInstant(Instant.ofEpochMilli(System.currentTimeMillis()), ZoneId.of(\"Z\")))"};
        this.persistenceService.updateWithQueryAndScript(null, Profile.class, script, scriptParams, conditions);
        logger.info("Removed scoring from profiles in {}ms", (Object)(System.currentTimeMillis() - startTime));
    }

    public void bundleChanged(BundleEvent event) {
        switch (event.getType()) {
            case 2: {
                this.processBundleStartup(event.getBundle().getBundleContext());
                break;
            }
            case 256: {
                this.processBundleStop(event.getBundle().getBundleContext());
            }
        }
    }

    private void initializeTimer() {
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                try {
                    for (Metadata metadata : SegmentServiceImpl.this.rulesService.getRuleMetadatas()) {
                        Rule rule = SegmentServiceImpl.this.rulesService.getRule(metadata.getId());
                        for (Action action : rule.getActions()) {
                            Condition pastEventCondition;
                            if (!action.getActionTypeId().equals("setEventOccurenceCountAction") || !(pastEventCondition = (Condition)action.getParameterValues().get("pastEventCondition")).containsParameter("numberOfDays")) continue;
                            SegmentServiceImpl.this.updateExistingProfilesForPastEventCondition(rule.getCondition(), pastEventCondition);
                        }
                    }
                }
                catch (Throwable t) {
                    logger.error("Error while updating profiles for past event conditions", t);
                }
            }
        };
        this.schedulerService.getScheduleExecutorService().scheduleAtFixedRate(task, 1L, this.taskExecutionPeriod, TimeUnit.DAYS);
        task = new TimerTask(){

            @Override
            public void run() {
                try {
                    SegmentServiceImpl.this.allSegments = SegmentServiceImpl.this.getAllSegmentDefinitions();
                    SegmentServiceImpl.this.allScoring = SegmentServiceImpl.this.getAllScoringDefinitions();
                }
                catch (Throwable t) {
                    logger.error("Error while loading segments and scoring definitions from persistence back-end", t);
                }
            }
        };
        this.schedulerService.getScheduleExecutorService().scheduleAtFixedRate(task, 0L, this.segmentRefreshInterval, TimeUnit.MILLISECONDS);
    }

    public void setTaskExecutionPeriod(long taskExecutionPeriod) {
        this.taskExecutionPeriod = taskExecutionPeriod;
    }
}

