/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.examples.cpe;

import example.PersonTitle;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.collection.CasConsumer_ImplBase;
import org.apache.uima.examples.SourceDocumentInformation;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceProcessException;
import org.apache.uima.util.ProcessTrace;

public class PersonTitleDBWriterCasConsumer
extends CasConsumer_ImplBase {
    public static final String PARAM_OUTPUTDIR = "OutputDirectory";
    public static final int MAX_URI_LENGTH = 80;
    public static final int MAX_TITLE_LENGTH = 20;
    public static final int DB_LOAD_BATCH_SIZE = 50;
    private int batchCounter = 50;
    private File mOutputDir;
    private boolean firstCall = true;
    private static boolean firstEverCall = true;
    private PreparedStatement stmt;
    private Connection con;
    private long startTime;

    public void initialize() throws ResourceInitializationException {
        this.startTime = System.currentTimeMillis();
        System.out.println("Time: " + (System.currentTimeMillis() - this.startTime) + " initialize() called");
        this.mOutputDir = new File((String)this.getConfigParameterValue(PARAM_OUTPUTDIR));
        if (!this.mOutputDir.exists()) {
            this.mOutputDir.mkdirs();
        }
        System.setProperty("derby.system.home", this.mOutputDir.toString());
        System.out.println("Time: " + (System.currentTimeMillis() - this.startTime) + " DB Writer: Set derby system home to: '" + this.mOutputDir.toString() + "'");
    }

    public void processCas(CAS aCAS) throws ResourceProcessException {
        JCas jcas;
        System.out.println("Time: " + (System.currentTimeMillis() - this.startTime) + " DB Writer: ProcessCas called");
        try {
            jcas = aCAS.getJCas();
        }
        catch (CASException e) {
            throw new ResourceProcessException((Throwable)e);
        }
        try {
            if (this.firstCall) {
                File db;
                this.firstCall = false;
                System.out.println("Time: " + (System.currentTimeMillis() - this.startTime) + " DB Writer: First Time Initiailization: ");
                if (firstEverCall) {
                    firstEverCall = false;
                    System.out.println("Time: " + (System.currentTimeMillis() - this.startTime) + " DB Writer: Doing first process call ever (even during re-runs) initialization");
                    try {
                        Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
                        System.out.println("Time: " + (System.currentTimeMillis() - this.startTime) + " DB Writer:    Loaded derby DB driver OK");
                    }
                    catch (ClassNotFoundException e) {
                        System.err.println("No driver found for derby - check class path.");
                    }
                    catch (InstantiationException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
                if ((db = new File(this.mOutputDir.toString() + "/ExamplePersonTitleDB")).exists()) {
                    System.out.println("Time: " + (System.currentTimeMillis() - this.startTime) + " DB Writer: First Time Initiailization: Deleting Database");
                    this.deleteDir(db);
                    System.out.println("Time: " + (System.currentTimeMillis() - this.startTime) + " DB Writer: First Time Initiailization: Database deleted");
                }
                this.con = DriverManager.getConnection("jdbc:derby:ExamplePersonTitleDB;create=true");
                System.out.println("Time: " + (System.currentTimeMillis() - this.startTime) + " DB Writer: First Time Initiailization: Created the ExamplePersonTitleDB and connected to it.");
                Statement sqlStmt = this.con.createStatement();
                try {
                    sqlStmt.execute("drop table PersonTitle");
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                sqlStmt.execute("create table PersonTitle(uri varchar(80), spannedText varchar(20), beginOffset int, endOffset int)");
                System.out.println("Time: " + (System.currentTimeMillis() - this.startTime) + " DB Writer: First Time Initiailization: Created the PersonTitle table.");
                sqlStmt.close();
                this.stmt = this.con.prepareStatement("insert into PersonTitle values (?, ?, ?, ?)");
                this.con.setAutoCommit(false);
            }
            SourceDocumentInformation sdi = (SourceDocumentInformation)jcas.getAnnotationIndex(SourceDocumentInformation.type).iterator().next();
            System.out.println("Time: " + (System.currentTimeMillis() - this.startTime) + " DB Writer: Processing doc: '" + sdi.getUri() + "'");
            this.stmt.setString(1, this.truncate(sdi.getUri(), 80));
            for (PersonTitle pt : jcas.getAnnotationIndex(PersonTitle.type)) {
                this.stmt.setString(2, this.truncate(pt.getCoveredText(), 20));
                this.stmt.setInt(3, pt.getBegin());
                this.stmt.setInt(4, pt.getEnd());
                this.stmt.addBatch();
                --this.batchCounter;
                if (this.batchCounter > 0) continue;
                System.out.println("Time: " + (System.currentTimeMillis() - this.startTime) + " DB Writer: Batch writing updates - process call");
                this.stmt.executeBatch();
                this.con.commit();
                this.batchCounter = 50;
            }
        }
        catch (SQLException e) {
            try {
                this.con.rollback();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
            try {
                this.stmt.clearBatch();
            }
            catch (SQLException e2) {
                e2.printStackTrace();
            }
            throw new ResourceProcessException((Throwable)e);
        }
    }

    public void collectionProcessComplete(ProcessTrace arg0) throws ResourceProcessException, IOException {
        this.firstCall = true;
        try {
            if (this.batchCounter < 50) {
                System.out.println("Time: " + (System.currentTimeMillis() - this.startTime) + " DB Writer: Batch writing updates - processComplete call");
                this.stmt.executeBatch();
                this.con.commit();
                this.batchCounter = 50;
            }
            this.stmt.close();
            this.con.close();
            System.out.println("Time: " + (System.currentTimeMillis() - this.startTime) + " DB Writer: Sucessfully closed the connection - done.");
        }
        catch (SQLException e) {
            System.err.println("Unexpected SQL exception");
            e.printStackTrace();
        }
        try {
            DriverManager.getConnection("jdbc:derby:ExamplePersonTitleDB;shutdown=true");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            firstEverCall = true;
            DriverManager.getConnection("jdbc:derby:;shutdown=true");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void deleteDir(File f) {
        if (f.isDirectory()) {
            String[] contents = f.list();
            for (int i = 0; i < contents.length; ++i) {
                this.deleteDir(new File(f.toString() + "/" + contents[i]));
            }
        }
        f.delete();
    }

    private String truncate(String s, int length) {
        if (s.length() <= length) {
            return s;
        }
        return s.substring(0, length);
    }
}

