/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Constraint;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.ReferenceObject;
import org.hsqldb.Routine;
import org.hsqldb.RoutineSchema;
import org.hsqldb.SchemaObject;
import org.hsqldb.SchemaObjectSet;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.OrderedHashMap;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.WrapperIterator;
import org.hsqldb.rights.Grantee;
import org.hsqldb.types.Type;

public final class Schema
implements SchemaObject {
    static int[] scriptSequenceOne = new int[]{14, 15, 12, 7, 16};
    static int[] scriptSequenceTwo = new int[]{3, 17, 8, 29, 31};
    long changeTimestamp;
    private HsqlNameManager.HsqlName name;
    SchemaObjectSet assertionLookup;
    SchemaObjectSet charsetLookup;
    SchemaObjectSet collationLookup;
    SchemaObjectSet conditionLookup;
    SchemaObjectSet constraintLookup;
    SchemaObjectSet functionLookup;
    SchemaObjectSet indexLookup;
    SchemaObjectSet moduleLookup;
    SchemaObjectSet procedureLookup;
    SchemaObjectSet referenceLookup;
    SchemaObjectSet sequenceLookup;
    SchemaObjectSet specificRLookup;
    SchemaObjectSet tableLookup;
    SchemaObjectSet triggerLookup;
    SchemaObjectSet typeLookup;
    OrderedHashMap<String, ReferenceObject> referenceList;
    OrderedHashMap<String, NumberSequence> sequenceList;
    OrderedHashMap<String, Table> tableList;

    public Schema(HsqlNameManager.HsqlName hsqlName, Grantee grantee) {
        this.name = hsqlName;
        hsqlName.owner = grantee;
        this.assertionLookup = new SchemaObjectSet(6);
        this.charsetLookup = new SchemaObjectSet(14);
        this.collationLookup = new SchemaObjectSet(15);
        this.constraintLookup = new SchemaObjectSet(5);
        this.conditionLookup = new SchemaObjectSet(32);
        this.functionLookup = new SchemaObjectSet(16);
        this.indexLookup = new SchemaObjectSet(20);
        this.moduleLookup = new SchemaObjectSet(31);
        this.procedureLookup = new SchemaObjectSet(17);
        this.referenceLookup = new SchemaObjectSet(29);
        this.sequenceLookup = new SchemaObjectSet(7);
        this.specificRLookup = new SchemaObjectSet(24);
        this.tableLookup = new SchemaObjectSet(3);
        this.triggerLookup = new SchemaObjectSet(8);
        this.typeLookup = new SchemaObjectSet(12);
        this.referenceList = this.referenceLookup.getMap();
        this.sequenceList = this.sequenceLookup.getMap();
        this.tableList = this.tableLookup.getMap();
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public HsqlNameManager.HsqlName getName() {
        return this.name;
    }

    @Override
    public HsqlNameManager.HsqlName getSchemaName() {
        return null;
    }

    @Override
    public HsqlNameManager.HsqlName getCatalogName() {
        return this.name.schema;
    }

    @Override
    public Grantee getOwner() {
        return this.name.owner;
    }

    @Override
    public long getChangeTimestamp() {
        return this.changeTimestamp;
    }

    @Override
    public String getSQL() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append("CREATE").append(' ').append("SCHEMA").append(' ').append(this.getName().statementName).append(' ').append("AUTHORIZATION").append(' ').append(this.getOwner().getName().getStatementName());
        return stringBuilder.toString();
    }

    String getSetSchemaSQL() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append("SET").append(' ').append("SCHEMA").append(' ').append(this.name.statementName);
        return stringBuilder.toString();
    }

    public HsqlArrayList<String> getSQLArray(int n, OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet, OrderedHashSet<SchemaObject> orderedHashSet2) {
        HsqlArrayList<String> hsqlArrayList = new HsqlArrayList<String>();
        switch (n) {
            case 14: {
                this.charsetLookup.getSQL(hsqlArrayList, orderedHashSet, orderedHashSet2);
                break;
            }
            case 15: {
                this.collationLookup.getSQL(hsqlArrayList, orderedHashSet, orderedHashSet2);
                break;
            }
            case 16: {
                this.functionLookup.getSQL(hsqlArrayList, orderedHashSet, orderedHashSet2);
                break;
            }
            case 17: {
                this.procedureLookup.getSQL(hsqlArrayList, orderedHashSet, orderedHashSet2);
                break;
            }
            case 29: {
                this.referenceLookup.getSQL(hsqlArrayList, orderedHashSet, orderedHashSet2);
                break;
            }
            case 7: {
                this.sequenceLookup.getSQL(hsqlArrayList, orderedHashSet, orderedHashSet2);
                break;
            }
            case 3: {
                this.tableLookup.getSQL(hsqlArrayList, orderedHashSet, orderedHashSet2);
                break;
            }
            case 12: {
                this.typeLookup.getSQL(hsqlArrayList, orderedHashSet, orderedHashSet2);
            }
        }
        return hsqlArrayList;
    }

    public HsqlArrayList<String> getSequenceRestartSQLArray() {
        HsqlArrayList<String> hsqlArrayList = new HsqlArrayList<String>();
        Iterator iterator = this.sequenceList.values().iterator();
        while (iterator.hasNext()) {
            NumberSequence numberSequence = (NumberSequence)iterator.next();
            String string = numberSequence.getRestartSQL();
            hsqlArrayList.add(string);
        }
        return hsqlArrayList;
    }

    public HsqlArrayList<String> getTriggerSQLArray() {
        HsqlArrayList<String> hsqlArrayList = new HsqlArrayList<String>();
        Iterator iterator = this.tableList.values().iterator();
        while (iterator.hasNext()) {
            Table table = (Table)iterator.next();
            HsqlArrayList<String> hsqlArrayList2 = table.getTriggerSQLArray();
            hsqlArrayList.addAll(hsqlArrayList2);
        }
        return hsqlArrayList;
    }

    boolean isEmpty() {
        return this.sequenceLookup.isEmpty() && this.tableLookup.isEmpty() && this.typeLookup.isEmpty() && this.charsetLookup.isEmpty() && this.collationLookup.isEmpty() && this.specificRLookup.isEmpty();
    }

    private SchemaObjectSet getObjectSet(int n) {
        switch (n) {
            case 6: {
                return this.assertionLookup;
            }
            case 14: {
                return this.charsetLookup;
            }
            case 15: {
                return this.collationLookup;
            }
            case 5: {
                return this.constraintLookup;
            }
            case 32: {
                return this.conditionLookup;
            }
            case 16: {
                return this.functionLookup;
            }
            case 20: {
                return this.indexLookup;
            }
            case 31: {
                return this.moduleLookup;
            }
            case 17: {
                return this.procedureLookup;
            }
            case 29: {
                return this.referenceLookup;
            }
            case 7: {
                return this.sequenceLookup;
            }
            case 24: {
                return this.specificRLookup;
            }
            case 3: 
            case 4: {
                return this.tableLookup;
            }
            case 8: {
                return this.triggerLookup;
            }
            case 12: 
            case 13: {
                return this.typeLookup;
            }
        }
        throw Error.runtimeError(201, "Schema");
    }

    public Iterator<SchemaObject> schemaObjectIterator(int n) {
        switch (n) {
            case 6: {
                return this.assertionLookup.getIterator();
            }
            case 14: {
                return this.charsetLookup.getIterator();
            }
            case 15: {
                return this.collationLookup.getIterator();
            }
            case 5: {
                return this.constraintsIterator();
            }
            case 32: {
                return this.conditionLookup.getIterator();
            }
            case 16: {
                return this.functionLookup.getIterator();
            }
            case 20: {
                return this.indexLookup.getIterator();
            }
            case 31: {
                return this.moduleLookup.getIterator();
            }
            case 17: {
                return this.procedureLookup.getIterator();
            }
            case 29: {
                return this.referenceLookup.getIterator();
            }
            case 18: {
                Iterator<SchemaObject> iterator = this.functionLookup.getIterator();
                return new WrapperIterator<SchemaObject>(iterator, this.procedureLookup.getIterator());
            }
            case 7: {
                return this.sequenceLookup.getIterator();
            }
            case 24: {
                return this.specificRLookup.getIterator();
            }
            case 8: {
                return this.triggerLookup.getIterator();
            }
            case 3: 
            case 4: {
                return this.tableLookup.getIterator();
            }
            case 12: 
            case 13: {
                return this.typeLookup.getIterator();
            }
        }
        throw Error.runtimeError(201, "Schema");
    }

    public Iterator<SchemaObject> constraintsIterator() {
        return new Iterator<SchemaObject>(){
            Iterator<HsqlNameManager.HsqlName> names;
            Constraint current;
            boolean b;
            {
                this.names = Schema.this.constraintLookup.getNameIterator();
                this.b = this.filterToNext();
            }

            @Override
            public boolean hasNext() {
                return this.current != null;
            }

            @Override
            public Constraint next() {
                Constraint constraint = this.current;
                this.filterToNext();
                return constraint;
            }

            private boolean filterToNext() {
                this.current = null;
                block4: while (this.names.hasNext()) {
                    HsqlNameManager.HsqlName hsqlName = this.names.next();
                    if (hsqlName.parent == null) continue;
                    switch (hsqlName.parent.type) {
                        case 3: {
                            Cloneable cloneable = (Table)Schema.this.findSchemaObject(hsqlName.parent.name, 3);
                            if (cloneable == null) continue block4;
                            this.current = ((Table)cloneable).getConstraint(hsqlName.name);
                            break;
                        }
                        case 13: {
                            Cloneable cloneable = (Type)Schema.this.findSchemaObject(hsqlName.parent.name, 13);
                            if (cloneable == null) continue block4;
                            this.current = ((Type)cloneable).userTypeModifier.getConstraint(hsqlName.name);
                            break;
                        }
                    }
                    return true;
                }
                return false;
            }
        };
    }

    SchemaObject findAnySchemaObjectForSynonym(String string) {
        int[] nArray = new int[]{7, 3, 18};
        for (int i = 0; i < nArray.length; ++i) {
            SchemaObject schemaObject = this.findSchemaObject(string, nArray[i]);
            if (schemaObject == null) continue;
            return schemaObject;
        }
        return null;
    }

    ReferenceObject findReference(String string, int n) {
        ReferenceObject referenceObject = (ReferenceObject)this.referenceList.get((Object)string);
        if (referenceObject == null) {
            return null;
        }
        int n2 = referenceObject.getTarget().type;
        if (n2 == n) {
            return referenceObject;
        }
        switch (n) {
            case 3: {
                if (n2 != 4) break;
                return referenceObject;
            }
            case 18: {
                if (n2 != 16 && n2 != 17) break;
                return referenceObject;
            }
        }
        return null;
    }

    SchemaObject findSchemaObject(String string, int n) {
        switch (n) {
            case 14: {
                return this.charsetLookup.getObject(string);
            }
            case 15: {
                return this.collationLookup.getObject(string);
            }
            case 5: {
                SchemaObjectSet schemaObjectSet = this.constraintLookup;
                HsqlNameManager.HsqlName hsqlName = schemaObjectSet.getName(string);
                if (hsqlName == null) {
                    return null;
                }
                switch (hsqlName.parent.type) {
                    case 3: {
                        Table table = (Table)this.tableList.get((Object)hsqlName.parent.name);
                        if (table == null) {
                            return null;
                        }
                        return table.getConstraint(string);
                    }
                    case 13: {
                        Type type = (Type)this.typeLookup.getObject(hsqlName.parent.name);
                        return type.userTypeModifier.getConstraint(hsqlName.name);
                    }
                }
                throw Error.runtimeError(201, "SchemaManager");
            }
            case 32: {
                return this.conditionLookup.getObject(string);
            }
            case 16: {
                return this.functionLookup.getObject(string);
            }
            case 20: {
                SchemaObjectSet schemaObjectSet = this.indexLookup;
                HsqlNameManager.HsqlName hsqlName = schemaObjectSet.getName(string);
                if (hsqlName == null) {
                    return null;
                }
                Table table = (Table)this.tableList.get((Object)hsqlName.parent.name);
                return table.getIndex(string);
            }
            case 31: {
                return this.moduleLookup.getObject(string);
            }
            case 17: {
                return this.procedureLookup.getObject(string);
            }
            case 7: {
                return this.sequenceLookup.getObject(string);
            }
            case 29: {
                return this.referenceLookup.getObject(string);
            }
            case 18: {
                SchemaObject schemaObject = this.procedureLookup.getObject(string);
                if (schemaObject == null) {
                    schemaObject = this.functionLookup.getObject(string);
                }
                return schemaObject;
            }
            case 24: {
                return this.specificRLookup.getObject(string);
            }
            case 3: 
            case 4: {
                return this.tableLookup.getObject(string);
            }
            case 8: {
                SchemaObjectSet schemaObjectSet = this.triggerLookup;
                HsqlNameManager.HsqlName hsqlName = schemaObjectSet.getName(string);
                if (hsqlName == null) {
                    return null;
                }
                Table table = (Table)this.tableList.get((Object)hsqlName.parent.name);
                return table.getTrigger(string);
            }
            case 12: 
            case 13: {
                return this.typeLookup.getObject(string);
            }
        }
        throw Error.runtimeError(201, "SchemaManager");
    }

    public void addSchemaObject(HsqlNameManager hsqlNameManager, SchemaObject schemaObject, boolean bl) {
        HsqlNameManager.HsqlName hsqlName = schemaObject.getName();
        SchemaObjectSet schemaObjectSet = this.getObjectSet(hsqlName.type);
        switch (hsqlName.type) {
            case 16: 
            case 17: {
                RoutineSchema routineSchema = (RoutineSchema)schemaObjectSet.getObject(hsqlName.name);
                if (routineSchema == null) {
                    routineSchema = new RoutineSchema(hsqlName.type, hsqlName);
                    routineSchema.addSpecificRoutine(hsqlNameManager, (Routine)schemaObject, bl);
                    schemaObjectSet.checkAdd(hsqlName);
                    SchemaObjectSet schemaObjectSet2 = this.getObjectSet(24);
                    schemaObjectSet2.checkAdd(((Routine)schemaObject).getSpecificName());
                    schemaObjectSet.add(routineSchema, bl);
                    schemaObjectSet2.add(schemaObject, bl);
                } else {
                    SchemaObjectSet schemaObjectSet3 = this.getObjectSet(24);
                    HsqlNameManager.HsqlName hsqlName2 = ((Routine)schemaObject).getSpecificName();
                    if (hsqlName2 != null) {
                        schemaObjectSet3.checkAdd(hsqlName2);
                    }
                    routineSchema.addSpecificRoutine(hsqlNameManager, (Routine)schemaObject, bl);
                    schemaObjectSet3.add(schemaObject, bl);
                }
                return;
            }
        }
        schemaObjectSet.add(schemaObject, bl);
    }

    public void checkObjectNotExists(HsqlNameManager.HsqlName hsqlName) {
        SchemaObjectSet schemaObjectSet = this.getObjectSet(hsqlName.type);
        schemaObjectSet.checkAdd(hsqlName);
    }

    public void renameObject(HsqlNameManager.HsqlName hsqlName, HsqlNameManager.HsqlName hsqlName2) {
        SchemaObjectSet schemaObjectSet = this.getObjectSet(hsqlName.type);
        schemaObjectSet.rename(hsqlName, hsqlName2);
    }

    void release() {
        for (int i = 0; i < this.tableList.size(); ++i) {
            Table table = this.tableList.get(i);
            table.terminateTriggers();
        }
        this.charsetLookup = null;
        this.collationLookup = null;
        this.conditionLookup = null;
        this.constraintLookup = null;
        this.functionLookup = null;
        this.indexLookup = null;
        this.moduleLookup = null;
        this.procedureLookup = null;
        this.sequenceLookup = null;
        this.specificRLookup = null;
        this.tableLookup = null;
        this.triggerLookup = null;
        this.typeLookup = null;
        this.tableList.clear();
        this.sequenceList.clear();
        this.referenceList.clear();
    }
}

