/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Stack;
import org.apache.openejb.client.ClientRuntimeException;
import org.apache.openejb.client.ProtocolMetaData;

public class ThrowableArtifact
implements Externalizable {
    private static final long serialVersionUID = 8465895155478377443L;
    private transient Throwable throwable;
    private transient ProtocolMetaData metaData;

    public ThrowableArtifact(Throwable throwable) {
        this.throwable = throwable;
    }

    public ThrowableArtifact() {
    }

    public void setMetaData(ProtocolMetaData metaData) {
        this.metaData = metaData;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        Stack<MockThrowable> stack = new Stack<MockThrowable>();
        for (Throwable cause = this.throwable; cause != null; cause = cause.getCause()) {
            stack.add(new MockThrowable(cause));
        }
        out.writeObject(stack);
        try {
            out.writeObject(this.throwable);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        Stack stack = (Stack)in.readObject();
        try {
            this.throwable = (Throwable)in.readObject();
        }
        catch (Exception e) {
            this.throwable = this.createMockThrowable(stack);
        }
    }

    private Throwable createMockThrowable(Stack<MockThrowable> stack) {
        Throwable throwable = stack.pop();
        while (!stack.isEmpty()) {
            throwable = stack.pop().initCause(throwable);
        }
        return new ClientRuntimeException("The exception sent could not be serialized or deserialized.  This is a mock recreation:\n" + String.valueOf(throwable), throwable);
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public String toString() {
        return this.throwable.toString();
    }

    private static class MockThrowable
    extends Throwable {
        private final String classType;

        public MockThrowable(Throwable t) {
            this(t.getMessage(), t.getClass().getName(), t.getStackTrace());
        }

        public MockThrowable(String message, String classType, StackTraceElement[] stackTrace) {
            super(message);
            this.classType = classType;
            this.setStackTrace(stackTrace);
        }

        @Override
        public String toString() {
            String s = this.classType;
            String message = this.getLocalizedMessage();
            return message != null ? s + ": " + message : s;
        }
    }
}

