/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing;

import java.util.Collection;
import java.util.Iterator;
import org.apache.sis.metadata.internal.shared.NameMeaning;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.referencing.internal.shared.NilReferencingObject;
import org.apache.sis.util.internal.shared.Strings;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.xml.bind.Context;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.GenericName;

final class NameIterator
implements Iterator<ReferenceIdentifier> {
    private ReferenceIdentifier next;
    private final Iterator<GenericName> alias;

    NameIterator(IdentifiedObject object) {
        this.alias = object.getAlias().iterator();
        this.next = object.getName();
        if (NameIterator.isUnnamed(this.next)) {
            this.next();
        }
    }

    static boolean isUnnamed(ReferenceIdentifier name) {
        return name == null || name == NilReferencingObject.UNNAMED;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public ReferenceIdentifier next() {
        ReferenceIdentifier n = this.next;
        while (this.alias.hasNext()) {
            GenericName c = this.alias.next();
            if (!(c instanceof ReferenceIdentifier)) continue;
            this.next = (ReferenceIdentifier)c;
            return n;
        }
        this.next = null;
        return n;
    }

    public static int count(IdentifiedObject object) {
        int c = 0;
        NameIterator it = new NameIterator(object);
        while (it.hasNext()) {
            it.next();
            ++c;
        }
        return c;
    }

    /*
     * WARNING - void declaration
     */
    static String getID(IdentifiedObject object, ReferenceIdentifier name, Collection<? extends GenericName> alias, Collection<? extends ReferenceIdentifier> identifiers) {
        Context context = Context.current();
        String candidate = Context.getObjectID((Context)context, (Object)object);
        if (candidate == null) {
            StringBuilder id = new StringBuilder();
            if (identifiers != null) {
                for (ReferenceIdentifier referenceIdentifier : identifiers) {
                    if (Strings.appendUnicodeIdentifier((StringBuilder)id, (char)'-', (String)referenceIdentifier.getCodeSpace(), (String)"", (boolean)true) | Strings.appendUnicodeIdentifier((StringBuilder)id, (char)'-', (String)NameMeaning.toObjectType((Class)object.getClass()), (String)"", (boolean)false) | Strings.appendUnicodeIdentifier((StringBuilder)id, (char)'-', (String)referenceIdentifier.getCode(), (String)"", (boolean)true) && Context.setObjectForID((Context)context, (Object)object, (String)(candidate = id.toString()))) {
                        return candidate;
                    }
                    id.setLength(0);
                }
            }
            if ((NameIterator.isUnnamed(name) || !Strings.appendUnicodeIdentifier((StringBuilder)id, (char)'-', (String)name.getCode(), (String)"", (boolean)false)) && alias != null) {
                GenericName genericName;
                Iterator<? extends ReferenceIdentifier> iterator = alias.iterator();
                while (iterator.hasNext() && !Strings.appendUnicodeIdentifier((StringBuilder)id, (char)'-', (String)(genericName = (GenericName)iterator.next()).toString(), (String)"", (boolean)false)) {
                }
            }
            if (id.length() != 0 && !Context.setObjectForID((Context)context, (Object)object, (String)(candidate = id.toString()))) {
                int s = id.append('-').length();
                boolean bl = false;
                do {
                    void var8_13;
                    if (++var8_13 == 100) {
                        return null;
                    }
                    candidate = id.append((int)var8_13).toString();
                    id.setLength(s);
                } while (!Context.setObjectForID((Context)context, (Object)object, (String)candidate));
            }
        }
        return candidate;
    }

    static void setID(IdentifiedObject object, String id) {
        Context context = Context.current();
        if (!Context.setObjectForID((Context)context, (Object)object, (String)id)) {
            Context.warningOccured((Context)context, AbstractIdentifiedObject.class, (String)"setID", Errors.class, (short)39, (Object[])new Object[]{id});
        }
    }
}

