/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.math;

import java.io.Serializable;
import java.util.Objects;
import java.util.function.IntSupplier;
import org.apache.sis.math.Vector;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.util.resources.Errors;

final class RepeatedVector
extends Vector
implements Serializable {
    private static final long serialVersionUID = 3607036775685492552L;
    private final Vector base;
    private final int occurrences;
    private final int cycleLength;
    private final int size;

    RepeatedVector(Vector base, int occurrences, int cycleLength, int size) {
        this.base = base;
        this.occurrences = occurrences;
        this.cycleLength = cycleLength;
        this.size = size;
        assert (cycleLength <= base.size()) : cycleLength;
    }

    RepeatedVector(Vector base, int[] repetitions, double tolerance) {
        this.size = base.size();
        this.occurrences = repetitions[0];
        this.cycleLength = repetitions.length >= 2 ? repetitions[1] : this.size / this.occurrences;
        this.base = base.subSampling(0, this.occurrences, this.cycleLength).compress(tolerance);
    }

    private int toBase(int index) {
        return Objects.checkIndex(index, this.size) / this.occurrences % this.cycleLength;
    }

    @Override
    public final Class<? extends Number> getElementType() {
        return this.base.getElementType();
    }

    @Override
    public final boolean isEmptyOrNaN() {
        return this.base.isEmptyOrNaN();
    }

    @Override
    public final boolean isSinglePrecision() {
        return this.base.isSinglePrecision();
    }

    @Override
    public final boolean isInteger() {
        return this.base.isInteger();
    }

    @Override
    public final boolean isUnsigned() {
        return this.base.isUnsigned();
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final boolean isNaN(int i) {
        return this.base.isNaN(this.toBase(i));
    }

    @Override
    public final double doubleValue(int i) {
        return this.base.doubleValue(this.toBase(i));
    }

    @Override
    public final float floatValue(int i) {
        return this.base.floatValue(this.toBase(i));
    }

    @Override
    public final long longValue(int i) {
        return this.base.longValue(this.toBase(i));
    }

    @Override
    public final int intValue(int i) {
        return this.base.intValue(this.toBase(i));
    }

    @Override
    public final short shortValue(int i) {
        return this.base.shortValue(this.toBase(i));
    }

    @Override
    public final byte byteValue(int i) {
        return this.base.byteValue(this.toBase(i));
    }

    @Override
    public final String stringValue(int i) {
        return this.base.stringValue(this.toBase(i));
    }

    @Override
    public final Number get(int i) {
        return this.base.get(this.toBase(i));
    }

    @Override
    public final NumberRange<?> range() {
        return this.cycleLength == this.base.size() ? this.base.range() : super.range();
    }

    @Override
    final NumberRange<?> range(IntSupplier indices, int count) {
        return this.base.range(() -> this.toBase(indices.getAsInt()), count);
    }

    @Override
    public final Number set(int index, Number value) {
        throw new UnsupportedOperationException(Errors.format((short)25, value));
    }

    @Override
    public int[] repetitions(int ... candidates) {
        if (this.cycleLength * this.occurrences >= this.size) {
            return new int[]{this.occurrences};
        }
        return new int[]{this.occurrences, this.cycleLength};
    }

    @Override
    public Vector repeat(boolean eachValue, int count) {
        block2: {
            int n;
            block4: {
                block3: {
                    if (count <= 1 || this.cycleLength * this.occurrences < this.size) break block2;
                    if (!eachValue) break block3;
                    if (this.cycleLength < this.base.size()) break block2;
                    n = this.occurrences;
                    break block4;
                }
                if (this.occurrences != 1) break block2;
                n = this.cycleLength;
            }
            return this.base.repeat(eachValue, Math.multiplyExact(n, count));
        }
        return super.repeat(eachValue, count);
    }

    @Override
    public final Number increment(double tolerance) {
        return null;
    }

    @Override
    public Vector compress(double tolerance) {
        return this;
    }

    @Override
    final Vector backingVector() {
        return this.base;
    }

    @Override
    final int[] toBacking(int[] indices) {
        indices = (int[])indices.clone();
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = this.toBase(indices[i]);
        }
        return indices;
    }

    @Override
    Vector createSubSampling(int first, int step, int length) {
        if (step % this.occurrences == 0) {
            int bs = step / this.occurrences;
            int lower = first / this.occurrences;
            int upper = lower + (length - 1) * bs;
            if (lower >= 0 && lower <= upper && upper < this.base.size() && lower / this.cycleLength == upper / this.cycleLength) {
                return this.base.subSampling(lower, bs, length);
            }
        }
        if (first < this.occurrences && this.occurrences % step == 0) {
            return new RepeatedVector(this.base, this.occurrences / step, this.cycleLength, length);
        }
        return super.createSubSampling(first, step, length);
    }
}

