/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.rest.codec.param;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.swagger.models.parameters.CookieParameter;
import io.swagger.models.parameters.Parameter;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.core.Response;
import java.lang.reflect.Type;
import java.util.Objects;
import org.apache.servicecomb.common.rest.codec.RestClientRequest;
import org.apache.servicecomb.common.rest.codec.RestObjectMapperFactory;
import org.apache.servicecomb.common.rest.codec.param.AbstractParamProcessor;
import org.apache.servicecomb.common.rest.codec.param.ParamValueProcessor;
import org.apache.servicecomb.common.rest.codec.param.ParamValueProcessorCreator;
import org.apache.servicecomb.common.rest.codec.param.ParamValueProcessorCreatorManager;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;

public class CookieProcessorCreator
implements ParamValueProcessorCreator {
    public static final String PARAMTYPE = "cookie";

    public CookieProcessorCreator() {
        ParamValueProcessorCreatorManager.INSTANCE.register(PARAMTYPE, this);
    }

    @Override
    public ParamValueProcessor create(Parameter parameter, Type genericParamType) {
        JavaType targetType = genericParamType == null ? null : TypeFactory.defaultInstance().constructType(genericParamType);
        return new CookieProcessor(parameter.getName(), targetType, ((CookieParameter)parameter).getDefaultValue(), parameter.getRequired());
    }

    public static class CookieProcessor
    extends AbstractParamProcessor {
        public CookieProcessor(String paramPath, JavaType targetType, Object defaultValue, boolean required) {
            super(paramPath, targetType, defaultValue, required);
        }

        @Override
        public Object getValue(HttpServletRequest request) {
            Cookie[] cookies = request.getCookies();
            Object value = null;
            if (cookies == null || cookies.length == 0) {
                value = this.checkRequiredAndDefaultValue();
                return this.convertValue(value, this.targetType);
            }
            for (Cookie cookie : cookies) {
                if (!Objects.equals(this.paramPath, cookie.getName())) continue;
                value = cookie.getValue();
                break;
            }
            if (value == null) {
                value = this.checkRequiredAndDefaultValue();
            }
            return this.convertValue(value, this.targetType);
        }

        private Object checkRequiredAndDefaultValue() {
            if (this.isRequired()) {
                throw new InvocationException((Response.StatusType)Response.Status.BAD_REQUEST, "Parameter is required.");
            }
            return this.getDefaultValue();
        }

        @Override
        public void setValue(RestClientRequest clientRequest, Object arg) throws Exception {
            clientRequest.addCookie(this.paramPath, RestObjectMapperFactory.getConsumerWriterMapper().convertToString(arg));
        }

        @Override
        public String getProcessorType() {
            return CookieProcessorCreator.PARAMTYPE;
        }
    }
}

