/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.google.gson.JsonObject;
import com.microsoft.playwright.APIRequest;
import com.microsoft.playwright.Playwright;
import com.microsoft.playwright.PlaywrightException;
import com.microsoft.playwright.Selectors;
import com.microsoft.playwright.impl.APIRequestImpl;
import com.microsoft.playwright.impl.BrowserTypeImpl;
import com.microsoft.playwright.impl.ChannelOwner;
import com.microsoft.playwright.impl.Connection;
import com.microsoft.playwright.impl.Driver;
import com.microsoft.playwright.impl.LocalUtils;
import com.microsoft.playwright.impl.PipeTransport;
import com.microsoft.playwright.impl.SelectorsImpl;
import com.microsoft.playwright.impl.SharedSelectors;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class PlaywrightImpl
extends ChannelOwner
implements Playwright {
    private Process driverProcess;
    private final BrowserTypeImpl chromium;
    private final BrowserTypeImpl firefox;
    private final BrowserTypeImpl webkit;
    private final SelectorsImpl selectors;
    private final APIRequestImpl apiRequest;
    private final LocalUtils localUtils;
    private SharedSelectors sharedSelectors;

    public static PlaywrightImpl create(Playwright.CreateOptions options) {
        try {
            Map<Object, Object> env = Collections.emptyMap();
            if (options != null && options.env != null) {
                env = options.env;
            }
            Path driver = Driver.ensureDriverInstalled(env, (Boolean)true);
            ProcessBuilder pb = new ProcessBuilder(driver.toString(), "run-driver");
            pb.redirectError(ProcessBuilder.Redirect.INHERIT);
            pb.environment().putAll(env);
            Driver.setRequiredEnvironmentVariables((ProcessBuilder)pb);
            Process p = pb.start();
            Connection connection = new Connection(new PipeTransport(p.getInputStream(), p.getOutputStream()));
            PlaywrightImpl result = connection.initializePlaywright();
            result.driverProcess = p;
            result.initSharedSelectors(null);
            return result;
        }
        catch (IOException e) {
            throw new PlaywrightException("Failed to launch driver", e);
        }
    }

    PlaywrightImpl(ChannelOwner parent, String type, String guid, JsonObject initializer) {
        super(parent, type, guid, initializer);
        this.chromium = (BrowserTypeImpl)parent.connection.getExistingObject(initializer.getAsJsonObject("chromium").get("guid").getAsString());
        this.firefox = (BrowserTypeImpl)parent.connection.getExistingObject(initializer.getAsJsonObject("firefox").get("guid").getAsString());
        this.webkit = (BrowserTypeImpl)parent.connection.getExistingObject(initializer.getAsJsonObject("webkit").get("guid").getAsString());
        this.selectors = (SelectorsImpl)this.connection.getExistingObject(initializer.getAsJsonObject("selectors").get("guid").getAsString());
        this.apiRequest = new APIRequestImpl(this);
        this.chromium.localUtils = this.localUtils = (LocalUtils)this.connection.getExistingObject(initializer.getAsJsonObject("utils").get("guid").getAsString());
        this.firefox.localUtils = this.localUtils;
        this.webkit.localUtils = this.localUtils;
    }

    void initSharedSelectors(PlaywrightImpl parent) {
        assert (this.sharedSelectors == null);
        this.sharedSelectors = parent == null ? new SharedSelectors() : parent.sharedSelectors;
        this.sharedSelectors.addChannel(this.selectors);
    }

    void unregisterSelectors() {
        this.sharedSelectors.removeChannel(this.selectors);
    }

    @Override
    public BrowserTypeImpl chromium() {
        return this.chromium;
    }

    @Override
    public BrowserTypeImpl firefox() {
        return this.firefox;
    }

    @Override
    public APIRequest request() {
        return this.apiRequest;
    }

    @Override
    public BrowserTypeImpl webkit() {
        return this.webkit;
    }

    @Override
    public Selectors selectors() {
        return this.sharedSelectors;
    }

    @Override
    public void close() {
        try {
            this.connection.close();
            boolean didClose = this.driverProcess.waitFor(30L, TimeUnit.SECONDS);
            if (!didClose) {
                System.err.println("WARNING: Timed out while waiting for driver process to exit");
            }
        }
        catch (IOException e) {
            throw new PlaywrightException("Failed to terminate", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PlaywrightException("Operation interrupted", e);
        }
    }
}

