/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.config;

import flash.localization.LocalizationManager;
import flex2.compiler.config.ConfigurationBuffer;
import flex2.compiler.config.ConfigurationException;
import flex2.compiler.config.ConfigurationInfo;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class CommandLineConfigurator {
    public static final String SOURCE_COMMAND_LINE = "command line";
    public static final String source = "command line";

    public static void parse(ConfigurationBuffer buffer, String defaultvar, String[] args) throws ConfigurationException {
        assert (defaultvar == null || buffer.isValidVar(defaultvar)) : "coding error: config must provide default var " + defaultvar;
        Map<String, String> aliases = CommandLineConfigurator.getAliases(buffer);
        boolean START = true;
        int ARGS = 2;
        int EXEC = 3;
        int DONE = 4;
        int i = 0;
        int iStart = 0;
        int iEnd = 0;
        String var = null;
        int varArgCount = -2;
        LinkedList<String> argList = new LinkedList<String>();
        HashSet<String> vars = new HashSet<String>();
        boolean append = false;
        boolean dash = true;
        int mode = 1;
        block6: while (mode != 4) {
            switch (mode) {
                case 1: {
                    String rest;
                    int equals;
                    iStart = i;
                    if (args.length == i) {
                        mode = 4;
                        break;
                    }
                    mode = 2;
                    varArgCount = -2;
                    if (args[i].equals("--")) {
                        dash = false;
                        if (defaultvar != null) {
                            var = defaultvar;
                        } else {
                            mode = 1;
                        }
                        ++i;
                        break;
                    }
                    if (dash && args[i].startsWith("+")) {
                        String token = null;
                        int c = args[i].length() > 1 && args[i].charAt(1) == '+' ? 2 : 1;
                        equals = args[i].indexOf(61);
                        rest = null;
                        if (equals != -1) {
                            rest = args[i].substring(equals + 1);
                            token = args[i++].substring(c, equals);
                        } else {
                            token = args[i++].substring(c);
                        }
                        if (equals != -1) {
                            iEnd = i;
                            buffer.setToken(token, rest);
                            buffer.addPosition(token, iStart, iEnd);
                        } else {
                            if (i == args.length) {
                                throw new ConfigurationException.Token("InsufficientArgs", token, var, "command line", -1);
                            }
                            rest = args[i++];
                            iEnd = i;
                            buffer.setToken(token, rest);
                            buffer.addPosition(token, iStart, iEnd);
                        }
                        mode = 1;
                        break;
                    }
                    if (dash && CommandLineConfigurator.isAnArgument(args[i])) {
                        int c = args[i].length() > 1 && args[i].charAt(1) == '-' ? 2 : 1;
                        int plusequals = args[i].indexOf("+=");
                        equals = args[i].indexOf(61);
                        rest = null;
                        if (plusequals != -1) {
                            rest = args[i].substring(plusequals + 2);
                            var = args[i++].substring(c, plusequals);
                            append = true;
                        } else if (equals != -1) {
                            rest = args[i].substring(equals + 1);
                            var = args[i++].substring(c, equals);
                        } else {
                            var = args[i++].substring(c);
                        }
                        if (aliases.containsKey(var)) {
                            var = aliases.get(var);
                        }
                        if (!buffer.isValidVar(var)) {
                            throw new ConfigurationException.UnknownVariable(var, "command line", -1);
                        }
                        if (equals == -1) continue block6;
                        if (rest == null || rest.length() == 0) {
                            iEnd = i;
                            buffer.clearVar(var, "command line", -1);
                            buffer.addPosition(var, iStart, iEnd);
                            mode = 1;
                            break;
                        }
                        Object seps = null;
                        seps = buffer.getInfo(var).isPath() ? "[," + File.pathSeparatorChar + "]" : ",";
                        String[] tokens = rest.split((String)seps);
                        argList.addAll(Arrays.asList(tokens));
                        varArgCount = buffer.getVarArgCount(var);
                        mode = 3;
                        break;
                    }
                    if (defaultvar != null && !defaultvar.equals("no-default-arg")) {
                        var = defaultvar;
                        break;
                    }
                    throw new ConfigurationException.UnexpectedDefaults(null, null, -1);
                }
                case 2: {
                    if (varArgCount == -2) {
                        if (CommandLineConfigurator.isBoolean(buffer, var)) {
                            varArgCount = 0;
                            mode = 3;
                            break;
                        }
                        varArgCount = buffer.getVarArgCount(var);
                    }
                    assert (varArgCount >= -1);
                    if (args.length == i) {
                        mode = 3;
                        break;
                    }
                    boolean greedy = buffer.getInfo(var).isGreedy();
                    if (!greedy && dash && CommandLineConfigurator.isAnArgument(args[i])) {
                        if (varArgCount == -1) {
                            mode = 3;
                            break;
                        }
                        throw new ConfigurationException.IncorrectArgumentCount(varArgCount, argList.size(), var, "command line", -1);
                    }
                    if (!(varArgCount != -1 || greedy || defaultvar == null || defaultvar.equals(var) || vars.contains(defaultvar) || args.length - i <= 1 || buffer.getInfo(defaultvar) == null)) {
                        boolean ok = false;
                        for (int j = i + 1; j < args.length; ++j) {
                            if (!dash || !CommandLineConfigurator.isAnArgument(args[j])) continue;
                            ok = true;
                            break;
                        }
                        if (!ok) {
                            throw new ConfigurationException.AmbiguousParse(defaultvar, var, "command line", -1);
                        }
                    }
                    argList.add(args[i++]);
                    if (argList.size() != varArgCount) break;
                    mode = 3;
                    break;
                }
                case 3: {
                    if (varArgCount != -1 && argList.size() != varArgCount) {
                        throw new ConfigurationException.IncorrectArgumentCount(varArgCount, argList.size(), var, "command line", -1);
                    }
                    if (varArgCount == 0) {
                        argList.add("true");
                    }
                    if (vars.contains(var) && defaultvar != null && var != null && var.equals(defaultvar)) {
                        throw new ConfigurationException.InterspersedDefaults(var, "command line", -1);
                    }
                    iEnd = i;
                    buffer.setVar(var, new LinkedList<String>(argList), "command line", -1, null, append);
                    buffer.addPosition(var, iStart, iEnd);
                    append = false;
                    vars.add(var);
                    argList.clear();
                    mode = 1;
                    break;
                }
                case 4: {
                    assert (false);
                    break;
                }
            }
        }
    }

    private static boolean isAnArgument(String arg) {
        return arg.startsWith("-") && arg.length() > 1 && !Character.isDigit(arg.charAt(1));
    }

    private static Map<String, String> getAliases(ConfigurationBuffer buffer) {
        HashMap<String, String> aliases = new HashMap<String, String>();
        aliases.putAll(buffer.getAliases());
        Iterator<String> it = buffer.getVarIterator();
        while (it.hasNext()) {
            String leafname;
            String varname = it.next();
            if (varname.indexOf(46) == -1 || aliases.containsKey(leafname = varname.substring(varname.lastIndexOf(46) + 1))) continue;
            aliases.put(leafname, varname);
        }
        return aliases;
    }

    private static boolean isBoolean(ConfigurationBuffer buffer, String var) {
        ConfigurationInfo info = buffer.getInfo(var);
        if (info.getArgCount() > 1) {
            return false;
        }
        Class c = info.getArgType(0);
        return c == Boolean.TYPE || c == Boolean.class;
    }

    public static String brief(String program, String defaultvar, LocalizationManager l10n, String l10nPrefix) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("defaultVar", defaultvar);
        params.put("program", program);
        return l10n.getLocalizedTextString(l10nPrefix + ".Brief", params);
    }

    public static String usage(String program, String defaultVar, ConfigurationBuffer cfgbuf, Set<String> keywords, LocalizationManager lmgr, String l10nPrefix) {
        ConfigurationInfo info;
        String var;
        Map<String, String> aliases = CommandLineConfigurator.getAliases(cfgbuf);
        HashMap<String, String> sesaila = new HashMap<String, String>();
        for (Map.Entry<String, String> e : aliases.entrySet()) {
            sesaila.put(e.getValue(), e.getKey());
        }
        TreeSet<String> printSet = new TreeSet<String>();
        boolean all = false;
        boolean advanced = false;
        boolean details = false;
        boolean syntax = false;
        boolean printaliases = false;
        HashSet<String> newSet = new HashSet<String>();
        for (String keyword : keywords) {
            if (keyword.equals("list")) {
                all = true;
                newSet.add("*");
                continue;
            }
            if (keyword.equals("advanced")) {
                advanced = true;
                if (keywords.size() != 1) continue;
                all = true;
                newSet.add("*");
                continue;
            }
            if (keyword.equals("details")) {
                details = true;
                continue;
            }
            if (keyword.equals("syntax")) {
                syntax = true;
                continue;
            }
            if (keyword.equals("aliases")) {
                printaliases = true;
                continue;
            }
            details = true;
            newSet.add(keyword);
        }
        if (syntax) {
            List<String> lines = ConfigurationBuffer.formatText(CommandLineConfigurator.getSyntaxDescription(program, defaultVar, advanced, lmgr, l10nPrefix), 78);
            StringBuilder text = new StringBuilder(512);
            Iterator<String> it = lines.iterator();
            while (it.hasNext()) {
                text.append((Object)it.next());
                text.append("\n");
            }
            return text.toString();
        }
        keywords = newSet;
        Iterator<String> kit = keywords.iterator();
        while (kit.hasNext()) {
            String keyword;
            keyword = kit.next().toLowerCase();
            Iterator<String> varit = cfgbuf.getVarIterator();
            while (varit.hasNext()) {
                var = varit.next();
                info = cfgbuf.getInfo(var);
                String description = CommandLineConfigurator.getDescription(cfgbuf, var, lmgr, l10nPrefix);
                if (!all && var.indexOf(keyword) == -1 && (description == null || description.toLowerCase().indexOf(keyword) == -1) && !keyword.matches(var) && (sesaila.get(var) == null || ((String)sesaila.get(var)).indexOf(keyword) == -1) || info.isHidden() || !advanced && info.isAdvanced()) continue;
                if (printaliases && sesaila.containsKey(var)) {
                    printSet.add((String)sesaila.get(var));
                    continue;
                }
                printSet.add(var);
            }
        }
        StringBuilder output = new StringBuilder(1024);
        if (printSet.size() == 0) {
            String nkm = lmgr.getLocalizedTextString(l10nPrefix + ".NoKeywordsMatched");
            output.append(nkm);
            output.append("\n");
        } else {
            Iterator it = printSet.iterator();
            while (it.hasNext()) {
                String avar;
                var = avar = (String)it.next();
                if (aliases.containsKey(avar)) {
                    var = aliases.get(avar);
                }
                info = cfgbuf.getInfo(var);
                assert (info != null);
                output.append("-");
                output.append(avar);
                int count = cfgbuf.getVarArgCount(var);
                if (count >= 1 && !CommandLineConfigurator.isBoolean(cfgbuf, var)) {
                    for (int i = 0; i < count; ++i) {
                        output.append(" <");
                        output.append(cfgbuf.getVarArgName(var, i));
                        output.append(">");
                    }
                } else if (count == -1) {
                    String last = "";
                    for (int i = 0; i < 5; ++i) {
                        String argname = cfgbuf.getVarArgName(var, i);
                        if (argname.equals(last)) {
                            output.append(" [...]");
                            break;
                        }
                        output.append(" [");
                        output.append(argname);
                        output.append("]");
                        last = argname;
                    }
                }
                output.append("\n");
                if (!details) continue;
                StringBuilder description = new StringBuilder(160);
                if (printaliases) {
                    if (aliases.containsKey(avar)) {
                        String fullname = lmgr.getLocalizedTextString(l10nPrefix + ".FullName");
                        description.append(fullname);
                        description.append(" -");
                        description.append(aliases.get(avar));
                        description.append("\n");
                    }
                } else if (sesaila.containsKey(var)) {
                    String alias = lmgr.getLocalizedTextString(l10nPrefix + ".Alias");
                    description.append(alias);
                    description.append(" -");
                    description.append((String)sesaila.get(var));
                    description.append("\n");
                }
                String d = CommandLineConfigurator.getDescription(cfgbuf, var, lmgr, l10nPrefix);
                if (var.equals("help") && printSet.size() > 2) {
                    String helpKeywords = lmgr.getLocalizedTextString(l10nPrefix + ".HelpKeywords");
                    description.append(helpKeywords);
                } else if (d != null) {
                    description.append(d);
                }
                Object flags = "";
                if (info.isAdvanced()) {
                    String advancedString = lmgr.getLocalizedTextString(l10nPrefix + ".Advanced");
                    flags = (String)flags + (((String)flags).length() == 0 ? " (" : ", ") + advancedString;
                }
                if (info.allowMultiple()) {
                    String repeatableString = lmgr.getLocalizedTextString(l10nPrefix + ".Repeatable");
                    flags = (String)flags + (((String)flags).length() == 0 ? " (" : ", ") + repeatableString;
                }
                if (defaultVar != null && var.equals(defaultVar)) {
                    String defaultString = lmgr.getLocalizedTextString(l10nPrefix + ".Default");
                    flags = (String)flags + (((String)flags).length() == 0 ? " (" : ", ") + defaultString;
                }
                if (((String)flags).length() != 0) {
                    flags = (String)flags + ")";
                }
                description.append((String)flags);
                List<String> descriptionLines = ConfigurationBuffer.formatText(description.toString(), 70);
                Iterator<String> descit = descriptionLines.iterator();
                while (descit.hasNext()) {
                    output.append("    ");
                    output.append(descit.next());
                    output.append("\n");
                }
            }
        }
        return output.toString();
    }

    public static String getDescription(ConfigurationBuffer buffer, String var, LocalizationManager l10n, String l10nPrefix) {
        String key = l10nPrefix == null ? var : l10nPrefix + "." + var;
        String description = l10n.getLocalizedTextString(key, null);
        return description;
    }

    public static String getSyntaxDescription(String program, String defaultVar, boolean advanced, LocalizationManager l10n, String l10nPrefix) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("defaultVar", defaultVar);
        params.put("program", program);
        String key = l10nPrefix + "." + (advanced ? "AdvancedSyntax" : "Syntax");
        String text = l10n.getLocalizedTextString(key, params);
        if (text == null) {
            text = "No syntax help available, try '-help list' to list available configuration variables.";
            assert (false) : "Localized text for syntax description not found!";
        }
        return text;
    }
}

