/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.mxml;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.royale.compiler.common.XMLName;
import org.apache.royale.compiler.config.CompilerDiagnosticsConstants;
import org.apache.royale.compiler.filespecs.IFileSpecification;
import org.apache.royale.compiler.internal.projects.RoyaleProject;
import org.apache.royale.compiler.mxml.IMXMLManifestManager;
import org.apache.royale.compiler.mxml.IMXMLNamespaceMapping;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.problems.ManifestInconsistentComponentEntriesProblem;
import org.apache.royale.compiler.problems.ManifestParsingProblem;
import org.apache.royale.swc.ISWC;
import org.apache.royale.swc.ISWCComponent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MXMLManifestManager
implements IMXMLManifestManager {
    private Map<XMLName, ClassInfo> lookupMap = new HashMap<XMLName, ClassInfo>();
    private Map<XMLName, String> lookupOnlyMap = new HashMap<XMLName, String>();
    private SetMultimap<String, XMLName> reverseLookupMap = HashMultimap.create();
    private Collection<ICompilerProblem> problems = new ArrayList<ICompilerProblem>();

    static String getClassName(ClassInfo classInfo) {
        return classInfo != null ? classInfo.className : null;
    }

    public MXMLManifestManager(RoyaleProject project) {
        for (ISWC swc : project.getLibraries()) {
            this.addSWC(swc);
        }
        for (IMXMLNamespaceMapping namespaceMapping : project.getNamespaceMappings()) {
            this.addManifest(project, namespaceMapping.getURI(), namespaceMapping.getManifestFileName());
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        TreeSet<XMLName> keys = new TreeSet<XMLName>(this.lookupMap.keySet());
        for (XMLName key : keys) {
            sb.append(key);
            sb.append(" -> ");
            sb.append(this.lookupMap.get(key));
            sb.append(", lookupOnly = ");
            sb.append(this.isLookupOnly(key));
            sb.append('\n');
        }
        return sb.toString();
    }

    @Override
    public String resolve(XMLName tagName) {
        return MXMLManifestManager.getClassName(this.lookupMap.get(tagName));
    }

    @Override
    public boolean isLookupOnly(XMLName tagName) {
        return this.lookupOnlyMap.get(tagName) != null;
    }

    @Override
    public Collection<XMLName> getTagNamesForClass(String className) {
        Set result = this.reverseLookupMap.get((Object)className);
        if (result == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableCollection(result);
    }

    @Override
    public Collection<String> getQualifiedNamesForNamespaces(Set<String> namespaceURIs, boolean manifestEntriesOnly) {
        HashSet<String> qualifiedNames = new HashSet<String>();
        for (Map.Entry<XMLName, ClassInfo> entry : this.lookupMap.entrySet()) {
            ClassInfo classInfo;
            if (!namespaceURIs.contains(entry.getKey().getXMLNamespace()) || (classInfo = entry.getValue()) == null || manifestEntriesOnly && (!manifestEntriesOnly || !classInfo.fromManifest)) continue;
            qualifiedNames.add(classInfo.className);
        }
        return qualifiedNames;
    }

    private void addSWC(ISWC swc) {
        File swcFile = swc.getSWCFile();
        for (ISWCComponent component : swc.getComponents()) {
            String uri = component.getURI();
            String name = component.getName();
            XMLName tagName = new XMLName(uri, name);
            String qname = component.getQName();
            this.add(tagName, qname, uri, swcFile.getAbsolutePath(), false);
        }
    }

    private void addManifest(RoyaleProject project, String uri, String manifestFileName) {
        Document manifestDocument = null;
        if ((CompilerDiagnosticsConstants.diagnostics & 0x100) == 256) {
            System.out.println("MXMLManifestManager waiting for lock in addManifest");
        }
        IFileSpecification manifestFileSpec = project.getWorkspace().getFileSpecification(manifestFileName);
        if ((CompilerDiagnosticsConstants.diagnostics & 0x100) == 256) {
            System.out.println("MXMLManifestManager done with lock in addManifest");
        }
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setIgnoringElementContentWhitespace(true);
            documentBuilderFactory.setCoalescing(true);
            documentBuilderFactory.setIgnoringComments(true);
            manifestDocument = documentBuilderFactory.newDocumentBuilder().parse(new InputSource(manifestFileSpec.createReader()));
        }
        catch (SAXException e) {
            ManifestParsingProblem problem = new ManifestParsingProblem(e.getMessage(), uri, manifestFileName);
            this.problems.add(problem);
            return;
        }
        catch (Exception e) {
            ManifestParsingProblem problem = new ManifestParsingProblem("Unknown parsing problem", uri, manifestFileName);
            this.problems.add(problem);
            return;
        }
        if (manifestDocument != null) {
            NodeList components = manifestDocument.getElementsByTagName("component");
            for (int i = 0; i < components.getLength(); ++i) {
                String lookupOnlyStr;
                boolean lookupOnly;
                int lastDot;
                Element component = (Element)components.item(i);
                if (component == null) continue;
                String id = component.getAttribute("id");
                if (id != null && (lastDot = id.lastIndexOf(".")) != -1) {
                    id = id.substring(lastDot + 1);
                }
                XMLName tagName = new XMLName(uri, id);
                String className = component.getAttribute("class");
                if (className != null) {
                    className = className.replaceAll("/", ".");
                }
                boolean bl = lookupOnly = (lookupOnlyStr = component.getAttribute("lookupOnly")) == null ? false : Boolean.valueOf(lookupOnlyStr);
                if (id == null || className == null) continue;
                this.add(tagName, className, uri, manifestFileName, true);
                if (!lookupOnly) continue;
                this.addLookupOnly(tagName, className);
            }
        }
    }

    private void add(XMLName tagName, String className, String uri, String fileName, boolean fromManifest) {
        String oldClassName;
        if (!this.lookupMap.containsKey(tagName)) {
            this.lookupMap.put(tagName, new ClassInfo(className, fromManifest));
            this.reverseLookupMap.put((Object)className, (Object)tagName);
            return;
        }
        ClassInfo classInfo = this.lookupMap.get(tagName);
        if (fromManifest) {
            boolean wasFromManifest = classInfo.fromManifest;
            classInfo.fromManifest = true;
            if (!wasFromManifest) {
                classInfo.className = className;
                return;
            }
        }
        if (className.equals(oldClassName = MXMLManifestManager.getClassName(this.lookupMap.get(tagName)))) {
            return;
        }
        this.lookupMap.put(tagName, null);
        this.reverseLookupMap.remove((Object)oldClassName, (Object)tagName);
        ManifestInconsistentComponentEntriesProblem problem = new ManifestInconsistentComponentEntriesProblem(tagName.getName(), uri, fileName);
        this.problems.add(problem);
    }

    private void addLookupOnly(XMLName tagName, String className) {
        if (!this.lookupOnlyMap.containsKey(tagName)) {
            this.lookupOnlyMap.put(tagName, className);
        }
    }

    @Override
    public void collectProblems(Collection<ICompilerProblem> problems) {
        problems.addAll(this.getProblems());
    }

    public Collection<ICompilerProblem> getProblems() {
        return this.problems;
    }

    private static class ClassInfo {
        public String className;
        public boolean fromManifest;

        ClassInfo(String className, boolean fromManifest) {
            this.className = className;
            this.fromManifest = fromManifest;
        }
    }
}

