/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.parsing.parser.util;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.javascript.jscomp.parsing.parser.SourceFile;
import com.google.javascript.jscomp.parsing.parser.util.format.SimpleFormat;

public class SourcePosition {
    public final SourceFile source;
    public final int offset;
    public final int line;
    public final int column;

    public SourcePosition(SourceFile source, int offset, int line, int column) {
        this.source = source;
        this.offset = offset;
        this.line = line;
        this.column = column;
    }

    public String toString() {
        return SimpleFormat.format("%s(%d, %d)", this.shortSourceName(), this.line + 1, this.column + 1);
    }

    private String shortSourceName() {
        if (this.source == null) {
            return "";
        }
        return Iterables.getLast(Splitter.on('/').split(this.source.name));
    }
}

