/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.as;

import org.apache.royale.compiler.internal.parsing.as.ASToken;
import org.apache.royale.compiler.internal.tree.as.ContainerNode;
import org.apache.royale.compiler.internal.tree.as.ExpressionNodeBase;
import org.apache.royale.compiler.internal.tree.as.LiteralNode;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IContainerNode;
import org.apache.royale.compiler.tree.as.ILiteralContainerNode;
import org.apache.royale.compiler.tree.as.ILiteralNode;

public abstract class BaseLiteralContainerNode
extends ExpressionNodeBase
implements ILiteralContainerNode {
    protected LiteralNode baseTypeNode;
    protected ContainerNode contentsNode;

    public BaseLiteralContainerNode(LiteralNode baseTypeNode) {
        this.baseTypeNode = baseTypeNode;
        baseTypeNode.setParent(this);
        this.contentsNode = new ContainerNode();
        switch (baseTypeNode.getLiteralType()) {
            case ARRAY: {
                this.contentsNode.setContainerType(IContainerNode.ContainerType.BRACKETS);
                break;
            }
            case OBJECT: 
            case VECTOR: {
                this.contentsNode.setContainerType(IContainerNode.ContainerType.BRACES);
            }
        }
    }

    protected BaseLiteralContainerNode(BaseLiteralContainerNode other) {
        super(other);
    }

    @Override
    public int getChildCount() {
        return this.contentsNode != null ? 1 : 0;
    }

    @Override
    public IASNode getChild(int i) {
        return i == 0 ? this.contentsNode : null;
    }

    @Override
    protected void setChildren(boolean fillInOffsets) {
        if (this.contentsNode != null) {
            this.contentsNode.setParent(this);
        }
    }

    @Override
    public boolean isTerminal() {
        return true;
    }

    @Override
    public String getValue() {
        return this.getValue(false);
    }

    @Override
    public String getValue(boolean rawValue) {
        StringBuilder builder = new StringBuilder();
        int length = this.getContentsNode().getChildCount();
        for (int i = 0; i < length; ++i) {
            IASNode child = this.getContentsNode().getChild(i);
            if (!(child instanceof ILiteralNode)) continue;
            builder.append(((ILiteralNode)child).getValue(rawValue));
        }
        return builder.toString();
    }

    @Override
    public LiteralNode getBaseTypeNode() {
        return this.baseTypeNode;
    }

    @Override
    public ContainerNode getContentsNode() {
        return this.contentsNode;
    }

    public final void appendLiteralToken(ASToken token) {
        IASNode lastLiteralNode;
        assert (token != null && token.isE4X()) : "unexpected token: " + token;
        ContainerNode contents = this.getContentsNode();
        int size = contents.getChildCount();
        if (size > 0 && (lastLiteralNode = contents.getChild(size - 1)).getNodeID() == ASTNodeID.LiteralXMLID) {
            LiteralNode appendTarget = (LiteralNode)lastLiteralNode;
            if (!appendTarget.value.equals("<>")) {
                appendTarget.value = appendTarget.value.concat(token.getText());
                appendTarget.endAfter(token);
                return;
            }
        }
        LiteralNode newNode = new LiteralNode(token, ILiteralNode.LiteralType.XML);
        contents.addItem(newNode);
    }
}

