/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.bridges.struts.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rule;
import org.apache.portals.bridges.struts.config.AbstractConfigComponent;

public class PortletURLTypes
extends AbstractConfigComponent {
    private static final Comparator portletURLTypeComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            PortletURLType a1 = (PortletURLType)o1;
            PortletURLType a2 = (PortletURLType)o2;
            int lendiff = a1.getPath().length() - a2.getPath().length();
            if (lendiff == 0) {
                return a1.getPath().compareTo(a2.getPath());
            }
            if (lendiff > 0) {
                return -1;
            }
            return 1;
        }
    };
    private URLType defaultPortletURLType = URLType.RENDER;
    private PortletURLType[] portletURLTypes = new PortletURLType[0];
    private ArrayList portletURLTypeList;

    public void addActionType(PortletURLType portletURLType) {
        this.checkLoaded();
        portletURLType.setType(URLType.ACTION);
        this.portletURLTypeList.add(portletURLType);
    }

    public void addRenderType(PortletURLType portletURLType) {
        this.checkLoaded();
        portletURLType.setType(URLType.RENDER);
        this.portletURLTypeList.add(portletURLType);
    }

    public void addResourceType(PortletURLType portletURLType) {
        this.checkLoaded();
        portletURLType.setType(URLType.RESOURCE);
        this.portletURLTypeList.add(portletURLType);
    }

    public void setDefault(String value) {
        this.checkLoaded();
        this.defaultPortletURLType = "action".equals(value.toLowerCase()) ? URLType.ACTION : URLType.RENDER;
    }

    public void configure(Digester digester) {
        this.portletURLTypeList = new ArrayList();
        digester.addRule("config/portlet-url-type", (Rule)new AbstractConfigComponent.SetParentRule(this));
        digester.addSetProperties("config/portlet-url-type");
        digester.addObjectCreate("config/portlet-url-type/action", PortletURLType.class);
        digester.addSetProperties("config/portlet-url-type/action");
        digester.addSetNext("config/portlet-url-type/action", "addActionType");
        digester.addObjectCreate("config/portlet-url-type/render", PortletURLType.class);
        digester.addSetProperties("config/portlet-url-type/render");
        digester.addSetNext("config/portlet-url-type/render", "addRenderType");
        digester.addObjectCreate("config/portlet-url-type/resource", PortletURLType.class);
        digester.addSetProperties("config/portlet-url-type/resource");
        digester.addSetNext("config/portlet-url-type/resource", "addResourceType");
        digester.addCallMethod("config/portlet-url-type", "afterLoad");
    }

    public void afterLoad() {
        super.afterLoad();
        if (this.portletURLTypeList != null && this.portletURLTypeList.size() > 0) {
            this.portletURLTypes = new PortletURLType[this.portletURLTypeList.size()];
            for (int i = 0; i < this.portletURLTypes.length; ++i) {
                this.portletURLTypes[i] = (PortletURLType)this.portletURLTypeList.get(i);
            }
            if (this.portletURLTypes.length > 1) {
                Arrays.sort(this.portletURLTypes, portletURLTypeComparator);
            }
        }
        this.portletURLTypeList = null;
    }

    public URLType getType(String path) {
        URLType type = this.defaultPortletURLType;
        for (int i = 0; i < this.portletURLTypes.length; ++i) {
            if (!path.startsWith(this.portletURLTypes[i].path)) continue;
            type = this.portletURLTypes[i].getType();
            break;
        }
        return type;
    }

    public static class PortletURLType {
        private String path;
        private URLType type;

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public void setType(URLType type) {
            this.type = type;
        }

        public URLType getType() {
            return this.type;
        }

        public String toString() {
            return "PortletURLType: path=" + this.path + ", type=" + this.type;
        }
    }

    public static class URLType {
        public static final URLType ACTION = new URLType(0, "action");
        public static final URLType RENDER = new URLType(1, "render");
        public static final URLType RESOURCE = new URLType(2, "resource");
        private int id;
        private String name;

        private URLType(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(URLType type) {
            return type != null ? type.id == this.id : false;
        }
    }
}

