/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.bridges.struts;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.portals.bridges.struts.StrutsPortletErrorContext;

public class PortletServletResponseWrapper
extends HttpServletResponseWrapper {
    private static final Log log = LogFactory.getLog((Class)PortletServletResponseWrapper.class);
    private HttpServletRequest request;
    private boolean actionResponse;

    public PortletServletResponseWrapper(HttpServletRequest request, HttpServletResponse response) {
        super(response);
        this.request = request;
        this.actionResponse = request.getAttribute("org.apache.portals.bridges.struts.request_type").equals("ACTION");
    }

    public String encodeURL(String path) {
        if (this.actionResponse) {
            return path;
        }
        return super.encodeURL(path);
    }

    public String encodeRedirectURL(String path) {
        return path;
    }

    public String encodeUrl(String path) {
        if (this.actionResponse) {
            return path;
        }
        return super.encodeUrl(path);
    }

    public String encodeRedirectUrl(String path) {
        return path;
    }

    public void sendError(int errorCode, String errorMessage) throws IOException {
        StrutsPortletErrorContext errorContext = (StrutsPortletErrorContext)this.request.getAttribute("org.apache.portals.bridges.struts.error_context");
        if (errorContext == null) {
            errorContext = new StrutsPortletErrorContext();
            this.request.setAttribute("org.apache.portals.bridges.struts.error_context", (Object)errorContext);
        }
        errorContext.setErrorCode(errorCode);
        errorContext.setErrorMessage(errorMessage);
        errorContext.setError(null);
    }

    public void sendError(int errorCode) throws IOException {
        this.sendError(errorCode, null);
    }

    public void sendRedirect(String path) throws IOException {
        if (this.request.getAttribute("org.apache.portals.bridges.struts.redirect_url") != null) {
            return;
        }
        if (path.startsWith("http://") || path.startsWith("https://")) {
            this.request.setAttribute("org.apache.portals.bridges.struts.redirect_url", (Object)path);
        } else {
            String contextPath = this.request.getContextPath();
            if (path.startsWith(contextPath + "/")) {
                this.request.setAttribute("org.apache.portals.bridges.struts.redirect_page_url", (Object)path.substring(contextPath.length()));
            } else if (path.startsWith("/")) {
                this.request.setAttribute("org.apache.portals.bridges.struts.redirect_url", (Object)path);
            } else {
                this.request.setAttribute("org.apache.portals.bridges.struts.redirect_page_url", (Object)path);
            }
        }
    }
}

