/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.bridges.mapserver;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MapServerPortlet
extends GenericPortlet {
    private static final Log log = LogFactory.getLog((Class)MapServerPortlet.class);
    private static String MAPSERV_BINARY = "MapServBinary";
    private static String LAYERS = "Layers";
    private static String ZOOM_DIRECTION = "ZoomDirection";
    private static String ZOOM_SIZE = "ZoomSize";
    private static String MAP_FILE = "MapFile";
    private static String PROGRAM = "Program";
    private static String ROOT_URL = "RootURL";
    private static String MAP_WEB_IMAGE_PATH = "MapWebImagePath";
    private static String MAP_WEB_IMAGE_URL = "MapWebImageURL";
    private static String MAP_WEB_TEMPLATE = "MapWebTemplate";
    private String mapservBinary;
    private String layers;
    private String zoomDirection;
    private String zoomSize;
    private String mapFile;
    private String program;
    private String rootURL;
    private String mapWebImagePath;
    private String mapWebImageURL;
    private String mapWebTemplate;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.mapservBinary = config.getInitParameter(MAPSERV_BINARY);
        this.layers = config.getInitParameter(LAYERS);
        this.zoomDirection = config.getInitParameter(ZOOM_DIRECTION);
        this.zoomSize = config.getInitParameter(ZOOM_SIZE);
        this.mapFile = config.getInitParameter(MAP_FILE);
        this.program = config.getInitParameter(PROGRAM);
        this.rootURL = config.getInitParameter(ROOT_URL);
        this.mapWebImagePath = config.getInitParameter(MAP_WEB_IMAGE_PATH);
        this.mapWebImageURL = config.getInitParameter(MAP_WEB_IMAGE_URL);
        this.mapWebTemplate = config.getInitParameter(MAP_WEB_TEMPLATE);
        if (this.mapservBinary == null) {
            throw new PortletException("Portlet " + config.getPortletName() + " is incorrectly configured. Init parameter " + MAPSERV_BINARY + " not specified");
        }
        if (this.layers == null) {
            throw new PortletException("Portlet " + config.getPortletName() + " is incorrectly configured. Init parameter " + LAYERS + " not specified");
        }
        if (this.zoomDirection == null) {
            throw new PortletException("Portlet " + config.getPortletName() + " is incorrectly configured. Init parameter " + ZOOM_DIRECTION + " not specified");
        }
        if (this.zoomSize == null) {
            throw new PortletException("Portlet " + config.getPortletName() + " is incorrectly configured. Init parameter " + ZOOM_SIZE + " not specified");
        }
        if (this.mapFile == null) {
            throw new PortletException("Portlet " + config.getPortletName() + " is incorrectly configured. Init parameter " + MAP_FILE + " not specified");
        }
        if (this.program == null) {
            throw new PortletException("Portlet " + config.getPortletName() + " is incorrectly configured. Init parameter " + PROGRAM + " not specified");
        }
        if (this.rootURL == null) {
            throw new PortletException("Portlet " + config.getPortletName() + " is incorrectly configured. Init parameter " + ROOT_URL + " not specified");
        }
        if (this.mapWebImagePath == null) {
            throw new PortletException("Portlet " + config.getPortletName() + " is incorrectly configured. Init parameter " + MAP_WEB_IMAGE_PATH + " not specified");
        }
        if (this.mapWebImageURL == null) {
            throw new PortletException("Portlet " + config.getPortletName() + " is incorrectly configured. Init parameter " + MAP_WEB_IMAGE_URL + " not specified");
        }
        if (this.mapWebTemplate == null) {
            throw new PortletException("Portlet " + config.getPortletName() + " is incorrectly configured. Init parameter " + MAP_WEB_TEMPLATE + " not specified");
        }
    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException, IOException {
        Map parameterMap = actionRequest.getParameterMap();
        String queryString = ((HttpServletRequest)((HttpServletRequestWrapper)actionRequest).getRequest()).getQueryString();
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        response.setContentType("text/html");
        String command = this.mapservBinary + " QUERY_STRING='layer=" + this.layers + "&zoomdir=" + this.zoomDirection + "&zoomsize=" + this.zoomSize + "&map=" + this.mapFile + "&program=" + this.program + "&root=" + this.rootURL + "&map_web_imagepath=" + this.mapWebImagePath + "&map_web_imageurl=" + this.mapWebImageURL + "&map_web_template=" + this.mapWebTemplate + "'";
        String queryString = ((HttpServletRequest)((HttpServletRequestWrapper)request).getRequest()).getQueryString();
        System.out.println("QUERY_STRING : " + queryString);
        if (queryString != null) {
            command = this.mapservBinary + " QUERY_STRING=" + queryString;
        }
        System.out.println("COMMAND : " + command);
        Process proc = Runtime.getRuntime().exec(command);
        InputStream in = proc.getInputStream();
        InputStreamReader isr = new InputStreamReader(in, "UTF-8");
        BufferedReader perlResult = new BufferedReader(isr);
        StringBuffer page = new StringBuffer();
        boolean bProcDone = false;
        while (!bProcDone) {
            try {
                proc.exitValue();
                bProcDone = true;
            }
            catch (IllegalThreadStateException e) {
                int ln;
                bProcDone = false;
                while ((ln = perlResult.read()) != -1) {
                    char c = (char)ln;
                    if (c == '\n' || c == '\r') continue;
                    page.append((char)ln);
                }
            }
        }
        int ln = -1;
        while ((ln = perlResult.read()) != -1) {
            char c = (char)ln;
            if (c == '\n' || c == '\r') continue;
            page.append((char)ln);
        }
        perlResult.close();
        HttpServletResponse httpResponse = (HttpServletResponse)((HttpServletResponseWrapper)response).getResponse();
        PrintWriter writer = httpResponse.getWriter();
        writer.println(page.toString());
        writer.flush();
        writer.close();
    }
}

