/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.security.authorization.user;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.registry.security.authorization.user.NiFiUser;

public class StandardNiFiUser
implements NiFiUser {
    public static final String ANONYMOUS_IDENTITY = "anonymous";
    public static final StandardNiFiUser ANONYMOUS = new Builder().identity("anonymous").anonymous(true).build();
    private final String identity;
    private final Set<String> groups;
    private final NiFiUser chain;
    private final String clientAddress;
    private final boolean isAnonymous;

    private StandardNiFiUser(Builder builder) {
        this.identity = builder.identity;
        this.groups = builder.groups == null ? null : Collections.unmodifiableSet(builder.groups);
        this.chain = builder.chain;
        this.clientAddress = builder.clientAddress;
        this.isAnonymous = builder.isAnonymous;
    }

    public static StandardNiFiUser populateAnonymousUser(NiFiUser chain, String clientAddress) {
        return new Builder().identity(ANONYMOUS_IDENTITY).chain(chain).clientAddress(clientAddress).anonymous(true).build();
    }

    @Override
    public String getIdentity() {
        return this.identity;
    }

    @Override
    public Set<String> getGroups() {
        return this.groups;
    }

    @Override
    public NiFiUser getChain() {
        return this.chain;
    }

    @Override
    public boolean isAnonymous() {
        return this.isAnonymous;
    }

    @Override
    public String getClientAddress() {
        return this.clientAddress;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NiFiUser)) {
            return false;
        }
        NiFiUser other = (NiFiUser)obj;
        return Objects.equals(this.identity, other.getIdentity());
    }

    public int hashCode() {
        int hash = 7;
        hash = 53 * hash + Objects.hashCode(this.identity);
        return hash;
    }

    public String toString() {
        String formattedGroups = this.groups == null ? "none" : StringUtils.join(this.groups, (String)", ");
        return String.format("identity[%s], groups[%s]", this.getIdentity(), formattedGroups);
    }

    public static class Builder {
        private String identity;
        private Set<String> groups;
        private NiFiUser chain;
        private String clientAddress;
        private boolean isAnonymous = false;

        public Builder identity(String identity) {
            this.identity = identity;
            return this;
        }

        public Builder groups(Set<String> groups) {
            this.groups = groups;
            return this;
        }

        public Builder chain(NiFiUser chain) {
            this.chain = chain;
            return this;
        }

        public Builder clientAddress(String clientAddress) {
            this.clientAddress = clientAddress;
            return this;
        }

        private Builder anonymous(boolean isAnonymous) {
            this.isAnonymous = isAnonymous;
            return this;
        }

        public StandardNiFiUser build() {
            return new StandardNiFiUser(this);
        }
    }
}

