/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.util;

import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.function.Supplier;

public class CharDeduplication {
    static final char[][] ASCII_CHARS = new char[128][];
    public static final int TABLE_SIZE = 30;
    public static final int INTERNAL_TABLE_SIZE = 6;
    public static final int OPTIMIZED_LENGTH = 6;
    private static final char[] CHAR_ARRAY0;
    private static final ThreadLocal<CacheReference<CharDeduplication>> mutableCache;
    public final char[][][][] charArray_length = new char[5][30][6][];
    int newEntry2 = 0;
    int newEntry3 = 0;
    int newEntry4 = 0;
    int newEntry5 = 0;
    int newEntry6 = 0;

    static {
        int i = 0;
        while (i < ASCII_CHARS.length) {
            CharDeduplication.ASCII_CHARS[i] = new char[]{(char)i};
            ++i;
        }
        CHAR_ARRAY0 = new char[0];
        mutableCache = ThreadLocal.withInitial(() -> new CacheReference<CharDeduplication>(CharDeduplication::new));
    }

    private static final char[] optimizedCurrentTokenSource1(char[] source, int startPosition) {
        char charOne = source[startPosition];
        if (charOne < ASCII_CHARS.length) {
            return ASCII_CHARS[charOne];
        }
        return new char[]{charOne};
    }

    public static CharDeduplication getThreadLocalInstance() {
        return mutableCache.get().get();
    }

    private CharDeduplication() {
        this.init();
    }

    private void init() {
        int i = 0;
        while (i < 5) {
            char[] initCharArray = new char[i + 2];
            int j = 0;
            while (j < 30) {
                int k = 0;
                while (k < 6) {
                    this.charArray_length[i][j][k] = initCharArray;
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    @Deprecated
    public void reset() {
        this.init();
    }

    public char[] sharedCopyOfRange(char[] source, int from, int to) {
        int length = to - from;
        switch (length) {
            case 1: {
                return CharDeduplication.optimizedCurrentTokenSource1(source, from);
            }
            case 2: {
                return this.optimizedCurrentTokenSource2(source, from);
            }
            case 3: {
                return this.optimizedCurrentTokenSource3(source, from);
            }
            case 4: {
                return this.optimizedCurrentTokenSource4(source, from);
            }
            case 5: {
                return this.optimizedCurrentTokenSource5(source, from);
            }
            case 6: {
                return this.optimizedCurrentTokenSource6(source, from);
            }
            case 0: {
                return CHAR_ARRAY0;
            }
        }
        return Arrays.copyOfRange(source, from, to);
    }

    private final char[] optimizedCurrentTokenSource2(char[] source, int startPosition) {
        char[] src = source;
        int start = startPosition;
        char c0 = src[start];
        char c1 = src[start + 1];
        int hash = ((c0 << 6) + c1) % 30;
        char[][] table = this.charArray_length[0][hash];
        int i = this.newEntry2;
        while (++i < 6) {
            char[] charArray = table[i];
            if (c0 != charArray[0] || c1 != charArray[1]) continue;
            return charArray;
        }
        i = -1;
        int max = this.newEntry2;
        while (++i <= max) {
            char[] charArray = table[i];
            if (c0 != charArray[0] || c1 != charArray[1]) continue;
            return charArray;
        }
        if (++max >= 6) {
            max = 0;
        }
        char[] r = new char[2];
        System.arraycopy(src, start, r, 0, 2);
        this.newEntry2 = max;
        table[this.newEntry2] = r;
        return r;
    }

    private final char[] optimizedCurrentTokenSource3(char[] source, int startPosition) {
        char[] src = source;
        int start = startPosition;
        char c1 = src[start + 1];
        char c0 = src[start];
        char c2 = src[start + 2];
        int hash = ((c0 << 6) + c2) % 30;
        char[][] table = this.charArray_length[1][hash];
        int i = this.newEntry3;
        while (++i < 6) {
            char[] charArray = table[i];
            if (c0 != charArray[0] || c1 != charArray[1] || c2 != charArray[2]) continue;
            return charArray;
        }
        i = -1;
        int max = this.newEntry3;
        while (++i <= max) {
            char[] charArray = table[i];
            if (c0 != charArray[0] || c1 != charArray[1] || c2 != charArray[2]) continue;
            return charArray;
        }
        if (++max >= 6) {
            max = 0;
        }
        char[] r = new char[3];
        System.arraycopy(src, start, r, 0, 3);
        this.newEntry3 = max;
        table[this.newEntry3] = r;
        return r;
    }

    private final char[] optimizedCurrentTokenSource4(char[] source, int startPosition) {
        char[] src = source;
        int start = startPosition;
        char c1 = src[start + 1];
        char c3 = src[start + 3];
        char c0 = src[start];
        char c2 = src[start + 2];
        int hash = ((c0 << 6) + c2) % 30;
        char[][] table = this.charArray_length[2][hash];
        int i = this.newEntry4;
        while (++i < 6) {
            char[] charArray = table[i];
            if (c0 != charArray[0] || c1 != charArray[1] || c2 != charArray[2] || c3 != charArray[3]) continue;
            return charArray;
        }
        i = -1;
        int max = this.newEntry4;
        while (++i <= max) {
            char[] charArray = table[i];
            if (c0 != charArray[0] || c1 != charArray[1] || c2 != charArray[2] || c3 != charArray[3]) continue;
            return charArray;
        }
        if (++max >= 6) {
            max = 0;
        }
        char[] r = new char[4];
        System.arraycopy(src, start, r, 0, 4);
        this.newEntry4 = max;
        table[this.newEntry4] = r;
        return r;
    }

    private final char[] optimizedCurrentTokenSource5(char[] source, int startPosition) {
        char[] src = source;
        int start = startPosition;
        char c1 = src[start + 1];
        char c3 = src[start + 3];
        char c0 = src[start];
        char c2 = src[start + 2];
        char c4 = src[start + 4];
        int hash = ((c0 << 12) + (c2 << 6) + c4) % 30;
        char[][] table = this.charArray_length[3][hash];
        int i = this.newEntry5;
        while (++i < 6) {
            char[] charArray = table[i];
            if (c0 != charArray[0] || c1 != charArray[1] || c2 != charArray[2] || c3 != charArray[3] || c4 != charArray[4]) continue;
            return charArray;
        }
        i = -1;
        int max = this.newEntry5;
        while (++i <= max) {
            char[] charArray = table[i];
            if (c0 != charArray[0] || c1 != charArray[1] || c2 != charArray[2] || c3 != charArray[3] || c4 != charArray[4]) continue;
            return charArray;
        }
        if (++max >= 6) {
            max = 0;
        }
        char[] r = new char[5];
        System.arraycopy(src, start, r, 0, 5);
        this.newEntry5 = max;
        table[this.newEntry5] = r;
        return r;
    }

    private final char[] optimizedCurrentTokenSource6(char[] source, int startPosition) {
        char[] src = source;
        int start = startPosition;
        char c1 = src[start + 1];
        char c3 = src[start + 3];
        char c5 = src[start + 5];
        char c0 = src[start];
        char c2 = src[start + 2];
        char c4 = src[start + 4];
        int hash = ((c0 << 12) + (c2 << 6) + c4) % 30;
        char[][] table = this.charArray_length[4][hash];
        int i = this.newEntry6;
        while (++i < 6) {
            char[] charArray = table[i];
            if (c0 != charArray[0] || c1 != charArray[1] || c2 != charArray[2] || c3 != charArray[3] || c4 != charArray[4] || c5 != charArray[5]) continue;
            return charArray;
        }
        i = -1;
        int max = this.newEntry6;
        while (++i <= max) {
            char[] charArray = table[i];
            if (c0 != charArray[0] || c1 != charArray[1] || c2 != charArray[2] || c3 != charArray[3] || c4 != charArray[4] || c5 != charArray[5]) continue;
            return charArray;
        }
        if (++max >= 6) {
            max = 0;
        }
        char[] r = new char[6];
        System.arraycopy(src, start, r, 0, 6);
        this.newEntry6 = max;
        table[this.newEntry6] = r;
        return r;
    }

    static final class CacheReference<T> {
        private SoftReference<T> reference;
        private final Supplier<? extends T> supplier;

        CacheReference(Supplier<? extends T> supplier) {
            this.supplier = supplier;
            this.reference = new SoftReference<T>(supplier.get());
        }

        T get() {
            T referent = this.reference.get();
            if (referent == null) {
                referent = this.supplier.get();
                this.reference = new SoftReference<T>(referent);
            }
            return referent;
        }
    }
}

