/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openide.filesystems.declmime;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.openide.filesystems.declmime.DefaultParser;
import org.netbeans.modules.openide.filesystems.declmime.FileElement;
import org.netbeans.modules.openide.filesystems.declmime.MIMEResolverProcessor;
import org.netbeans.modules.openide.filesystems.declmime.Util;
import org.netbeans.modules.openide.filesystems.declmime.XMLMIMEComponent;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.MIMEResolver;
import org.openide.util.BaseUtilities;
import org.openide.util.Exceptions;
import org.openide.util.Parameters;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public final class MIMEResolverImpl {
    private static final Logger ERR = Logger.getLogger(MIMEResolverImpl.class.getName());
    static final boolean CASE_INSENSITIVE = BaseUtilities.getOperatingSystem() == 16384;
    private static final int READ_LIMIT = 4000;
    private static Set<String> readLimitReported = new HashSet<String>();
    private static final String MIME_RESOLVERS_PATH = "Services/MIMEResolver";
    private static final String USER_DEFINED_MIME_RESOLVER = "user-defined-mime-resolver";
    private static final int USER_DEFINED_MIME_RESOLVER_POSITION = 10;

    public static MIMEResolver forDescriptor(FileObject fo) throws IOException {
        if (fo.getSize() == 0L && !MIMEResolverImpl.isUserDefined(fo)) {
            return MIMEResolverImpl.create(fo);
        }
        return MIMEResolverImpl.forDescriptor(fo, true);
    }

    static MIMEResolver forDescriptor(FileObject fo, boolean warn) {
        if (warn && !MIMEResolverImpl.isUserDefined(fo)) {
            ERR.log(Level.WARNING, "Ineffective registration of resolver {0} use @MIMEResolver.Registration! See bug #191777.", fo.getPath());
            if (ERR.isLoggable(Level.FINE)) {
                try {
                    ERR.fine(fo.asText());
                }
                catch (IOException ex) {
                    ERR.log(Level.FINE, null, ex);
                }
            }
        }
        return new Impl(fo);
    }

    static MIMEResolver forStream(FileObject def, byte[] serialData) throws IOException {
        return new Impl(def, serialData);
    }

    static byte[] toStream(MIMEResolver mime) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(os);
        ((Impl)mime).writeExternal(dos);
        dos.close();
        return os.toByteArray();
    }

    public static boolean isDeclarative(MIMEResolver resolver) {
        return resolver instanceof Impl;
    }

    public static String[] getMIMETypes(MIMEResolver resolver) {
        ((Impl)resolver).init();
        return ((Impl)resolver).implResolvableMIMETypes;
    }

    public static boolean isUserDefined(FileObject mimeResolverFO) {
        return mimeResolverFO.getAttribute(USER_DEFINED_MIME_RESOLVER) != null || mimeResolverFO.getName().equals(USER_DEFINED_MIME_RESOLVER);
    }

    public static Map<String, Set<String>> getMIMEToExtensions(FileObject fo) {
        Impl impl;
        if (!fo.hasExt("xml") || fo.getSize() == 0L) {
            try {
                impl = (Impl)MIMEResolverImpl.create(fo);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace(ex);
                impl = null;
            }
            catch (IllegalArgumentException ex) {
                if (MIMEResolverImpl.isUserDefined(fo)) {
                    File f = FileUtil.toFile(fo);
                    ERR.log(Level.INFO, "User-defined file association settings are corrupted. Delete file " + (f == null ? fo.getPath() : f.getPath()), ex);
                    impl = null;
                }
                throw ex;
            }
            if (impl == null) {
                return Collections.emptyMap();
            }
            impl.init();
        } else {
            impl = new Impl(fo);
            impl.parseDesc();
        }
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        FileElement[] elements = impl.smell;
        if (elements != null) {
            for (FileElement fileElement : elements) {
                Set previous;
                String mimeType = fileElement.getMimeType();
                if (mimeType == null) continue;
                String[] extensions = fileElement.getExtensions();
                HashSet<String> extensionsSet = new HashSet<String>();
                if (extensions != null) {
                    for (String extension : extensions) {
                        if (extension.length() <= 0) continue;
                        extensionsSet.add(extension);
                    }
                }
                if ((previous = (Set)result.get(mimeType)) != null) {
                    extensionsSet.addAll(previous);
                }
                result.put(mimeType, extensionsSet);
            }
        }
        return result;
    }

    public static FileObject getUserDefinedResolver() {
        FileObject resolversFolder = FileUtil.getConfigFile(MIME_RESOLVERS_PATH);
        if (resolversFolder != null) {
            FileObject[] resolvers;
            for (FileObject resolverFO : resolvers = resolversFolder.getChildren()) {
                if (resolverFO.getAttribute(USER_DEFINED_MIME_RESOLVER) == null) continue;
                return resolverFO;
            }
        }
        return null;
    }

    public static synchronized boolean storeUserDefinedResolver(final Map<String, Set<String>> mimeToExtensions) {
        Parameters.notNull("mimeToExtensions", mimeToExtensions);
        FileObject userDefinedResolverFO = MIMEResolverImpl.getUserDefinedResolver();
        if (userDefinedResolverFO != null) {
            try {
                userDefinedResolverFO.delete();
            }
            catch (IOException e) {
                ERR.log(Level.SEVERE, "Cannot delete resolver " + FileUtil.toFile(userDefinedResolverFO), e);
                return false;
            }
        }
        if (mimeToExtensions.isEmpty()) {
            return false;
        }
        FileUtil.runAtomicAction(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                Document document = XMLUtil.createDocument("MIME-resolver", null, "-//NetBeans//DTD MIME Resolver 1.1//EN", "http://www.netbeans.org/dtds/mime-resolver-1_1.dtd");
                for (Map.Entry entry : mimeToExtensions.entrySet()) {
                    String mimeType = (String)entry.getKey();
                    Set extensions = (Set)entry.getValue();
                    if (extensions.isEmpty()) continue;
                    Element fileElement = document.createElement("file");
                    for (String extension : (Set)mimeToExtensions.get(mimeType)) {
                        Element extElement = document.createElement("ext");
                        extElement.setAttribute("name", extension);
                        fileElement.appendChild(extElement);
                    }
                    Element resolverElement = document.createElement("resolver");
                    resolverElement.setAttribute("mime", mimeType);
                    fileElement.appendChild(resolverElement);
                    document.getDocumentElement().appendChild(fileElement);
                }
                if (!document.getDocumentElement().hasChildNodes()) {
                    return;
                }
                OutputStream os = null;
                FileObject newUserDefinedFO = null;
                FileObject resolversFolder = FileUtil.getConfigFile(MIMEResolverImpl.MIME_RESOLVERS_PATH);
                if (resolversFolder == null) {
                    resolversFolder = FileUtil.createFolder(FileUtil.getConfigRoot(), MIMEResolverImpl.MIME_RESOLVERS_PATH);
                }
                newUserDefinedFO = resolversFolder.createData(MIMEResolverImpl.USER_DEFINED_MIME_RESOLVER, "xml");
                newUserDefinedFO.setAttribute(MIMEResolverImpl.USER_DEFINED_MIME_RESOLVER, Boolean.TRUE);
                newUserDefinedFO.setAttribute("position", 10);
                os = newUserDefinedFO.getOutputStream();
                XMLUtil.write(document, os, "UTF-8");
                if (os == null) return;
                try {
                    os.close();
                    return;
                }
                catch (IOException e) {
                    ERR.log(Level.SEVERE, "Cannot close OutputStream of file " + (newUserDefinedFO == null ? "" : FileUtil.toFile(newUserDefinedFO)), e);
                }
                return;
                catch (IOException e) {
                    try {
                        ERR.log(Level.SEVERE, "Cannot write resolver " + (newUserDefinedFO == null ? "" : FileUtil.toFile(newUserDefinedFO)), e);
                        if (os == null) return;
                    }
                    catch (Throwable throwable) {
                        if (os == null) throw throwable;
                        try {
                            os.close();
                            throw throwable;
                        }
                        catch (IOException e2) {
                            ERR.log(Level.SEVERE, "Cannot close OutputStream of file " + (newUserDefinedFO == null ? "" : FileUtil.toFile(newUserDefinedFO)), e2);
                        }
                        throw throwable;
                    }
                    try {
                        os.close();
                        return;
                    }
                    catch (IOException e3) {
                        ERR.log(Level.SEVERE, "Cannot close OutputStream of file " + (newUserDefinedFO == null ? "" : FileUtil.toFile(newUserDefinedFO)), e3);
                    }
                    return;
                }
            }
        });
        return userDefinedResolverFO == null;
    }

    public static Collection<? extends FileObject> getOrderedResolvers() {
        FileObject[] resolvers = FileUtil.getConfigFile(MIME_RESOLVERS_PATH).getChildren();
        TreeMap orderedResolvers = new TreeMap(Collections.reverseOrder());
        for (FileObject mimeResolverFO : resolvers) {
            Integer position = (Integer)mimeResolverFO.getAttribute("position");
            if (position == null) {
                position = Integer.MAX_VALUE;
            }
            while (orderedResolvers.containsKey(position)) {
                Integer n = position;
                position = position - 1;
            }
            orderedResolvers.put(position, mimeResolverFO);
        }
        return orderedResolvers.values();
    }

    private static FileElement extensionElem(List<String> exts, String mimeType) {
        FileElement e = new FileElement();
        for (String ext : exts) {
            e.fileCheck.addExt(ext);
        }
        e.setMIME(mimeType);
        return e;
    }

    private static MIMEResolver forExts(FileObject def, String mimeType, List<String> exts) throws IOException {
        FileElement[] e = new FileElement[]{MIMEResolverImpl.extensionElem(exts, mimeType)};
        return new Impl(def, e, new String[]{mimeType});
    }

    private static MIMEResolver forXML(FileObject def, String mimeType, List<String> exts, List<String> acceptExts, String elem, List<String> namespace, List<String> dtds) throws IOException {
        FileElement e = new FileElement();
        for (String ext : exts) {
            e.fileCheck.addExt(ext);
        }
        e.rule = new XMLMIMEComponent(elem, namespace, dtds);
        e.setMIME(mimeType);
        if (acceptExts.isEmpty()) {
            return new Impl(def, new FileElement[]{e}, new String[]{mimeType});
        }
        FileElement direct = MIMEResolverImpl.extensionElem(acceptExts, mimeType);
        return new Impl(def, new FileElement[]{e, direct}, new String[]{mimeType});
    }

    public static MIMEResolver create(FileObject fo) throws IOException {
        byte[] arr = (byte[])fo.getAttribute("bytes");
        if (arr != null) {
            return MIMEResolverImpl.forStream(fo, arr);
        }
        String mimeType = (String)fo.getAttribute("mimeType");
        String element = (String)fo.getAttribute("element");
        List<String> exts = MIMEResolverImpl.readArray(fo, "ext.");
        if (element != null) {
            List<String> accept = MIMEResolverImpl.readArray(fo, "accept.");
            List<String> nss = MIMEResolverImpl.readArray(fo, "ns.");
            List<String> dtds = MIMEResolverImpl.readArray(fo, "doctype.");
            return MIMEResolverImpl.forXML(fo, mimeType, exts, accept, element, nss, dtds);
        }
        if (!exts.isEmpty()) {
            return MIMEResolverImpl.forExts(fo, mimeType, exts);
        }
        throw new IllegalArgumentException("" + fo);
    }

    private static List<String> readArray(FileObject fo, String prefix) {
        String ext;
        ArrayList<String> exts = new ArrayList<String>();
        int cnt = 0;
        while ((ext = (String)fo.getAttribute(prefix + cnt++)) != null) {
            exts.add(ext);
        }
        return exts;
    }

    private static final class Impl
    extends MIMEResolver
    implements MIMEResolverProcessor.FilterInfo {
        private final FileObject data;
        private final FileChangeListener listener = new FileChangeAdapter(this){
            final /* synthetic */ Impl this$0;
            {
                this.this$0 = this$0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void fileChanged(FileEvent fe) {
                Impl impl = this.this$0;
                synchronized (impl) {
                    this.this$0.state = (short)0;
                    Impl.access$202(this.this$0, null);
                }
            }
        };
        private FileElement[] smell;
        private short state;
        private String[] implResolvableMIMETypes;

        Impl(FileObject obj) {
            if (ERR.isLoggable(Level.FINE)) {
                ERR.log(Level.FINE, "MIMEResolverImpl.Impl.<init>({0})", obj);
            }
            this.state = 0;
            this.data = obj;
            this.data.addFileChangeListener(FileUtil.weakFileChangeListener(this.listener, this.data));
        }

        private Impl(FileObject def, byte[] serialData) throws IOException {
            this.data = def;
            this.state = 1;
            ByteArrayInputStream is = new ByteArrayInputStream(serialData);
            DataInputStream dis = new DataInputStream(is);
            this.readExternal(dis);
        }

        private Impl(FileObject def, FileElement[] arr, String ... mimeType) throws IOException {
            this.data = def;
            this.implResolvableMIMETypes = mimeType;
            this.smell = arr;
            this.state = (short)1000;
        }

        @Override
        public String findMIMEType(FileObject fo) {
            if (fo.hasExt("xml") && fo.getPath().startsWith(MIMEResolverImpl.MIME_RESOLVERS_PATH)) {
                return null;
            }
            this.init();
            if (this.state == -1) {
                return null;
            }
            FileElement[] smell2 = this.smell;
            for (int i = smell2.length - 1; i >= 0; --i) {
                String s;
                if (ERR.isLoggable(Level.FINE)) {
                    ERR.fine("findMIMEType - smell.resolve.");
                }
                if ((s = smell2[i].resolve(fo)) == null) continue;
                if (s.equals("mime-type-to-exit")) {
                    return null;
                }
                if (ERR.isLoggable(Level.FINE)) {
                    ERR.log(Level.FINE, "MIMEResolverImpl.findMIMEType({0})={1}", new Object[]{fo, s});
                }
                return s;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void init() {
            Impl impl = this;
            synchronized (impl) {
                if (this.state == 0) {
                    this.state = this.parseDesc();
                }
            }
        }

        private short parseDesc() {
            this.smell = new FileElement[0];
            DescParser parser = new DescParser(this.data);
            parser.parse();
            FileElement[] fileElementArray = this.smell = parser.template != null ? parser.template : this.smell;
            if (ERR.isLoggable(Level.FINE)) {
                if (parser.state == -1) {
                    ERR.fine("MIMEResolverImpl.Impl parsing error!");
                } else {
                    StringBuilder buf = new StringBuilder();
                    buf.append("Parse: ");
                    for (int i = 0; i < this.smell.length; ++i) {
                        buf.append('\n').append(this.smell[i]);
                    }
                    ERR.fine(buf.toString());
                }
            }
            if (parser.state != -1) {
                for (int i = 0; i < this.smell.length; ++i) {
                    String mimeType = this.smell[i].getMimeType();
                    if (mimeType == null) continue;
                    this.implResolvableMIMETypes = Util.addString(this.implResolvableMIMETypes, mimeType);
                }
            }
            return parser.state;
        }

        public String toString() {
            return "MIMEResolverImpl.Impl[" + this.data + "]";
        }

        public void writeExternal(DataOutput out) throws IOException {
            this.init();
            if (this.state == -1) {
                throw new IOException();
            }
            Util.writeStrings(out, this.implResolvableMIMETypes);
            out.writeInt(this.smell.length);
            for (FileElement fe : this.smell) {
                fe.writeExternal(out);
            }
        }

        private void readExternal(DataInput in) throws IOException {
            if (this.state != 1) {
                throw new IOException();
            }
            try {
                this.implResolvableMIMETypes = Util.readStrings(in);
                this.smell = new FileElement[in.readInt()];
                for (int i = 0; i < this.smell.length; ++i) {
                    this.smell[i] = new FileElement();
                    this.smell[i].readExternal(in);
                }
                this.state = (short)1000;
            }
            finally {
                if (this.state == 1) {
                    this.state = (short)-1;
                }
            }
        }

        @Override
        public List<String> getExtensions() {
            if (this.smell == null) {
                return Collections.emptyList();
            }
            LinkedList<String> extensions = new LinkedList<String>();
            for (FileElement fe : this.smell) {
                if (fe == null || fe.getExtensions() == null || fe.getNames() != null && !fe.getNames().isEmpty()) continue;
                for (String ext : fe.getExtensions()) {
                    if (ext == null || ext.isEmpty()) continue;
                    extensions.add(ext);
                }
            }
            return extensions;
        }

        @Override
        public List<String> getFileNames() {
            if (this.smell == null) {
                return Collections.emptyList();
            }
            LinkedList<String> fileNames = new LinkedList<String>();
            for (FileElement fe : this.smell) {
                if (fe == null || fe.getNames() == null) continue;
                for (FileElement.Type.FileName name : fe.getNames()) {
                    String[] exts = fe.getExtensions();
                    if (exts == null || exts.length == 0) continue;
                    for (String ext : exts) {
                        fileNames.add(name.toString() + ext);
                    }
                }
            }
            return fileNames;
        }

        static /* synthetic */ String[] access$202(Impl x0, String[] x1) {
            x0.implResolvableMIMETypes = x1;
            return x1;
        }
    }

    private static class DescParser
    extends DefaultParser {
        private FileElement[] template = null;
        private short file_state = 0;
        private XMLMIMEComponent component = null;
        private String componentDelimiter = null;
        private int patternLevel = 0;
        Set<Integer> patternLevelSet;
        private static final short IN_ROOT = 1;
        private static final short IN_FILE = 2;
        private static final short IN_RESOLVER = 3;
        private static final short IN_COMPONENT = 4;
        private static final short IN_PATTERN = 5;
        private static final short IN_EXIT = 1;
        private static final String ROOT = "MIME-resolver";
        private static final String FILE = "file";
        private static final String MIME = "mime";
        private static final String EXT = "ext";
        private static final String RESOLVER = "resolver";
        private static final String FATTR = "fattr";
        private static final String NAME = "name";
        private static final String PATTERN = "pattern";
        private static final String VALUE = "value";
        private static final String RANGE = "range";
        private static final String IGNORE_CASE = "ignorecase";
        private static final String SUBSTRING = "substring";
        private static final String MAGIC = "magic";
        private static final String HEX = "hex";
        private static final String MASK = "mask";
        private static final String TEXT = "text";
        private static final String EXIT = "exit";
        private static final String XML_RULE_COMPONENT = "xml-rule";

        DescParser(FileObject fo) {
            super(fo);
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            switch (this.state) {
                case 0: {
                    if (!ROOT.equals(qName)) {
                        this.error();
                    }
                    this.state = 1;
                    break;
                }
                case 1: {
                    if (!FILE.equals(qName)) {
                        this.error();
                    }
                    if (this.template == null) {
                        this.template = new FileElement[]{new FileElement()};
                    } else {
                        FileElement[] n = new FileElement[this.template.length + 1];
                        System.arraycopy(this.template, 0, n, 1, this.template.length);
                        n[0] = new FileElement();
                        this.template = n;
                    }
                    this.state = (short)2;
                    break;
                }
                case 2: {
                    if (this.file_state == 1) {
                        this.error();
                    }
                    if (EXT.equals(qName)) {
                        String s = atts.getValue(NAME);
                        if (s == null) {
                            this.error();
                        }
                        this.template[0].fileCheck.addExt(s);
                        break;
                    }
                    if (MAGIC.equals(qName)) {
                        String s = atts.getValue(HEX);
                        if (s == null) {
                            this.error();
                        }
                        String mask = atts.getValue(MASK);
                        char[] chars = s.toCharArray();
                        byte[] mask_bytes = null;
                        try {
                            byte[] magic;
                            if (mask != null) {
                                char[] mask_chars = mask.toCharArray();
                                mask_bytes = XMLUtil.fromHex(mask_chars, 0, mask_chars.length);
                            }
                            if (this.template[0].fileCheck.setMagic(magic = XMLUtil.fromHex(chars, 0, chars.length), mask_bytes)) break;
                            this.error();
                        }
                        catch (IOException ioex) {
                            this.error();
                        }
                        break;
                    }
                    if (MIME.equals(qName)) {
                        String s = atts.getValue(NAME);
                        if (s == null) {
                            this.error();
                        }
                        this.template[0].fileCheck.addMIME(s);
                        break;
                    }
                    if (FATTR.equals(qName)) {
                        String s = atts.getValue(NAME);
                        if (s == null) {
                            this.error();
                        }
                        String val = atts.getValue(TEXT);
                        this.template[0].fileCheck.addAttr(s, val);
                        break;
                    }
                    if (PATTERN.equals(qName)) {
                        String s = atts.getValue(VALUE);
                        if (s == null) {
                            this.error();
                        }
                        int range = Integer.valueOf(atts.getValue(RANGE));
                        assert (range <= 4000 || !readLimitReported.add(this.fo.getPath())) : "MIME resolver " + this.fo.getPath() + " should not exceed " + 4000 + " bytes limit for files content check.";
                        boolean ignoreCase = false;
                        String ignoreCaseAttr = atts.getValue(IGNORE_CASE);
                        if (ignoreCaseAttr != null) {
                            ignoreCase = Boolean.valueOf(ignoreCaseAttr);
                        }
                        if (this.file_state == 5) {
                            if (this.patternLevelSet == null) {
                                this.patternLevelSet = new HashSet<Integer>();
                            }
                            if (!this.patternLevelSet.add(this.patternLevel)) {
                                this.error("Second pattern element on the same level not allowed");
                            }
                            this.template[0].fileCheck.addInnerPattern(s, range, ignoreCase);
                        } else {
                            this.template[0].fileCheck.addPattern(s, range, ignoreCase);
                            this.file_state = (short)5;
                        }
                        ++this.patternLevel;
                        break;
                    }
                    if (NAME.equals(qName)) {
                        String s = atts.getValue(NAME);
                        if (s == null) {
                            this.error();
                        }
                        String substringAttr = atts.getValue(SUBSTRING);
                        boolean substring = false;
                        if (substringAttr != null) {
                            substring = Boolean.valueOf(substringAttr);
                        }
                        boolean ignoreCase = true;
                        String ignoreCaseAttr = atts.getValue(IGNORE_CASE);
                        if (ignoreCaseAttr != null) {
                            ignoreCase = Boolean.valueOf(ignoreCaseAttr);
                        }
                        this.template[0].fileCheck.addName(s, substring, ignoreCase);
                        break;
                    }
                    if (RESOLVER.equals(qName)) {
                        String s;
                        if (!this.template[0].fileCheck.isValid()) {
                            this.error();
                        }
                        if ((s = atts.getValue(MIME)) == null) {
                            this.error();
                        }
                        this.template[0].setMIME(s);
                        this.state = (short)3;
                        break;
                    }
                    if (EXIT.equals(qName)) {
                        this.template[0].fileCheck.setExit();
                        this.file_state = 1;
                        break;
                    }
                    String reason = "Unexpected element:  " + qName;
                    this.error(reason);
                    break;
                }
                case 3: {
                    if (!XML_RULE_COMPONENT.equals(qName)) break;
                    this.enterComponent(XML_RULE_COMPONENT, new XMLMIMEComponent());
                    this.component.startElement(namespaceURI, localName, qName, atts);
                    break;
                }
                case 4: {
                    this.component.startElement(namespaceURI, localName, qName, atts);
                    break;
                }
            }
        }

        private void enterComponent(String name, XMLMIMEComponent component) {
            this.component = component;
            this.componentDelimiter = name;
            component.setDocumentLocator(this.getLocator());
            this.template[0].rule = component;
            this.state = (short)4;
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            switch (this.state) {
                case 2: {
                    if (FILE.equals(qName)) {
                        this.state = 1;
                        this.file_state = 0;
                    }
                    if (!PATTERN.equals(qName) || --this.patternLevel != 0) break;
                    this.patternLevelSet = null;
                    this.file_state = 0;
                    break;
                }
                case 3: {
                    if (!RESOLVER.equals(qName)) break;
                    this.state = (short)2;
                    break;
                }
                case 4: {
                    this.component.endElement(namespaceURI, localName, qName);
                    if (!this.componentDelimiter.equals(qName)) break;
                    this.state = (short)3;
                    this.component.setDocumentLocator(null);
                }
            }
        }

        @Override
        public void characters(char[] data, int offset, int len) throws SAXException {
            if (this.state == 4) {
                this.component.characters(data, offset, len);
            }
        }
    }
}

