/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.bugs;

import java.util.LinkedList;
import java.util.List;
import jpt.sun.source.tree.ExpressionTree;
import jpt.sun.source.tree.MemberSelectTree;
import jpt.sun.source.tree.MethodInvocationTree;
import jpt.sun.source.tree.Scope;
import jpt.sun.source.tree.Tree;
import jpt.sun.source.util.TreePath;
import jpt30.lang.model.element.Element;
import jpt30.lang.model.element.ElementKind;
import jpt30.lang.model.element.ExecutableElement;
import jpt30.lang.model.element.TypeElement;
import jpt30.lang.model.type.DeclaredType;
import jpt30.lang.model.type.ExecutableType;
import jpt30.lang.model.type.TypeKind;
import jpt30.lang.model.type.TypeMirror;
import jpt30.lang.model.type.TypeVariable;
import jpt30.lang.model.type.WildcardType;
import jpt30.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.editor.java.Utilities;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.openide.util.NbBundle;

public class CollectionRemove {
    static final String SUPPRESS_WARNING_KEY = "element-type-mismatch";
    static final boolean WARN_FOR_CASTABLE_DEFAULT = true;
    static final String WARN_FOR_CASTABLE_KEY = "warn-for-castable";

    public static List<ErrorDescription> collectionRemove(HintContext ctx) {
        return CollectionRemove.run(ctx, "java.util.Collection.remove(java.lang.Object)", "java.util.Collection.add(java.lang.Object)", 0, 0);
    }

    public static List<ErrorDescription> collectionContains(HintContext ctx) {
        return CollectionRemove.run(ctx, "java.util.Collection.contains(java.lang.Object)", "java.util.Collection.add(java.lang.Object)", 0, 0);
    }

    public static List<ErrorDescription> mapRemove(HintContext ctx) {
        return CollectionRemove.run(ctx, "java.util.Map.remove(java.lang.Object)", "java.util.Map.put(java.lang.Object, java.lang.Object)", 0, 0);
    }

    public static List<ErrorDescription> mapGet(HintContext ctx) {
        return CollectionRemove.run(ctx, "java.util.Map.get(java.lang.Object)", "java.util.Map.put(java.lang.Object, java.lang.Object)", 0, 0);
    }

    public static List<ErrorDescription> mapContainsKey(HintContext ctx) {
        return CollectionRemove.run(ctx, "java.util.Map.containsKey(java.lang.Object)", "java.util.Map.put(java.lang.Object, java.lang.Object)", 0, 0);
    }

    public static List<ErrorDescription> mapContainsValue(HintContext ctx) {
        return CollectionRemove.run(ctx, "java.util.Map.containsValue(java.lang.Object)", "java.util.Map.put(java.lang.Object, java.lang.Object)", 0, 1);
    }

    private static List<ErrorDescription> run(HintContext ctx, String checkMethod, String checkAgainst, int ... parameterMapping) {
        MethodInvocationTree mit = (MethodInvocationTree)ctx.getPath().getLeaf();
        ExpressionTree select = mit.getMethodSelect();
        TreePath method = new TreePath(ctx.getPath(), select);
        Element el = ctx.getInfo().getTrees().getElement(method);
        if (el == null || el.getKind() != ElementKind.METHOD) {
            return null;
        }
        ExecutableElement invoked = (ExecutableElement)el;
        TypeElement owner = (TypeElement)invoked.getEnclosingElement();
        LinkedList<ErrorDescription> result = new LinkedList<ErrorDescription>();
        ExecutableElement toCheckAgainst = CollectionRemove.resolveMethod(ctx.getInfo(), checkAgainst);
        if (toCheckAgainst == null) {
            return null;
        }
        DeclaredType site = switch (select.getKind()) {
            case Tree.Kind.MEMBER_SELECT -> {
                TypeMirror tm = ctx.getInfo().getTrees().getTypeMirror(new TreePath(method, ((MemberSelectTree)select).getExpression()));
                if (tm != null && tm.getKind() == TypeKind.TYPEVAR) {
                    tm = ((TypeVariable)tm).getUpperBound();
                }
                if (tm != null && tm.getKind() == TypeKind.DECLARED) {
                    yield (DeclaredType)tm;
                }
                yield null;
            }
            case Tree.Kind.IDENTIFIER -> {
                for (Scope s = ctx.getInfo().getTrees().getScope(ctx.getPath()); s != null; s = s.getEnclosingScope()) {
                    if (s.getEnclosingClass() == null) continue;
                    for (ExecutableElement ee : ElementFilter.methodsIn(ctx.getInfo().getElements().getAllMembers(s.getEnclosingClass()))) {
                        if (ee != toCheckAgainst && !ctx.getInfo().getElements().overrides(ee, toCheckAgainst, owner)) continue;
                        yield (DeclaredType)s.getEnclosingClass().asType();
                    }
                }
                yield null;
            }
            default -> throw new IllegalStateException();
        };
        if (site == null) {
            return null;
        }
        ExecutableType againstType = (ExecutableType)ctx.getInfo().getTypes().asMemberOf(site, toCheckAgainst);
        assert (parameterMapping.length % 2 == 0);
        for (int cntr = 0; cntr < parameterMapping.length; cntr += 2) {
            String warningKey;
            TypeElement te;
            TypeMirror actualParam = ctx.getInfo().getTrees().getTypeMirror(new TreePath(ctx.getPath(), mit.getArguments().get(parameterMapping[cntr + 0])));
            TypeMirror designedType = org.netbeans.modules.java.hints.errors.Utilities.resolveCapturedType(ctx.getInfo(), againstType.getParameterTypes().get(parameterMapping[cntr + 1]));
            if (designedType.getKind() == TypeKind.WILDCARD && (designedType = ((WildcardType)designedType).getExtendsBound()) == null && (te = ctx.getInfo().getElements().getTypeElement("java.lang.Object")) != null) {
                designedType = te.asType();
            }
            if (designedType == null || ctx.getInfo().getTypes().isAssignable(actualParam, designedType)) continue;
            if (CollectionRemove.compatibleTypes(ctx.getInfo(), actualParam, designedType)) {
                warningKey = "HINT_SuspiciousCall";
                if (!ctx.getPreferences().getBoolean(WARN_FOR_CASTABLE_KEY, true)) {
                    continue;
                }
            } else {
                warningKey = "HINT_SuspiciousCallIncompatibleTypes";
            }
            ExecutableElement checkMethodElement = CollectionRemove.resolveMethod(ctx.getInfo(), checkMethod);
            ExecutableElement enclosingMethod = CollectionRemove.findEnclosingMethod(ctx.getInfo(), ctx.getPath());
            if (enclosingMethod != null && checkMethodElement != null && ctx.getInfo().getElements().overrides(enclosingMethod, checkMethodElement, (TypeElement)checkMethodElement.getEnclosingElement())) continue;
            String semiFQN = checkMethod.substring(0, checkMethod.indexOf(40));
            String warning = NbBundle.getMessage(CollectionRemove.class, warningKey, semiFQN, Utilities.getTypeName(ctx.getInfo(), actualParam, false), Utilities.getTypeName(ctx.getInfo(), designedType, false));
            result.add(ErrorDescriptionFactory.forTree(ctx, ctx.getPath(), warning, new Fix[0]));
        }
        return result;
    }

    private static boolean compatibleTypes(CompilationInfo info, TypeMirror type1, TypeMirror type2) {
        type1 = info.getTypes().erasure(type1);
        type2 = info.getTypes().erasure(type2);
        return info.getTypeUtilities().isCastable(type1, type2);
    }

    private static ExecutableElement resolveMethod(CompilationInfo info, String name) {
        return (ExecutableElement)info.getElementUtilities().findElement(name);
    }

    private static ExecutableElement findEnclosingMethod(CompilationInfo info, TreePath path) {
        Element el;
        while (path != null && path.getLeaf().getKind() != Tree.Kind.CLASS && path.getLeaf().getKind() != Tree.Kind.METHOD) {
            path = path.getParentPath();
        }
        if (path != null && path.getLeaf().getKind() == Tree.Kind.METHOD && (el = info.getTrees().getElement(path)) != null && el.getKind() == ElementKind.METHOD) {
            return (ExecutableElement)el;
        }
        return null;
    }
}

